/* Traitement de certaines tables africaines.
   Copyright  1999, 2000 Progiciels Bourbeau-Pinard inc.
   Franois Pinard <pinard@iro.umontreal.ca>, 1997.  */

#include "common.h"

static const unsigned short ful_data[] =
  {
    160, '/', '_', DONE,
    161, 'B', '[', DONE,
    162, 'D', '[', DONE,
    163, 'G', ']', DONE,
    164, 'K', '[', DONE,
    165, 'P', '[', DONE,
    166, 'T', '[', DONE,
    167, 'S', ']', DONE,
    168, 'N', ']', DONE,
    169, 'N', '[', DONE,
    170, 'D', ']', DONE,
    171, '<', '<', DONE,
    172, 'F', ']', DONE,
    173, '\\', '-', DONE,
    174, 'Y', '[', DONE,
    175, 'G', '[', DONE,
    176, '_', 'D', 'G', DONE,
    177, 'b', '[', DONE,
    178, 'd', '[', DONE,
    179, 'g', ']', DONE,
    180, 'k', '[', DONE,
    181, 'p', '[', DONE,
    182, 't', '[', DONE,
    183, 's', ']', DONE,
    184, 'n', ']', DONE,
    185, 'n', '[', DONE,
    186, 'd', ']', DONE,
    187, '>', '>', DONE,
    188, 'f', ']', DONE,
    189, '?', '^', DONE,
    190, 'y', '[', DONE,
    191, 'g', '[', DONE,
    192, 'A', '`', DONE,
    193, 'A', '\\', '\'', DONE,
    194, 'A', '^', DONE,
    195, 'A', '~', DONE,
    196, 'A', '"', DONE,
    197, 'E', '<', DONE,
    198, 'A', 'E', '+', DONE,
    199, 'C', '\\', ',', DONE,
    200, 'E', '`', DONE,
    201, 'E', '\\', '\'', DONE,
    202, 'E', '^', DONE,
    203, 'E', '"', DONE,
    204, 'I', '`', DONE,
    205, 'I', '\\', '\'', DONE,
    206, 'I', '^', DONE,
    207, 'I', '"', DONE,
    208, 'E', '[', DONE,
    209, 'N', '~', DONE,
    210, 'O', '`', DONE,
    211, 'O', '\\', '\'', DONE,
    212, 'O', '^', DONE,
    213, 'O', '~', DONE,
    214, 'O', '"', DONE,
    215, 'O', 'E', '+', DONE,
    216, 'O', '[', DONE,
    217, 'U', '`', DONE,
    218, 'U', '\\', '\'', DONE,
    219, 'U', '^', DONE,
    220, 'U', '"', DONE,
    221, 'E', '<', '\'', DONE,
    222, 'O', '[', '\'', DONE,
    223, 'V', '[', DONE,
    224, 'a', '`', DONE,
    225, 'a', '\\', '\'', DONE,
    226, 'a', '^', DONE,
    227, 'a', '~', DONE,
    228, 'a', '"', DONE,
    229, 'e', '<', DONE,
    230, 'a', 'e', '+', DONE,
    231, 'c', '\\', ',', DONE,
    232, 'e', '`', DONE,
    233, 'e', '\\', '\'', DONE,
    234, 'e', '^', DONE,
    235, 'e', '"', DONE,
    236, 'i', '`', DONE,
    237, 'i', '\\', '\'', DONE,
    238, 'i', '^', DONE,
    239, 'i', '"', DONE,
    240, 'e', '[', DONE,
    241, 'n', '~', DONE,
    242, 'o', '`', DONE,
    243, 'o', '\\', '\'', DONE,
    244, 'o', '^', DONE,
    245, 'o', '~', DONE,
    246, 'o', '"', DONE,
    247, 'o', 'e', '+', DONE,
    248, 'o', '[', DONE,
    249, 'u', '`', DONE,
    250, 'u', '\\', '\'', DONE,
    251, 'u', '^', DONE,
    252, 'u', '"', DONE,
    253, 'e', '<', '\'', DONE,
    254, 'o', '[', '\'', DONE,
    255, 'v', '[', DONE,
    DONE
  };
/* -- */

static const unsigned short l1_data[] =
  {
    160, '/', '_', DONE,
    161, '!', '<', DONE,
    162, '_', 'C', 't', DONE,
    163, '_', 'P', 'd', DONE,
    164, '_', 'C', 'u', DONE,
    165, '_', 'Y', 'e', DONE,
    166, '_', 'B', 'B', DONE,
    167, '_', 'S', 'E', DONE,
    168, '/', '\\', '"', DONE,
    169, '_', 'C', 'o', DONE,
    170, '_', 'F', 'o', DONE,
    171, '<', '<', DONE,
    172, '_', 'N', 'O', DONE,
    173, '\\', '-', DONE,
    174, '_', 'R', 'g', DONE,
    175, '/', '\\', '=', DONE,
    176, '_', 'D', 'G', DONE,
    177, '_', '+', '-', DONE,
    178, '2', '^', DONE,
    179, '3', '^', DONE,
    180, '/', '\\', '\'', DONE,
    181, '_', 'M', 'y', DONE,
    182, '_', 'P', 'I', DONE,
    183, '_', 'M', 'D', DONE,
    184, '/', '\\', ',', DONE,
    185, '1', '^', DONE,
    186, '_', 'M', 'o', DONE,
    187, '>', '>', DONE,
    188, '_', '1', '4', DONE,
    189, '_', '1', '2', DONE,
    190, '_', '3', '4', DONE,
    191, '?', '<', DONE,
    192, 'A', '`', DONE,
    193, 'A', '\\', '\'', DONE,
    194, 'A', '^', DONE,
    195, 'A', '~', DONE,
    196, 'A', '"', DONE,
    197, 'A', '\\', 'R', DONE,
    198, 'A', 'E', '+', DONE,
    199, 'C', '\\', ',', DONE,
    200, 'E', '`', DONE,
    201, 'E', '\\', '\'', DONE,
    202, 'E', '^', DONE,
    203, 'E', '"', DONE,
    204, 'I', '`', DONE,
    205, 'I', '\\', '\'', DONE,
    206, 'I', '^', DONE,
    207, 'I', '"', DONE,
    208, 'D', '\\', 'x', DONE,
    209, 'N', '~', DONE,
    210, 'O', '`', DONE,
    211, 'O', '\\', '\'', DONE,
    212, 'O', '^', DONE,
    213, 'O', '~', DONE,
    214, 'O', '"', DONE,
    215, '_', 'X', 's', DONE,
    216, 'O', '\\', 'X', DONE,
    217, 'U', '`', DONE,
    218, 'U', '\\', '\'', DONE,
    219, 'U', '^', DONE,
    220, 'U', '"', DONE,
    221, 'Y', '\\', '\'', DONE,
    222, '_', 'T', 'H', DONE,
    223, 's', 's', '+', DONE,
    224, 'a', '`', DONE,
    225, 'a', '\\', '\'', DONE,
    226, 'a', '^', DONE,
    227, 'a', '~', DONE,
    228, 'a', '"', DONE,
    229, 'a', '\\', 'R', DONE,
    230, 'a', 'e', '+', DONE,
    231, 'c', '\\', ',', DONE,
    232, 'e', '`', DONE,
    233, 'e', '\\', '\'', DONE,
    234, 'e', '^', DONE,
    235, 'e', '"', DONE,
    236, 'i', '`', DONE,
    237, 'i', '\\', '\'', DONE,
    238, 'i', '^', DONE,
    239, 'i', '"', DONE,
    240, 'd', '\\', 'x', DONE,
    241, 'n', '~', DONE,
    242, 'o', '`', DONE,
    243, 'o', '\\', '\'', DONE,
    244, 'o', '^', DONE,
    245, 'o', '~', DONE,
    246, 'o', '"', DONE,
    247, '_', 'D', 's', DONE,
    248, 'o', '\\', 'X', DONE,
    249, 'u', '`', DONE,
    250, 'u', '\\', '\'', DONE,
    251, 'u', '^', DONE,
    252, 'u', '"', DONE,
    253, 'y', '\\', '\'', DONE,
    254, '_', 't', 'h', DONE,
    255, 'y', '"', DONE,
    DONE
  };
/* -- */

static const unsigned short lin_data[] =
  {
    160, '/', '_', DONE,
    161, 'E', '[', '`', DONE,
    162, 'E', '[', '\'', DONE,
    163, 'E', '[', '^', DONE,
    164, 'E', '[', '\\', 'v', DONE,
    165, 'O', '[', '`', DONE,
    166, 'O', '[', '\'', DONE,
    167, 'O', '[', '^', DONE,
    168, 'N', ']', DONE,
    169, 'N', '[', DONE,
    170, 'N', '^', DONE,
    171, '<', '<', DONE,
    172, 'N', '"', DONE,
    173, '\\', '-', DONE,
    174, 'Y', '[', DONE,
    175, 'O', '[', '\\', 'v', DONE,
    176, '_', 'D', 'G', DONE,
    177, 'e', '[', '`', DONE,
    178, 'e', '[', '\'', DONE,
    179, 'e', '[', '^', DONE,
    180, 'e', '[', '\\', 'v', DONE,
    181, 'o', '[', '`', DONE,
    182, 'o', '[', '\'', DONE,
    183, 'o', '[', '^', DONE,
    184, 'n', ']', DONE,
    185, 'n', '[', DONE,
    186, 'n', '^', DONE,
    187, '>', '>', DONE,
    188, 'n', '"', DONE,
    189, '?', '^', DONE,
    190, 'y', '[', DONE,
    191, 'o', '[', '\\', 'v', DONE,
    192, 'A', '`', DONE,
    193, 'A', '\\', '\'', DONE,
    194, 'A', '^', DONE,
    195, 'A', '\\', 'v', DONE,
    196, 'A', '"', DONE,
    197, 'E', '<', DONE,
    198, 'A', 'E', '+', DONE,
    199, 'C', '\\', ',', DONE,
    200, 'E', '`', DONE,
    201, 'E', '\\', '\'', DONE,
    202, 'E', '^', DONE,
    203, 'E', '"', DONE,
    204, 'I', '`', DONE,
    205, 'I', '\\', '\'', DONE,
    206, 'I', '^', DONE,
    207, 'I', '"', DONE,
    208, 'E', '[', DONE,
    209, 'N', '~', DONE,
    210, 'O', '`', DONE,
    211, 'O', '\\', '\'', DONE,
    212, 'O', '^', DONE,
    213, 'O', '\\', 'v', DONE,
    214, 'O', '"', DONE,
    215, 'O', 'E', '+', DONE,
    216, 'O', '[', DONE,
    217, 'U', '`', DONE,
    218, 'U', '\\', '\'', DONE,
    219, 'U', '^', DONE,
    220, 'U', '"', DONE,
    221, 'E', '\\', 'v', DONE,
    222, 'I', '\\', 'v', DONE,
    223, 'U', '\\', 'v', DONE,
    224, 'a', '`', DONE,
    225, 'a', '\\', '\'', DONE,
    226, 'a', '^', DONE,
    227, 'a', '\\', 'v', DONE,
    228, 'a', '"', DONE,
    229, 'e', '<', DONE,
    230, 'a', 'e', '+', DONE,
    231, 'c', '\\', ',', DONE,
    232, 'e', '`', DONE,
    233, 'e', '\\', '\'', DONE,
    234, 'e', '^', DONE,
    235, 'e', '"', DONE,
    236, 'i', '`', DONE,
    237, 'i', '\\', '\'', DONE,
    238, 'i', '^', DONE,
    239, 'i', '"', DONE,
    240, 'e', '[', DONE,
    241, 'n', '~', DONE,
    242, 'o', '`', DONE,
    243, 'o', '\\', '\'', DONE,
    244, 'o', '^', DONE,
    245, 'o', '\\', 'v', DONE,
    246, 'o', '"', DONE,
    247, 'o', 'e', '+', DONE,
    248, 'o', '[', DONE,
    249, 'u', '`', DONE,
    250, 'u', '\\', '\'', DONE,
    251, 'u', '^', DONE,
    252, 'u', '"', DONE,
    253, 'e', '\\', 'v', DONE,
    254, 'i', '\\', 'v', DONE,
    255, 'u', '\\', 'v', DONE,
    DONE
  };
/* -- */

bool
module_afrtran (RECODE_OUTER outer)
{
  if (!declare_explode_data (outer, ful_data,
			     "AFRFUL-102-BPI_OCIL", "AFRFUL-103-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-bambara", "AFRFUL-103-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-bra", "AFRFUL-103-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-ewondo", "AFRFUL-103-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-fulfulde", "AFRFUL-103-BPI_OCIL"))
    return false;
  if (!declare_explode_data (outer, l1_data,
			     "ISO-8859-1", "AFRL1-101-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-francais", "AFRL1-101-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-fra", "AFRL1-101-BPI_OCIL"))
    return false;
  if (!declare_explode_data (outer, lin_data,
			     "AFRLIN-104-BPI_OCIL", "AFRLIN-105-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-lingala", "AFRLIN-105-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-lin", "AFRLIN-105-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-sango", "AFRLIN-105-BPI_OCIL"))
    return false;
  if (!declare_alias (outer, "t-wolof", "AFRLIN-105-BPI_OCIL"))
    return false;

  return true;
}

void
delmodule_afrtran (RECODE_OUTER outer)
{
}
