/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#pragma once

#include <arrow/api.h>
#include <arrow/ipc/api.h>

#include <arrow-glib/table.h>

GArrowTable *garrow_table_new_raw(std::shared_ptr<arrow::Table> *arrow_table);
std::shared_ptr<arrow::Table> garrow_table_get_raw(GArrowTable *table);

arrow::ipc::feather::WriteProperties *
garrow_feather_write_properties_get_raw(GArrowFeatherWriteProperties *properties);
