#############################################################
#
# which
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
WHICH_SOURCE:=which.tar.gz
WHICH_SITE:=ftp://ftp.gnu.org/gnu/which
WHICH_CAT:=zcat
endif

WHICH_DIR:=$(BUILD_DIR)/which
WHICH_BINARY:=which
WHICH_TARGET_BINARY:=bin/which

ifneq ($(USE_CVS),true)
which-fetch:
	 $(WGET) -P $(DL_DIR) $(WHICH_SITE)/$(WHICH_SOURCE)

which-source: $(DL_DIR)/$(WHICH_SOURCE)
else
which-source:
endif

WHICH_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d which $(CVS_TAG) $(CVS_PREFIX)which

which-checkout:
	@$(WHICH_CVSCO)

$(WHICH_DIR)/.unpacked: $(DL_DIR)/$(WHICH_SOURCE)
ifneq ($(USE_CVS),true)
	$(WHICH_CAT) $(DL_DIR)/$(WHICH_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(WHICH_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(WHICH_DIR)/
	touch $(WHICH_DIR)/.unpacked

$(WHICH_DIR)/.configured: $(WHICH_DIR)/.unpacked
	(cd $(WHICH_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(WHICH_DIR)/.configured

$(WHICH_DIR)/$(WHICH_BINARY): $(WHICH_DIR)/.configured
	$(MAKE) -C $(WHICH_DIR)

$(TARGET_DIR)/$(WHICH_TARGET_BINARY): $(WHICH_DIR)/$(WHICH_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) STRIP=$(TARGET_CROSS)strip -C $(WHICH_DIR) install-strip
	install -d $(DOC_DIR)/doc/which
	@for f in COPYING EXAMPLES README.alias LICENSE ; do \
		install -m0644 $(WHICH_DIR)/$$f $(DOC_DIR)/doc/which/$$f ;\
	done

which: uclibc $(TARGET_DIR)/$(WHICH_TARGET_BINARY)

which-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(WHICH_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/which
	-$(MAKE) -C $(WHICH_DIR) clean

which-dirclean:
	rm -rf $(WHICH_DIR)
endif

