#
# smtpclient
#
######################################################
ifneq ($(USE_CVS),true)
SMTPCLIENT_SOURCE:=smtpclient.tar.gz
SMTPCLIENT_SITE:=http://www.engelschall.com/sw/smtpclient/distrib/
SMTPCLIENT_CAT:=zcat
SMTPCLIENT_DIR:=$(BUILD_DIR)/smtpclient
else
# using CVS
SMTPCLIENT_DIR:=$(BUILD_DIR)/smtpclient
endif

SMTPCLIENT_BINARY:=smtpclient
SMTPCLIENT_TARGET_BINARY:=usr/bin/$(SMTPCLIENT_BINARY)

ifneq ($(USE_CVS),true)
smtpclient-fetch:
	$(WGET) -P $(DL_DIR) $(SMTPCLIENT_SITE)/$(SMTPCLIENT_SOURCE)

smtpclient-source: $(DL_DIR)/$(SMTPCLIENT_SOURCE)
else
smtpclient-source:
endif

SMTPCLIENT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d smtpclient $(CVS_TAG) $(CVS_PREFIX)smtpclient

smtpclient-checkout:
	@$(SMTPCLIENT_CVSCO)

$(SMTPCLIENT_DIR)/.unpacked: $(DL_DIR)/$(SMTPCLIENT_SOURCE)
ifneq ($(USE_CVS),true)
	$(SMTPCLIENT_CAT) $(DL_DIR)/$(SMTPCLIENT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SMTPCLIENT_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(SMTPCLIENT_DIR)/
	touch $(SMTPCLIENT_DIR)/.unpacked

$(SMTPCLIENT_DIR)/.configured: $(SMTPCLIENT_DIR)/.unpacked
	(cd $(SMTPCLIENT_DIR); rm -rf config.cache; \
                $(TARGET_CONFIGURE_OPTS) \
                CFLAGS="$(TARGET_CFLAGS)" \
                ./configure \
                --target=$(GNU_TARGET_NAME) \
                --host=$(GNU_TARGET_NAME) \
                --build=$(GNU_HOST_NAME) \
                --prefix=$(TARGET_DIR)/usr \
                $(DISABLE_NLS) \
        );
	touch $(SMTPCLIENT_DIR)/.configured

$(SMTPCLIENT_DIR)/$(SMTPCLIENT_BINARY): $(SMTPCLIENT_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(SMTPCLIENT_DIR)

$(TARGET_DIR)/$(SMTPCLIENT_TARGET_BINARY): $(SMTPCLIENT_DIR)/$(SMTPCLIENT_BINARY)
	$(MAKE) CC=$(TARGET_CC) DESTDIR=$(TARGET_DIR) -C $(SMTPCLIENT_DIR) install
	$(STRIP) $(TARGET_DIR)/$(SMTPCLIENT_TARGET_BINARY)
	ln -sf ../usr/bin/$(SMTPCLIENT_BINARY) $(TARGET_DIR)/bin/mail
	install -m0644 $(SMTPCLIENT_DIR)/smtpclient.1 $(TARGET_DIR)/usr/man/man1/
	ln -sf smtpclient.1 $(TARGET_DIR)/usr/man/man1/mail.1
	mkdir -p $(DOC_DIR)/doc/smtpclient
	for f in LICENSE README ; do \
	    install -m0644 $(SMTPCLIENT_DIR)/$$f $(DOC_DIR)/doc/smtpclient/ ; \
	done

smtpclient: uclibc $(TARGET_DIR)/$(SMTPCLIENT_TARGET_BINARY)

smtpclient-clean:
	$(MAKE) -C $(SMTPCLIENT_DIR) clean
	-rm -f $(TARGET_DIR)/bin/mail $(TARGET_DIR)/$(SMTPCLIENT_TARGET_BINARY)
	-rm -rf $(DOC_DIR)/doc/smtpclient

smtpclient-dirclean:
	-rm -rf $(SMTPCLIENT_DIR)

