#############################################################
#
# slang
#
#############################################################
ifneq ($(USE_CVS), true)
SLANG_SOURCE:=slang.tar.gz
SLANG_CAT:=zcat
endif

SLANG_DIR:=$(BUILD_DIR)/slang

SLANG_BINARY:=slang
SLANG_TARGET_BINARY:=usr/sbin/slang

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(SLANG_SOURCE):

slang-source: $(DL_DIR)/$(SLANG_SOURCE)
else
slang-source:
endif

SLANG_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d slang $(CVS_TAG) $(CVS_PREFIX)slang

slang-checkout:
	@$(SLANG_CVSCO)

$(SLANG_DIR)/.unpacked: $(DL_DIR)/$(SLANG_SOURCE)
ifneq ($(USE_CVS), true)
	$(SLANG_CAT) $(DL_DIR)/$(SLANG_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SLANG_CVSCO)
endif
	-cat $(SOURCE_DIR)/slang.patch | patch -p1 -d $(SLANG_DIR)
	-cp $(SOURCE_DIR)/slangtest.sh $(SLANG_DIR)/src/test
	touch  $(SLANG_DIR)/.unpacked

$(SLANG_DIR)/.configured: $(SLANG_DIR)/.unpacked
	(cd $(SLANG_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
	);
	touch $(SLANG_DIR)/.configured

$(SLANG_DIR)/$(SLANG_BINARY): $(SLANG_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(SLANG_DIR)
	-$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(SLANG_DIR)/src/test sltest

$(TARGET_DIR)/$(SLANG_TARGET_BINARY): $(SLANG_DIR)/$(SLANG_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SLANG_DIR) install

slang: uclibc $(TARGET_DIR)/$(SLANG_TARGET_BINARY)

slang-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(SLANG_DIR) uninstall
	-$(MAKE) -C $(SLANG_DIR) clean

slang-dirclean:
	rm -rf $(SLANG_DIR)

