#############################################################
#
# passwd
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PASSWD_SOURCE:=passwd.tar.gz
PASSWD_CAT:=zcat
endif

PASSWD_DIR:=$(BUILD_DIR)/passwd
PASSWD_BINARY:=passwd
PASSWD_TARGET_BINARY:=usr/bin/passwd


ifneq ($(USE_CVS),true)
passwd-fetch:
	 $(WGET) -P $(DL_DIR) $(PASSWD_SITE)/$(PASSWD_SOURCE)

passwd-source: $(DL_DIR)/$(PASSWD_SOURCE)
else
passwd-source:
endif

PASSWD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d passwd $(CVS_TAG) $(CVS_PREFIX)passwd

passwd-checkout:
	@$(PASSWD_CVSCO)

$(PASSWD_DIR)/.unpacked: $(DL_DIR)/$(PASSWD_SOURCE)
ifneq ($(USE_CVS),true)
	$(PASSWD_CAT) $(DL_DIR)/$(PASSWD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PASSWD_CVSCO)
endif
	touch $(PASSWD_DIR)/.unpacked

$(PASSWD_DIR)/$(PASSWD_BINARY): $(PASSWD_DIR)/.unpacked
	$(MAKE) $(TARGET_CONFIGURE_OPTS) BACKLIB=pwdb -C $(PASSWD_DIR)

$(TARGET_DIR)/$(PASSWD_TARGET_BINARY): $(PASSWD_DIR)/$(PASSWD_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(PASSWD_DIR) install
	$(STRIP) $(TARGET_DIR)/$(PASSWD_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/chfn \
		$(TARGET_DIR)/usr/bin/chsh
	install -m0644 $(PASSWD_DIR)/passwd.pamd $(TARGET_DIR)/etc/pam.d/passwd
	install -d $(DOC_DIR)/doc/passwd

passwd: uclibc pam $(TARGET_DIR)/$(PASSWD_TARGET_BINARY)

passwd-clean:
	-rm -f $(TARGET_DIR)/$(PASSWD_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/chfn \
		$(TARGET_DIR)/usr/bin/chsh \
		$(TARGET_DIR)/usr/man/man1/passwd.1 \
		$(TARGET_DIR)/usr/man/man1/chfn.1 \
		$(TARGET_DIR)/usr/man/man1/chsh.1 \
		$(TARGET_DIR)/etc/pam.d/passwd
	-rm -rf $(DOC_DIR)/doc/passwd
	-$(MAKE) -C $(PASSWD_DIR) clean

passwd-dirclean:
	rm -rf $(PASSWD_DIR)

endif

