#############################################################
#
# netkitftp
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITFTP_SOURCE:=netkit-ftp.tar.gz
NETKITFTP_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
NETKITFTP_DIR:=$(BUILD_DIR)/${shell basename $(NETKITFTP_SOURCE) .tar.gz}

NETKITFTP_CAT:=zcat
else
# using CVS
NETKITFTP_DIR:=$(BUILD_DIR)/netkit-ftp
endif

NETKITFTP_BINARY:=ftp/ftp
NETKITFTP_TARGET_BINARY:=usr/bin/ftp
NETKITFTP_PATCH:=$(SOURCE_DIR)/netkitftp.patch

ifneq ($(USE_CVS),true)
netkitftp-fetch:
	 $(WGET) -P $(DL_DIR) $(NETKITFTP_SITE)/$(NETKITFTP_SOURCE)

netkitftp-source: $(DL_DIR)/$(NETKITFTP_SOURCE)
else
netkitftp-source:
endif

NETKITFTP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-ftp $(CVS_TAG) $(CVS_PREFIX)netkit-ftp

netkitftp-checkout:
	@$(NETKITFTP_CVSCO)

$(NETKITFTP_DIR)/.unpacked: $(DL_DIR)/$(NETKITFTP_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITFTP_CAT) $(DL_DIR)/$(NETKITFTP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITFTP_CVSCO)
endif
	touch $(NETKITFTP_DIR)/.unpacked

$(NETKITFTP_DIR)/.configured: $(NETKITFTP_DIR)/.unpacked
	(cd $(NETKITFTP_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITFTP_DIR)/.configured

$(NETKITFTP_DIR)/$(NETKITFTP_BINARY): $(NETKITFTP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITFTP_DIR)

$(TARGET_DIR)/$(NETKITFTP_TARGET_BINARY): $(NETKITFTP_DIR)/$(NETKITFTP_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITFTP_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITFTP_TARGET_BINARY)
	mkdir -p $(DOC_DIR)/doc/netkit-ftp
	for f in BUGS README ; do \
	    install -m0644 $(NETKITFTP_DIR)/$$f $(DOC_DIR)/doc/netkit-ftp/$$f ; \
	done

netkitftp: uclibc $(TARGET_DIR)/$(NETKITFTP_TARGET_BINARY)

netkitftp-clean:
	-rm -f $(TARGET_DIR)/$(NETKITFTP_TARGET_BINARY)
	-$(MAKE) -C $(NETKITFTP_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-ftp

netkitftp-dirclean:
	rm -rf $(NETKITFTP_DIR)

