############################################################
#
# modutils
#
#############################################################

ifneq ($(USE_CVS), true)
MODUTILS_SOURCE:=modutils.tar.gz
MODUTILS_CAT:=zcat
endif

MODUTILS_DIR:=$(BUILD_DIR)/modutils
MODUTILS_BINARY:=insmod
MODUTILS_TARGET_BINARY:=sbin/insmod

MIT:=module-init-tools
MIT_VER:=3.0-pre10
MIT_DIR:=$(MIT)-$(MIT_VER)

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(MODUTILS_SOURCE):

modutils-source: $(DL_DIR)/$(MODUTILS_SOURCE)
else
modutils-source:
endif

MODUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d modutils $(CVS_TAG) $(CVS_PREFIX)modutils

modutils-checkout:
	@$(MODUTILS_CVSCO)

ifneq ($(USE_CVS), true)
$(MODUTILS_DIR)/.unpacked: $(DL_DIR)/$(MODUTILS_SOURCE)
	$(MODUTILS_CAT) $(DL_DIR)/$(MODUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
$(MODUTILS_DIR)/.unpacked:
	@$(MODUTILS_CVSCO)
endif
	-cat $(SOURCE_DIR)/modutils.patch | patch -d $(MODUTILS_DIR)
	cd $(MODUTILS_DIR); ln -s $(MIT_DIR) $(MIT)
	touch  $(MODUTILS_DIR)/.unpacked

$(MODUTILS_DIR)/.configured: $(MODUTILS_DIR)/.unpacked
	cd $(MODUTILS_DIR); autoconf
	touch $(MODUTILS_DIR)/.configured

$(MODUTILS_DIR)/insmod.static: $(MODUTILS_DIR)/.configured
	cd $(MODUTILS_DIR)/$(MIT_DIR); \
	   $(TARGET_CONFIGURE_OPTS); \
	   ./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--enable-zlib; \
	   $(MAKE) $(TARGET_CONFIGURE_OPTS) combined \
		CFLAGS="$(TARGET_CFLAGS) -D_COMBINED_MODUTILS_=1"; \
	cd $(MODUTILS_DIR); \
	   $(TARGET_CONFIGURE_OPTS) \
	   CFLAGS="$(TARGET_CFLAGS)" \
	   ./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--disable-compat-2-0 \
		--disable-kerneld \
		--enable-insmod-static \
		--disable-combined \
		--enable-zlib \
		--disable-strip; \
	 $(MAKE) $(TARGET_CONFIGURE_OPTS) -C obj libobj.a; \
	 $(MAKE) $(TARGET_CONFIGURE_OPTS) -C util libutil.a; \
	 $(MAKE) $(TARGET_CONFIGURE_OPTS) -C insmod insmod.static;\
	 cp insmod/insmod.static $(MODUTILS_DIR)/insmod.static; \
	 $(MAKE) $(TARGET_CONFIGURE_OPTTS) distclean

$(MODUTILS_DIR)/depmod/depmod $(MODUTILS_DIR)/insmod/insmod: $(MODUTILS_DIR)/insmod.static
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(MODUTILS_DIR)/$(MIT_DIR) distclean
	cd $(MODUTILS_DIR)/$(MIT_DIR); \
	   $(TARGET_CONFIGURE_OPTS) \
	   CFLAGS="$(TARGET_CFLAGS) -D_COMBINED_MODUTILS_=1" \
	   ./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--enable-zlib; \
	   $(MAKE) combined $(TARGET_CONFIG_OPTS) \
		CFLAGS="$(TARGET_CFLAGS) -D_COMBINED_MODUTILS_=1" ; \
	   cp -p modprobe.conf.5 ../man; \
	cd $(MODUTILS_DIR); \
	   $(TARGET_CONFIGURE_OPTS) \
	   CFLAGS="$(TARGET_CFLAGS) -D_COMBINED_MODUTILS_=1" \
	   ./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/ \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--disable-compat-2-0 \
		--disable-kerneld \
		--disable-strip \
		--exec-prefix=/ \
		--enable-zlib; \
	   $(MAKE) $(TARGET_CONFIGURE_OPTS) BUILDCC=gcc dep all

modutils: uclibc zlib $(MODUTILS_DIR)/depmod/depmod $(MODUTILS_DIR)/insmod/insmod
	$(MAKE) $(TARGET_CONFIGURE_OPTS) DESTDIR=$(TARGET_DIR) -C $(MODUTILS_DIR) install

modutils-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(MODUTILS_DIR) uninstall
	-$(MAKE) -C $(MODUTILS_DIR) clean

modutils-dirclean:
	rm -rf $(MODUTILS_DIR)

