#############################################################
#
# lprng
#
#############################################################
ifneq ($(USE_CVS), true)
LPRNG_SOURCE:=lprng.tar.gz
LPRNG_CAT:=zcat
endif

LPRNG_DIR:=$(BUILD_DIR)/lprng

LPRNG_SBINTARGETS :=	$(TARGET_DIR)/usr/sbin/lpc \
			$(TARGET_DIR)/usr/sbin/checkpc \
			$(TARGET_DIR)/usr/sbin/lprng_certs \
			$(TARGET_DIR)/usr/sbin/lprng_index_certs

LPRNG_BINTARGETS :=	$(TARGET_DIR)/usr/bin/lpq \
			$(TARGET_DIR)/usr/bin/lprm \
			$(TARGET_DIR)/usr/bin/lpr \
			$(TARGET_DIR)/usr/bin/lpstat

LPRNG_LIBTARGETS :=	$(STAGING_DIR)/usr/lib/liblpr.la \
			$(STAGING_DIR)/usr/lib/liblpr.a

LPRNG_MANTARGETS :=	$(TARGET_DIR)/usr/man/man1/cancel.1 \
			$(TARGET_DIR)/usr/man/man1/checkpc.8 \
			$(TARGET_DIR)/usr/man/man1/lp.1 \
			$(TARGET_DIR)/usr/man/man1/lpbanner.1 \
			$(TARGET_DIR)/usr/man/man8/lpc.8 \
			$(TARGET_DIR)/usr/man/man8/lpd.8 \
			$(TARGET_DIR)/usr/man/man5/lpd.conf.5 \
			$(TARGET_DIR)/usr/man/man5/lpd.perms.5 \
			$(TARGET_DIR)/usr/man/man1/lpf.1 \
			$(TARGET_DIR)/usr/man/man1/lpq.1 \
			$(TARGET_DIR)/usr/man/man1/lpr.1 \
			$(TARGET_DIR)/usr/man/man1/lprm.1 \
			$(TARGET_DIR)/usr/man/man1/lpstat.1 \
			$(TARGET_DIR)/usr/man/man1/monitor.1 \
			$(TARGET_DIR)/usr/man/man1/pclbanner.1 \
			$(TARGET_DIR)/usr/man/man5/printcap.5 \
			$(TARGET_DIR)/usr/man/man1/psbanner.1 \
			$(TARGET_DIR)/usr/man/man1/lprng_certs.1 \
			$(TARGET_DIR)/usr/man/man1/lprng_index_certs.1

LPRNG_TARGETS := 	$(LPRNG_BINTARGETS) $(LPRNG_SBINTARGETS) \
			$(LPRNG_LIBTARGETS) $(LPRNG_MANTARGETS)

LPRNG_CFGTARGETS :=	$(TARGET_DIR)/etc/lpd/lpd.conf \
			$(TARGET_DIR)/etc/lpd/lpd.perms \
			$(TARGET_DIR)/etc/printcap \
			$(TARGET_DIR)/etc/rc.d/init.d/lprng

LPRNG_BINARIES :=	$(LPRNG_DIR)/src/.libs/liblpr.a \
			$(LPRNG_DIR)/src/lpq \
			$(LPRNG_DIR)/src/lprm \
			$(LPRNG_DIR)/src/lpr  \
			$(LPRNG_DIR)/src/lpstat \
			$(LPRNG_DIR)/src/lpc \
			$(LPRNG_DIR)/src/lpd \
			$(LPRNG_DIR)/src/lpf \
			$(LPRNG_DIR)/src/lpbanner \
			$(LPRNG_DIR)/src/pclbanner \
			$(LPRNG_DIR)/src/psbanner \
			$(LPRNG_DIR)/src/checkpc \
			$(LPRNG_DIR)/src/lprng_certs \
			$(LPRNG_DIR)/src/lprng_index_certs

LPRNG_MANS :=		$(LPRNG_DIR)/man/cancel.1 \
			$(LPRNG_DIR)/man/checkpc.8 \
			$(LPRNG_DIR)/man/lp.1 \
			$(LPRNG_DIR)/man/lpbanner.1 \
			$(LPRNG_DIR)/man/lpc.8 \
			$(LPRNG_DIR)/man/lpd.8 \
			$(LPRNG_DIR)/man/lpd.conf.5 \
			$(LPRNG_DIR)/man/lpd.perms.5 \
			$(LPRNG_DIR)/man/lpf.1 \
			$(LPRNG_DIR)/man/lpq.1 \
			$(LPRNG_DIR)/man/lpr.1 \
			$(LPRNG_DIR)/man/lprm.1 \
			$(LPRNG_DIR)/man/lpstat.1 \
			$(LPRNG_DIR)/man/monitor.1 \
			$(LPRNG_DIR)/man/pclbanner.1 \
			$(LPRNG_DIR)/man/printcap.5 \
			$(LPRNG_DIR)/man/psbanner.1 \
			$(LPRNG_DIR)/man/lprng_certs.1 \
			$(LPRNG_DIR)/man/lprng_index_certs.1

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(LPRNG_SOURCE):

lprng-source: $(DL_DIR)/$(LPRNG_SOURCE)
else
lprng-source:
endif

LPRNG_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d lprng $(CVS_TAG) $(CVS_PREFIX)lprng

lprng-checkout:
	@$(LPRNG_CVSCO)

$(LPRNG_DIR)/.unpacked: $(DL_DIR)/$(LPRNG_SOURCE)
ifneq ($(USE_CVS), true)
	$(LPRNG_CAT) $(DL_DIR)/$(LPRNG_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LPRNG_CVSCO)
endif
	-cat $(SOURCE_DIR)/lprng.patch | patch -d $(LPRNG_DIR)
	touch  $(LPRNG_DIR)/.unpacked

$(LPRNG_DIR)/.configured: $(LPRNG_DIR)/.unpacked
	(cd $(LPRNG_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--oldincludedir=/usr/include \
		--disable-rpath \
		--with-openssl-inc=$(STAGING_DIR)/usr/include \
		--with-openssl-lib=$(STAGING_DIR)/usr/lib \
	);
	touch $(LPRNG_DIR)/.configured

$(LPRNG_BINARIES) $(LPRNG_MANS): $(LPRNG_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(LPRNG_DIR)

$(LPRNG_TARGETS): $(LPRNG_BINARIES) $(LPRNG_MANS)
	$(MAKE) DESTDIR=$(TARGET_DIR) STRIP=$(TARGET_CROSS)strip POSTINSTALL=no -C $(LPRNG_DIR) install
	mv $(TARGET_DIR)/usr/lib/liblpr* $(STAGING_DIR)/usr/lib
	install -m 0644 $(LPRNG_DIR)/printcap $(TARGET_DIR)/etc/printcap
	-mkdir -p $(TARGET_DIR)/etc/lpd
	install -m 0644 $(LPRNG_DIR)/lpd.conf $(TARGET_DIR)/etc/lpd/lpd.conf
	install -m 0644 $(LPRNG_DIR)/lpd.perms $(TARGET_DIR)/etc/lpd/lpd.perms
	-mkdir -p $(TARGET_DIR)/var/spoopl/lpd
	install -m 0755 $(LPRNG_DIR)/init.linux $(TARGET_DIR)/etc/rc.d/init.d/lprng

lprng: uclibc initscripts $(LPRNG_TARGETS)

lprng-clean:
	rm -f $(LPRNG_TARGETS)
	rm -f $(LPRNG_CFGTARGETS)
	-$(MAKE) -C $(LPRNG_DIR) clean

lprng-dirclean:
	rm -rf $(LPRNG_DIR)

