#############################################################
#
# lcap
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
LCAP_SOURCE:=lcap.tar.gz
LCAP_SITE:=ftp://ftp.gnu.org/gnu/lcap
LCAP_CAT:=zcat
endif

LCAP_DIR:=$(BUILD_DIR)/lcap
LCAP_BINARY:=lcap
LCAP_TARGET_BINARY:=usr/sbin/lcap

ifneq ($(USE_CVS),true)
lcap-fetch:
	 $(WGET) -P $(DL_DIR) $(LCAP_SITE)/$(LCAP_SOURCE)

lcap-source: $(DL_DIR)/$(LCAP_SOURCE)
else
lcap-source:
endif

LCAP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d lcap $(CVS_TAG) $(CVS_PREFIX)lcap

lcap-checkout:
	@$(LCAP_CVSCO)

$(LCAP_DIR)/.unpacked: $(DL_DIR)/$(LCAP_SOURCE)
ifneq ($(USE_CVS),true)
	$(LCAP_CAT) $(DL_DIR)/$(LCAP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LCAP_CVSCO)
endif
	touch $(LCAP_DIR)/.unpacked

$(LCAP_DIR)/$(LCAP_BINARY): $(LCAP_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) -C $(LCAP_DIR)

$(TARGET_DIR)/$(LCAP_TARGET_BINARY): $(LCAP_DIR)/$(LCAP_BINARY)
	$(MAKE) prefix=$(TARGET_DIR) -C $(LCAP_DIR) install
	install -d $(DOC_DIR)/doc/lcap
	@for f in COPYING README ; do \
		install -m0644 $(LCAP_DIR)/$$f $(DOC_DIR)/doc/lcap/$$f ;\
	done

lcap: uclibc $(TARGET_DIR)/$(LCAP_TARGET_BINARY)

lcap-clean:
	-rm -f $(TARGET_DIR)/$(LCAP_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/usr/man/man8/lcap.8
	-rm -rf $(DOC_DIR)/doc/lcap
	-$(MAKE) -C $(LCAP_DIR) clean

lcap-dirclean:
	rm -rf $(LCAP_DIR)
endif

