#############################################################
#
# flex
#
#############################################################
ifneq ($(USE_CVS), true)
FLEX_SOURCE:=flex.tar.gz
FLEX_SITE:=ftp://ftp.gnu.org/non-gnu/flex
FLEX_CAT:=zcat
endif

FLEX_DIR:=$(BUILD_DIR)/flex
FLEX_LIBRARY:=libfl.a
FLEX_INCLUDE:=FlexLexer.h
FLEX_STAGING_LIBRARY:=usr/lib/$(FLEX_LIBRARY)
FLEX_STAGING_INCLUDE:=usr/include/$(FLEX_INCLUDE)

ifneq ($(USE_CVS),true)
flex-fetch:
	 $(WGET) -P $(DL_DIR) $(FLEX_SITE)/$(FLEX_SOURCE)

flex-source: $(DL_DIR)/$(FLEX_SOURCE)
else
flex-source:
endif

FLEX_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d flex $(CVS_TAG) $(CVS_PREFIX)flex

flex-checkout:
	@$(FLEX_CVSCO)

$(FLEX_DIR)/.unpacked: $(DL_DIR)/$(FLEX_SOURCE)
ifneq ($(USE_CVS), true)
	$(FLEX_CAT) $(DL_DIR)/$(FLEX_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(FLEX_CVSCO)
endif
	-cat $(SOURCE_DIR)/flex.patch | patch -p1 -d $(FLEX_DIR)
	touch  $(FLEX_DIR)/.unpacked

$(FLEX_DIR)/.configured: $(FLEX_DIR)/.unpacked
	(cd $(FLEX_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
	);
	touch  $(FLEX_DIR)/.configured

$(FLEX_DIR)/$(FLEX_LIBRARY): $(FLEX_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(FLEX_DIR)

$(TARGET_DIR)/$(FLEX_STAGING_LIBRARY): $(FLEX_DIR)/$(FLEX_LIBRARY)
	install $(FLEX_DIR)/$(FLEX_LIBRARY) $(STAGING_DIR)/$(FLEX_STAGING_LIBRARY)
	install $(FLEX_DIR)/$(FLEX_INCLUDE) $(STAGING_DIR)/$(FLEX_STAGING_INCLUDE)

flex: uclibc $(TARGET_DIR)/$(FLEX_STAGING_LIBRARY)

flex-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(FLEX_DIR) uninstall
	-$(MAKE) -C $(FLEX_DIR) clean

flex-dirclean:
	rm -rf $(FLEX_DIR)

