#############################################################
#
# console-tools
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
CONSOLE-TOOLS_SOURCE:=console-tools.tar.gz
CONSOLE-TOOLS_CAT:=zcat
endif

CONSOLE-TOOLS_DIR:=$(BUILD_DIR)/console-tools
CONSOLE-TOOLS_BINARY:=vttools/chvt
CONSOLE-TOOLS_TARGET_BINARY:=usr/bin/chvt

ifneq ($(USE_CVS),true)
console-tools-fetch:
	 $(WGET) -P $(DL_DIR) $(CONSOLE-TOOLS_SITE)/$(CONSOLE-TOOLS_SOURCE)

console-tools-source: $(DL_DIR)/$(CONSOLE-TOOLS_SOURCE)
else
console-tools-source:
endif

CONSOLE-TOOLS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d console-tools $(CVS_TAG) $(CVS_PREFIX)console-tools

console-tools-checkout:
	@$(CONSOLE-TOOLS_CVSCO)

$(CONSOLE-TOOLS_DIR)/.unpacked: $(DL_DIR)/$(CONSOLE-TOOLS_SOURCE)
ifneq ($(USE_CVS),true)
	$(CONSOLE-TOOLS_CAT) $(DL_DIR)/$(CONSOLE-TOOLS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(CONSOLE-TOOLS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(CONSOLE-TOOLS_DIR)/
	cat $(SOURCE_DIR)/console-tools.patch | patch -d $(CONSOLE-TOOLS_DIR) -p0
	touch $(CONSOLE-TOOLS_DIR)/Makefile.in
	touch $(CONSOLE-TOOLS_DIR)/.unpacked

$(CONSOLE-TOOLS_DIR)/.configured: $(CONSOLE-TOOLS_DIR)/.unpacked
	(cd $(CONSOLE-TOOLS_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--enable-kbd-compat \
	);
	touch  $(CONSOLE-TOOLS_DIR)/.configured

$(CONSOLE-TOOLS_DIR)/$(CONSOLE-TOOLS_BINARY): $(CONSOLE-TOOLS_DIR)/.configured
	$(MAKE) -C $(CONSOLE-TOOLS_DIR)

$(TARGET_DIR)/$(CONSOLE-TOOLS_TARGET_BINARY): $(CONSOLE-TOOLS_DIR)/$(CONSOLE-TOOLS_BINARY)
	touch $(TARGET_DIR)/.touchme
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(CONSOLE-TOOLS_DIR) install
	@for f in `find $(TARGET_DIR) -type f -newer $(TARGET_DIR)/.touchme -exec file {} \; | grep "ELF.\+not stripped" | cut -d: -f1` ; do \
	    $(STRIP) $$f ;\
	done
	rm -f $(CONSOLE-TOOLS_DIR)/.touchme
	install -d $(DOC_DIR)/doc/console-tools
	@for f in BUGS COPYING COPYING.kbd README ; do \
		install -m0644 $(CONSOLE-TOOLS_DIR)/$$f $(DOC_DIR)/doc/console-tools/$$f ;\
	done

/usr/bin/sgml2html:
	@echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	@echo "@"
	@echo "@ The linuxdoc-tools package must be installed on"
	@echo "@ the build host in order to build console-tools"
	@echo "@"
	@echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	/bin/false

console-tools: uclibc /usr/bin/sgml2html $(TARGET_DIR)/$(CONSOLE-TOOLS_TARGET_BINARY)

console-tools-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(CONSOLE-TOOLS_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/console-tools
	-$(MAKE) -C $(CONSOLE-TOOLS_DIR) clean

console-tools-dirclean:
	rm -rf $(CONSOLE-TOOLS_DIR)
endif

