#############################################################
#
# berkeley db
#
#############################################################
ifneq ($(USE_CVS),true)
DB_SITE:=ftp://sleepycat1.inetu.net/releases
DB_SOURCE:=db4.tar.gz
endif

DB_DIR:=$(BUILD_DIR)/db4

ifneq ($(USE_CVS),true)
berkeleydb-source: $(DL_DIR)/$(DB_SOURCE)
endif

DB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d db4 $(CVS_PREFIX)db4

berkeleydb-checkout:
	@$(DB_CVSCO)

$(DB_DIR)/.dist: $(DL_DIR)/$(DB_SOURCE)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(DB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(DB_CVSCO)
endif
	chmod u+w $(DB_DIR)/dist/config.sub
	cp $(SOURCE_DIR)/config.sub $(DB_DIR)/dist/
	touch  $(DB_DIR)/.dist

$(DB_DIR)/.configured: $(DB_DIR)/.dist
	(cd $(DB_DIR)/build_unix; rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		../dist/configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--disable-java \
		--disable-tcl \
		--disable-compat185 \
		--with-pic \
	);
	touch  $(DB_DIR)/.configured

$(DB_DIR)/build_unix/.libs/libdb-4.1.so: $(DB_DIR)/.configured
	$(MAKE) -C $(DB_DIR)/build_unix

$(STAGING_DIR)/lib/libdb-4.1.so: $(DB_DIR)/build_unix/.libs/libdb-4.1.so
	install -d $(DOC_DIR)/doc/db4
	$(MAKE) \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/db4 \
	    -C $(DB_DIR)/build_unix install;
	chmod a-x $(STAGING_DIR)/lib/libdb*so*
	rm -f $(STAGING_DIR)/bin/db_*

$(TARGET_DIR)/lib/libdb-4.1.so: $(STAGING_DIR)/lib/libdb-4.1.so
	install -d $(DOC_DIR)/doc/db4
	$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/db4 \
	    -C $(DB_DIR)/build_unix install_lib install_utilities install_docs;
	for f in LICENSE README ; do \
		install -m0644 $(DB_DIR)/$$f $(DOC_DIR)/doc/db4/$$f ;\
	done

#berkeleydb-headers: $(TARGET_DIR)/usr/lib/libdb.a

berkeleydb-clean: 
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/db4 \
	    -C $(DB_DIR)/build_unix uninstall-lib uninstall-utilities uninstall-docs
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/db4 \
	    -C $(DB_DIR)/build_unix uninstall
	-rm -rf $(DOC_DIR)/doc/db4
	$(MAKE) -C $(DB_DIR)/build_unix clean

berkeleydb-dirclean: 
	rm -rf $(DB_DIR) 

berkeleydb: uclibc $(TARGET_DIR)/lib/libdb-4.1.so

berkeleydb-fetch:
	$(WGET) -P $(DL_DIR) $(DB_SITE)/$(DB_SOURCE)

