#############################################################
#
# at
#
#############################################################
ifneq ($(USE_CVS),true)
AT_SOURCE:=at.tar.gz
AT_SITE:=http://ftp.debian.org/debian/pool/main/a/at
AT_CAT:=zcat
endif

AT_DIR:=$(BUILD_DIR)/at
ATD_BINARY:=atd
AT_BINARY:= at
ATD_TARGET_BINARY:=usr/sbin/atd
AT_TARGET_BINARY:=usr/bin/at

ifneq ($(USE_CVS),true)
at-source: $(DL_DIR)/$(AT_SOURCE)
else
at-source:
endif

AT_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d at $(CVS_TAG) $(CVS_PREFIX)at

at-checkout: 
	@$(AT_CVSCO)

$(AT_DIR)/.unpacked: $(DL_DIR)/$(AT_SOURCE)
ifneq ($(USE_CVS), true)
	$(AT_CAT) $(DL_DIR)/$(AT_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(AT_CVSCO)
endif
	cat $(SOURCE_DIR)/at.patch | patch -d $(AT_DIR)
	touch  $(AT_DIR)/.unpacked

$(AT_DIR)/.configured: $(AT_DIR)/.unpacked
	(cd $(AT_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--with-atspool=/var/spool/at/spool \
		--with-jobdir=/var/spool/at\
	);
	touch  $(AT_DIR)/.configured

$(AT_DIR)/$(AT_BINARY): $(AT_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(AT_DIR)

$(TARGET_DIR)/$(AT_TARGET_BINARY): $(AT_DIR)/$(AT_BINARY)
	$(MAKE) $(TARGET_CONFIGURE_OPTS) STRIP=$(TARGET_CROSS)strip IROOT=$(TARGET_DIR) -C $(AT_DIR) install
	install -m0755 $(AT_DIR)/redhat/atd.init $(TARGET_DIR)/etc/rc.d/init.d/atd

$(TARGET_DIR)/$(ATD_TARGET_BINARY): $(AT_DIR)/$(ATD_BINARY)

at: uclibc flex initscripts $(TARGET_DIR)/$(AT_TARGET_BINARY) $(TARGET_DIR)/$(ATD_TARGET_BINARY)

at-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(AT_DIR) uninstall
	-rm -rf $(TARGET_DIR)/$(AT_TARGET_BINARY) $(TARGET_DIR)/$(ATD_TARGET_BINARY) 2>/dev/null
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/atd
	-$(MAKE) -C $(AT_DIR) clean

at-dirclean:
	rm -rf $(AT_DIR)

at-fetch:
	 $(WGET) -P $(DL_DIR) $(AT_SITE)/$(AT_SOURCE)

