#############################################################
#
# anacron
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
ANACRON_SOURCE:=anacron.tar.gz
ANACRON_SITE:=http://aleron.dl.sourceforge.net/sourceforge/anacron
ANACRON_CAT:=zcat
endif

ANACRON_DIR:=$(BUILD_DIR)/anacron
ANACRON_BINARY:=anacron
ANACRON_TARGET_BINARY:=usr/sbin/anacron

ifneq ($(USE_CVS),true)
anacron-source: $(DL_DIR)/$(ANACRON_SOURCE)
else
anacron-source:
endif

ANACRON_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d anacron $(CVS_TAG) $(CVS_PREFIX)anacron

anacron-checkout:
	@$(ANACRON_CVSCO)

$(ANACRON_DIR)/.unpacked: $(DL_DIR)/$(ANACRON_SOURCE)
ifneq ($(USE_CVS),true)
	$(ANACRON_CAT) $(DL_DIR)/$(ANACRON_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(ANACRON_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(ANACRON_DIR)/
	touch $(ANACRON_DIR)/.unpacked

$(ANACRON_DIR)/$(ANACRON_BINARY): $(ANACRON_DIR)/.unpacked
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(ANACRON_DIR)

$(TARGET_DIR)/$(ANACRON_TARGET_BINARY): $(ANACRON_DIR)/$(ANACRON_BINARY)
	$(MAKE) PREFIX=$(TARGET_DIR) -C $(ANACRON_DIR) install
	$(STRIP) $(TARGET_DIR)/$(ANACRON_TARGET_BINARY)
	mkdir $(DOC_DIR)/doc/anacron
	@for f in COPYING README ; do \
		install -m0644 $(ANACRON_DIR)/$$f $(DOC_DIR)/doc/anacron/$$f ;\
	done

anacron: uclibc $(TARGET_DIR)/$(ANACRON_TARGET_BINARY)

anacron-clean:
	-rm -f $(TARGET_DIR)/$(ANACRON_TARGET_BINARY)
	-rm -f $(TARGET_DIR)/etc/anacrontab
	-rm -f $(TARGET_DIR)/usr/man/man5/anacrontab.5
	-rm -f $(TARGET_DIR)/usr/man/man8/anacron.8
	-rm -rf $(TARGET_DIR)/var/spool/anacron
	-rm -rf $(DOC_DIR)/doc/anacron
	-$(MAKE) -C $(ANACRON_DIR) clean

anacron-fetch:
	 $(WGET) -P $(DL_DIR) $(ANACRON_SITE)/$(ANACRON_SOURCE)

anacron-dirclean:
	rm -rf $(ANACRON_DIR)
endif

