#!/usr/bin/perl -w

#  This code was developped by IDEALX (http://IDEALX.org/) and
#  contributors (their names can be found in the CONTRIBUTORS file).
#
#                 Copyright (C) 2001-2002 IDEALX
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.

# Purpose of smbldap-groupshow : user (posix,shadow,samba) display
#
# History :
#       . originally by David Le Corfec <david.le-corfec@IDEALX.com>

use strict;
use FindBin;
use FindBin qw($RealBin);
use lib "$RealBin/";
use smbldap_tools;
use Getopt::Std;
my %Options;

my $ok = getopts('?', \%Options);

if ( (!$ok) || (@ARGV < 1) || ($Options{'?'}) ) {
  print "Usage: $0 [-?] group\n";
  print "  -?	show this help message\n";
	exit (1);
}

# Read only first @ARGV
my $group = $ARGV[0];

my $lines = read_group($group);
if (!defined($lines)) {
    print "$0: group $group doesn't exist\n";
    exit (1);
}

print "$lines\n";

exit(0);

############################################################

=head1 NAME

       smbldap-groupshow.pl - Display group informations

=head1 SYNOPSIS

       smbldap-groupshow.pl groupname

=head1 DESCRIPTION

       The smbldap-groupshow.pl command displays informations
       associated with the given group.

=cut

#'
