;; this example shows you how go use listbox widgets in guile/tk
;; notice how the guile version of Tcl's selection is used.

(require 'Gwish)

(use-library tcl)
(use-interface tcl)
(use-interface tclhack)

(require 'debug)

(listbox '.filelist
	 :relief 'raised :borderwidth 2
	 :yscrollcommand ".file_scroll set")

(pack '.filelist :side 'left)

(scrollbar '.file_scroll :command ".filelist yview")
(pack '.file_scroll :side 'right :fill 'y)

(.filelist 'insert 'end "jill")
(.filelist 'insert 'end "janet")
(.filelist 'insert 'end "june")
(.filelist 'insert 'end "julia")
(.filelist 'insert 'end "julie")
(.filelist 'insert 'end "jules")
(.filelist 'insert 'end "john")
(.filelist 'insert 'end "jack")
(.filelist 'insert 'end "jim")
(.filelist 'insert 'end "jason")
(.filelist 'insert 'end "jeremy")
(.filelist 'insert 'end "jonathan")

(bind '.filelist "<Double-Button-1>"
      (tcl-lambda ("%x %y" (number x) (number y))
		  (begin (display "something was double-clicked: ")
			 (display (selection "get"))
			 (display "\n"))))

(tk-main-loop)
