;;;; 	Copyright (C) 1995 Free Software Foundation, Inc.
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; 



(in-package slib)
(export-library guile (require))
(export-library slib (slib-builtins))
(in-module slib)
(use-library guile)
(use-interface guile)
(use-interface slib-hooks)
(export-interface require (require provided? provide))
(export-interface slib-builtins slib-hooks)
(in-interface slib-builtins)



(define slib-module (current-module))
(define slib-library (find-interface 'slib %root-package #t))
(define slib-builtins-interface (find-interface 'slib-builtins slib-library #t))

(define features-interface-assoc
  (map (lambda (feature) (cons feature slib-builtins-interface))
       slib:features))

(define (find-feature-interface feature)
  (cond
   ((assq feature features-interface-assoc) => cdr)
   (else #f)))

;; A feature may be declared by the catalog 
;; to be an alias for a module with a different name
;; or an alias for a different feature.
;; This chases down the links:
;;
(slib:load "slibcat")			; get *catalog*

(define (feature->root-feature feature)
  (or (and (find-feature-interface feature) feature)
      (let ((cat-entry (cdr (or (assq feature *catalog*) '(#f . #f)))))
	(cond ((not cat-entry)	feature)
	      ((symbol? cat-entry) (feature->root-feature cat-entry))
	      ((string? cat-entry) (string->symbol cat-entry))
	      ((pair? cat-entry) (string->symbol (cdr cat-entry)))
	      (else (error 'strange-slib-catalog *catalog*))))))

(define (feature->prereq feature)
  (and (not (find-feature-interface feature))
       (let ((cat-entry (cdr (or (assq feature *catalog*) '(#f . #f)))))
	 (cond ((not cat-entry) #f)
	       ((pair? cat-entry) (car cat-entry))
	       ((symbol? cat-entry) (feature->prereq cat-entry))
	       ((string? cat-entry) #f)
	       (else (error 'strange-slib-catalog *catalog*))))))

(define (provided-in-module? feature module)
  (let ((i (find-feature-interface (feature->root-feature feature))))	       
    (and i (member i (module-uses module)))))

(define (provided? name)
  (provided-in-module? name (current-module)))

(define (provide name)
  (if (not (assq name features-interface-assoc))
      (set! features-interface-assoc
	    (acons name (current-interface) features-interface-assoc)))
  #t)


(define (%load-missing-feature f load-fn)
  (let* ((mod #f)
	 (int #f)
	 (this-mod slib-module)
	 (this-int (find-interface f slib-library #t)))

    (dynamic-wind
     (lambda ()
       (set! mod (current-module))
       (set-current-module this-mod)
       (set! int (current-interface))
       (set-current-interface this-int))

     (lambda () (load-fn f) (provide f))

     (lambda ()
       (set! this-int (current-interface))
       (set-current-interface this-int)
       (set! this-mod (current-module))
       (set-current-module mod)))))

(define (load-missing-feature feature)
  (let ((prereq (feature->prereq feature))
	(f (feature->root-feature feature)))
    (if prereq (require prereq))
    (%load-missing-feature f (if (not prereq)
				 load
				 (case prereq
				   ((macro) macro:load)
				   ((syntactic-closures) synclo:load)
				   ((syntax-case) syncase:load)
				   ((macros-that-work) macwork:load)
				   ((macro-by-example) defmacro:load)
				   ((defmacro) defmacro:load)
				   ((source) slib:load-source)
				   ((compiled) slib:load-compiled)
				   (default load))))))


(define (resolve-feature-interface feature)
  (or (find-feature-interface (feature->root-feature feature))
      (begin
	(load-missing-feature feature)
	(or (find-feature-interface (feature->root-feature feature))
	    (error 'unable-to-load-feature feature)))))

(define (require feature)
  (if (provided? feature)
      #t
      (let ((i (resolve-feature-interface feature)))
	(module-use! (current-module) i))))

(if (not (defined? define-private))
    (define define-private define))

(define %system-define define)

(define define
  (procedure->memoizing-macro
   (lambda (exp env)
     (if (= (length env) 1)
	 `(define-export ,@(cdr exp))
	 `(%system-define ,@(cdr exp))))))




(in-package guile)
(in-module guile)
(use-library guile)
(use-interface require)

