/* wconfig_kvppanel.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2025 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WCONFIG_KVPPANEL_HH
#define WCONFIG_KVPPANEL_HH

#include "wdefines.h"
#include "wconfig_panel.hh"
#include "wconfig_kvp_pool.hh"

class WConfig;

class KVPPanel : public WConfigPanel
{
public:
    KVPPanel( AWindow &basewin, WConfig &baseconfig );
    ~KVPPanel();
    int create() override;
    int saveValues() override;

    /* gui elements callback */
    void run( Widget *, const AGMessage &msg ) override;
private:
    std::string getEntryRepresentation( const WConfigKVPPool::get_entry_result &entry ) const;
    void editEntry( int row );
    void resetToDefault( int row );
    void updateRow( int row );

    FieldListView *m_lv = nullptr;
    Button *m_edit_b = nullptr;
    Button *m_default_b = nullptr;
    std::vector< WConfigKVPPool::get_entry_result > m_entries;
};
 
#endif
