/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef UKUITASKBAR_H
#define UKUITASKBAR_H

#include "../panel/iukuipanel.h"
#include "../panel/iukuipanelplugin.h"
#include "../panel/pluginsettings.h"
#include "../panel/common/ukuigridlayout.h"
#include "ukuitaskgroup.h"
#include "ukuitaskbutton.h"
#include "windowThumbnailManager.h"

#include <QScrollArea>
#include <QScrollBar>
#include <QtDBus/QtDBus>

class PluginSettings;
class UKUITaskBar : public QScrollArea
{
    Q_OBJECT

public:
    explicit UKUITaskBar(IUKUIPanelPlugin *plugin, QWidget* parent = 0);
    virtual ~UKUITaskBar();

    void securityControlWatcher();
    void initQuickLaunchApps();
    void initExistWindows();
    QList<QMap<QString, QVariant>> copyQuicklaunchConfig();
    void addButtonForQuicklanch(QList<QMap<QString, QVariant> > apps);
    bool hasPinnedToTaskbar(QString desktopFileName);
    void securityControlApps(QString mode);
    void removeBlackListApp();
    void addWhiteListApp();
    void realign();
    QString tranWinIdToDesktop(WindowId window);
    QString tranClassNameToDesktop(WindowId window);
    bool acceptWindow(const WindowId& window);
    void saveSettings();
    void appsUnistallWatcher();
    void directoryUpdated(const QString &path);
    QSize calcContextWidgetSize();
    //固定到任务栏事件埋点
    void pinToTaskbarEvent(QString applicationName);

protected:
    void wheelEvent(QWheelEvent* event) override;

    void mousePressEvent(QMouseEvent *event) override;
    void mouseMoveEvent(QMouseEvent *event) override;

    void dragEnterEvent(QDragEnterEvent *event) override;
    void dragMoveEvent(QDragMoveEvent *event) override;
    void dropEvent(QDropEvent *event) override;

public Q_SLOTS:
    void onWindowAdded(const WindowId& window);
    void onWindowRemove(const WindowId& window);
    void pinToTaskbar(QString desktopFileName);
    void unpinFromTaskbar(QString desktopFileName);
    void enterGroupSlot(QList<WindowId> winIdList, QString groupName, int x, int y);
    void leaveGroupSlot(QString groupName);
    void onCurrentDesktopChanged();

private:
    std::unique_ptr<QWidget> m_contextWidget;
    std::unique_ptr<UKUi::GridLayout> m_layout;
    std::unique_ptr<QGSettings> m_gsettings;
    QStringList m_gsettingKeys;
    QDBusInterface *m_interface;
    QString m_mode;
    QStringList m_controlAppList;
    IUKUIPanelPlugin *m_plugin;
    QList<std::shared_ptr<UKUITaskGroup>> m_groupList;
    QMap<WindowId, QString> m_windowId2GroupName;
    bool m_isGrouping;
    bool m_canDragging = false;
    int m_buttonSpan;
    WindowThumbnailManager *m_windowThumbnailManager = nullptr;
    std::unique_ptr<QFileSystemWatcher> m_fsWatcher;
    QMap<QString, QStringList> m_currentContentsMap; //当前每个监控的内容目录列表

    //init CornerMark
    void getInitCornerMarkValue(std::shared_ptr<UKUITaskGroup> &group, const QString &desktopFileName);

};

#endif //UKUITASKBAR_H
