# linescroll

Installation:

```
git clone https://gitlab.com/edneville/linescroll.git
cd linescroll
cargo test && cargo build --release \
&& please install -m755 target/release/linescroll /usr/local/bin
```

# running

tail a log file to linescroll to report how many lines are flowing on average over a time period:

```
$ tail -F /var/service/tinydns/log/main/current | linescroll --noclear --speedonly
   125/sec    125/min    125/5min    125/15min
   123/sec    124/min    124/5min    124/15min
   113/sec    120/min    120/5min    120/15min
   136/sec    124/min    124/5min    124/15min
   121/sec    123/min    123/5min    123/15min
   124/sec    123/min    123/5min    123/15min
   112/sec    122/min    122/5min    122/15min
   111/sec    120/min    120/5min    120/15min
   165/sec    125/min    125/5min    125/15min
   132/sec    126/min    126/5min    126/15min
   110/sec    124/min    124/5min    124/15min
    99/sec    122/min    122/5min    122/15min
   107/sec    121/min    121/5min    121/15min
```

linescroll can read from multiple files provided as filename arguments, optionally combining their stats.

```
$ linescroll \
   /var/log/apache/access.log \
   /var/service/tinydns/log/main/current

     0/sec      5/min      1/5min      0/15min
                                                                  #    128
                                                              #   #
                                                              #   #
                                                              #   #
                                                              #   #
                                                              #   #
                                                              #   #
                                                              #   #
                                                              # ####   0
   171/sec    179/min    188/5min    196/15min
                                                #                      259
                         #                     ##  #
          ### ###        #    ###  # ### # ## ###  # # #   #     # #
          ####### ################## ### ######### ### # ### ##  #####
          ############################################################
          ############################################################
          ############################################################
          ############################################################
          ############################################################ 0
```

Bash sub-shell redirection allows a simple way to graph the number of processes. Below we use two while loops to show the number of processes that `ed` started and the number of processes on the system.

```
$ linescroll <( while true; do pgrep -u ed; sleep 1; done) <(while true; do pgrep -f .; sleep 1; done)
```
