<!--
The text in these markdown comments is instructions that will not appear in the displayed pull request,
and can be deleted.

Please submit pull requests against the develop branch.

Follow the existing code style. Check the tests succeed, including format and lint.
  npm run test
  npm run check

Don't update the CHANGELOG or package version number. That gets done by maintainers when preparing the release.

Commander currently has zero production dependencies. That isn't a hard requirement, but is a simple story. Requests which 
add a dependency are much less likely to be accepted, and we are likely to ask for alternative approaches to avoid the dependency.
-->

## Problem

<!--
What problem are you solving?
What Issues does this relate to?
Show the broken output if appropriate.
-->

## Solution

<!--
How did you solve the problem? 
Show the fixed output if appropriate.

There are a lot of forms of documentation which could need updating for a change in functionality. It
is ok if you want to show us the code to discuss before doing the extra work, and
you should say so in your comments so we focus on the concept first before talking about all the other pieces:

- TypeScript typings
- JSDoc documentation in code
- tests
- README
- examples/
-->

## ChangeLog

<!--
Optional. Suggest a line for adding to the CHANGELOG to summarise your change.
-->
