// DO NOT EDIT
// Generated by JFlex 1.8.1 http://jflex.de/
// source: src/main/jflex/LexScan.flex

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * JFlex 1.8.2                                                             *
 * Copyright (C) 1998-2018  Gerwin Klein <lsf@jflex.de>                    *
 * All rights reserved.                                                    *
 *                                                                         *
 * License: BSD                                                            *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package jflex.core;

import java_cup.runtime.Symbol;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import jflex.core.unicode.IntCharSet;
import jflex.core.unicode.UnicodeProperties;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.performance.Timer;
import jflex.scanner.ScannerException;
import jflex.skeleton.Skeleton;


// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings("FallThrough")
public final class LexScan extends AbstractLexScan implements sym, java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 2;
  public static final int STATELIST = 4;
  public static final int MACROS = 6;
  public static final int REGEXPSTART = 8;
  public static final int REGEXP = 10;
  public static final int JAVA_CODE = 12;
  public static final int STATES = 14;
  public static final int STRING_CONTENT = 16;
  public static final int CHARCLASS = 18;
  public static final int COPY = 20;
  public static final int REPEATEXP = 22;
  public static final int EATWSPNL = 24;
  public static final int CTOR_ARG = 26;
  public static final int REGEXP_CODEPOINT_SEQUENCE = 28;
  public static final int STRING_CODEPOINT_SEQUENCE = 30;
  public static final int CHARCLASS_CODEPOINT = 32;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  4,  5,  6,  7,  7,  8,  8,  9,  9, 
    10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 
    18, 18
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\1\u3a00"+
    "\1\u0100\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\3\u1f00"+
    "\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800"+
    "\1\u4900\1\u1f00\1\u4a00\1\u1f00\1\u4b00\1\u4c00\2\u1f00\3\u0100"+
    "\1\u4d00\1\u4e00\1\u4f00\12\u1f00\4\u0100\1\u5000\17\u1f00\2\u0100"+
    "\1\u5100\41\u1f00\2\u0100\1\u5200\1\u5300\3\u1f00\1\u5400\27\u0100"+
    "\1\u5500\2\u0100\1\u5600\45\u1f00\1\u0100\1\u5700\1\u5800\11\u1f00"+
    "\1\u5900\24\u1f00\1\u5a00\1\u5b00\1\u1f00\1\u5c00\1\u5d00\1\u5e00"+
    "\1\u5f00\2\u1f00\1\u6000\5\u1f00\1\u6100\7\u1f00\1\u6200\1\u6300"+
    "\4\u1f00\1\u6400\21\u1f00\246\u0100\1\u6500\20\u0100\1\u6600\1\u6700"+
    "\25\u0100\1\u6800\34\u0100\1\u6900\14\u1f00\2\u0100\1\u6a00\u0b05\u1f00"+
    "\1\u6b00\1\u6c00\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\10\0\1\1\1\2\1\3\2\4\1\5\16\0\4\6"+
    "\1\2\1\7\1\10\1\6\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\2\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\6\1\37\1\40\1\41\1\42\1\6"+
    "\3\43\1\44\1\45\1\46\10\47\1\50\1\51\1\47"+
    "\1\52\1\53\1\47\1\54\1\47\1\55\3\47\1\56"+
    "\1\57\1\60\1\61\1\47\1\6\1\62\1\63\1\64"+
    "\1\65\1\66\1\67\1\70\1\71\1\72\1\73\1\74"+
    "\1\75\1\76\1\77\1\100\1\101\1\47\1\102\1\103"+
    "\1\104\1\105\1\106\1\107\1\110\1\111\1\47\1\112"+
    "\1\113\1\114\1\115\6\0\1\116\32\0\2\6\4\47"+
    "\4\6\1\47\2\6\1\0\7\6\1\47\4\6\1\47"+
    "\5\6\27\47\1\6\37\47\1\6\u01ca\47\4\6\14\47"+
    "\16\6\5\47\7\6\1\47\1\6\1\47\21\6\160\0"+
    "\5\47\1\6\2\47\2\6\4\47\1\6\1\47\6\6"+
    "\1\47\1\6\3\47\1\6\1\47\1\6\24\47\1\6"+
    "\123\47\1\6\213\47\1\6\5\0\2\6\246\47\1\6"+
    "\46\47\2\6\1\47\7\6\47\47\7\6\1\47\1\6"+
    "\55\0\1\6\1\0\1\6\2\0\1\6\2\0\1\6"+
    "\1\0\10\6\33\47\5\6\3\47\15\6\6\0\5\6"+
    "\1\47\4\6\13\0\1\6\1\0\3\6\53\47\37\0"+
    "\4\6\2\47\1\0\143\47\1\6\1\47\10\0\1\6"+
    "\6\0\2\47\2\0\1\6\4\0\2\47\12\0\3\47"+
    "\2\6\1\47\17\6\1\0\1\47\1\0\36\47\33\0"+
    "\2\6\131\47\13\0\1\47\16\6\12\0\41\47\11\0"+
    "\2\47\4\6\1\47\5\6\26\47\4\0\1\47\11\0"+
    "\1\47\3\0\1\47\5\0\22\6\31\47\3\0\4\6"+
    "\13\47\65\6\25\47\1\6\10\47\26\6\60\0\66\47"+
    "\3\0\1\47\22\0\1\47\7\0\12\47\2\0\2\6"+
    "\12\0\1\6\20\47\3\0\1\6\10\47\2\6\2\47"+
    "\2\6\26\47\1\6\7\47\1\6\1\47\3\6\4\47"+
    "\2\6\1\0\1\47\7\0\2\6\2\0\2\6\3\0"+
    "\1\47\10\6\1\0\4\6\2\47\1\6\3\47\2\0"+
    "\2\6\12\0\4\47\7\6\2\47\4\6\3\0\1\6"+
    "\6\47\4\6\2\47\2\6\26\47\1\6\7\47\1\6"+
    "\2\47\1\6\2\47\1\6\2\47\2\6\1\0\1\6"+
    "\5\0\4\6\2\0\2\6\3\0\3\6\1\0\7\6"+
    "\4\47\1\6\1\47\7\6\14\0\3\47\1\0\13\6"+
    "\3\0\1\6\11\47\1\6\3\47\1\6\26\47\1\6"+
    "\7\47\1\6\2\47\1\6\5\47\2\6\1\0\1\47"+
    "\10\0\1\6\3\0\1\6\3\0\2\6\1\47\17\6"+
    "\2\47\2\0\2\6\12\0\1\6\1\47\7\6\1\47"+
    "\6\0\1\6\3\0\1\6\10\47\2\6\2\47\2\6"+
    "\26\47\1\6\7\47\1\6\2\47\1\6\5\47\2\6"+
    "\1\0\1\47\7\0\2\6\2\0\2\6\3\0\10\6"+
    "\2\0\4\6\2\47\1\6\3\47\2\0\2\6\12\0"+
    "\1\6\1\47\20\6\1\0\1\47\1\6\6\47\3\6"+
    "\3\47\1\6\4\47\3\6\2\47\1\6\1\47\1\6"+
    "\2\47\3\6\2\47\3\6\3\47\3\6\14\47\4\6"+
    "\5\0\3\6\3\0\1\6\4\0\2\6\1\47\6\6"+
    "\1\0\16\6\12\0\11\6\1\47\6\6\4\0\1\6"+
    "\10\47\1\6\3\47\1\6\27\47\1\6\20\47\3\6"+
    "\1\47\7\0\1\6\3\0\1\6\4\0\7\6\2\0"+
    "\1\6\3\47\5\6\2\47\2\0\2\6\12\0\20\6"+
    "\1\47\3\0\1\6\10\47\1\6\3\47\1\6\27\47"+
    "\1\6\12\47\1\6\5\47\2\6\1\0\1\47\7\0"+
    "\1\6\3\0\1\6\4\0\7\6\2\0\7\6\1\47"+
    "\1\6\2\47\2\0\2\6\12\0\1\6\2\47\15\6"+
    "\4\0\1\6\10\47\1\6\3\47\1\6\51\47\2\0"+
    "\1\47\7\0\1\6\3\0\1\6\4\0\1\47\5\6"+
    "\3\47\1\0\7\6\3\47\2\0\2\6\12\0\12\6"+
    "\6\47\2\6\2\0\1\6\22\47\3\6\30\47\1\6"+
    "\11\47\1\6\1\47\2\6\7\47\3\6\1\0\4\6"+
    "\6\0\1\6\1\0\1\6\10\0\6\6\12\0\2\6"+
    "\2\0\15\6\60\47\1\0\2\47\7\0\4\6\10\47"+
    "\10\0\1\6\12\0\47\6\2\47\1\6\1\47\2\6"+
    "\2\47\1\6\1\47\2\6\1\47\6\6\4\47\1\6"+
    "\7\47\1\6\3\47\1\6\1\47\1\6\1\47\2\6"+
    "\2\47\1\6\4\47\1\0\2\47\6\0\1\6\2\0"+
    "\1\47\2\6\5\47\1\6\1\47\1\6\6\0\2\6"+
    "\12\0\2\6\4\47\40\6\1\47\27\6\2\0\6\6"+
    "\12\0\13\6\1\0\1\6\1\0\1\6\1\0\4\6"+
    "\2\0\10\47\1\6\44\47\4\6\24\0\1\6\2\0"+
    "\5\47\13\0\1\6\44\0\11\6\1\0\71\6\53\47"+
    "\24\0\1\47\12\0\6\6\6\47\4\0\4\47\3\0"+
    "\1\47\3\0\2\47\7\0\3\47\4\0\15\47\14\0"+
    "\1\47\17\0\2\6\46\47\1\6\1\47\5\6\1\47"+
    "\2\6\53\47\1\6\115\47\1\6\4\47\2\6\7\47"+
    "\1\6\1\47\1\6\4\47\2\6\51\47\1\6\4\47"+
    "\2\6\41\47\1\6\4\47\2\6\7\47\1\6\1\47"+
    "\1\6\4\47\2\6\17\47\1\6\71\47\1\6\4\47"+
    "\2\6\103\47\2\6\3\0\40\6\20\47\20\6\126\47"+
    "\2\6\6\47\3\6\u016c\47\2\6\21\47\1\6\32\47"+
    "\5\6\113\47\3\6\13\47\7\6\15\47\1\6\4\47"+
    "\3\0\13\6\22\47\3\0\13\6\22\47\2\0\14\6"+
    "\15\47\1\6\3\47\1\6\2\0\14\6\64\47\40\0"+
    "\3\6\1\47\3\6\2\47\1\0\2\6\12\0\41\6"+
    "\4\0\1\6\12\0\6\6\130\47\10\6\5\47\2\0"+
    "\42\47\1\0\1\47\5\6\106\47\12\6\37\47\1\6"+
    "\14\0\4\6\14\0\12\6\12\0\36\47\2\6\5\47"+
    "\13\6\54\47\4\6\32\47\6\6\12\0\46\6\27\47"+
    "\5\0\4\6\65\47\12\0\1\6\35\0\2\6\13\0"+
    "\6\6\12\0\15\6\1\47\10\6\16\0\102\6\5\0"+
    "\57\47\21\0\7\47\4\6\12\0\21\6\11\0\14\6"+
    "\3\0\36\47\15\0\2\47\12\0\54\47\16\0\14\6"+
    "\44\47\24\0\10\6\12\0\3\6\3\47\12\0\44\47"+
    "\2\6\11\47\107\6\3\0\1\6\25\0\4\47\1\0"+
    "\4\47\3\0\2\47\3\0\6\6\300\47\72\0\1\6"+
    "\5\0\26\47\2\6\6\47\2\6\46\47\2\6\6\47"+
    "\2\6\10\47\1\6\1\47\1\6\1\47\1\6\1\47"+
    "\1\6\37\47\2\6\65\47\1\6\7\47\1\6\1\47"+
    "\3\6\3\47\1\6\7\47\3\6\4\47\2\6\6\47"+
    "\4\6\15\47\5\6\3\47\1\6\7\47\16\6\5\0"+
    "\30\6\2\4\5\0\20\6\2\47\23\6\1\47\13\6"+
    "\5\0\1\6\12\0\1\6\1\47\15\6\1\47\20\6"+
    "\15\47\3\6\40\47\20\6\15\0\4\6\1\0\3\6"+
    "\14\0\21\6\1\47\4\6\1\47\2\6\12\47\1\6"+
    "\1\47\3\6\5\47\6\6\1\47\1\6\1\47\1\6"+
    "\1\47\1\6\4\47\1\6\13\47\2\6\4\47\5\6"+
    "\5\47\4\6\1\47\21\6\51\47\u0177\6\57\47\1\6"+
    "\57\47\1\6\205\47\6\6\4\47\3\0\2\47\14\6"+
    "\46\47\1\6\1\47\5\6\1\47\2\6\70\47\7\6"+
    "\1\47\17\6\1\0\27\47\11\6\7\47\1\6\7\47"+
    "\1\6\7\47\1\6\7\47\1\6\7\47\1\6\7\47"+
    "\1\6\7\47\1\6\7\47\1\6\40\0\57\6\1\47"+
    "\325\6\3\47\31\6\11\47\6\0\1\6\5\47\2\6"+
    "\5\47\4\6\126\47\2\6\2\0\2\6\3\47\1\6"+
    "\132\47\1\6\4\47\5\6\52\47\2\6\136\47\21\6"+
    "\33\47\65\6\306\47\112\6\353\47\25\6\215\47\103\6"+
    "\56\47\2\6\15\47\3\6\20\47\12\0\2\47\24\6"+
    "\57\47\1\0\4\6\12\0\1\6\37\47\2\0\120\47"+
    "\2\0\45\6\11\47\2\6\147\47\2\6\44\47\1\6"+
    "\10\47\77\6\13\47\1\0\3\47\1\0\4\47\1\0"+
    "\27\47\5\0\20\6\1\47\7\6\64\47\14\6\2\0"+
    "\62\47\22\0\12\6\12\0\6\6\22\0\6\47\3\6"+
    "\1\47\1\6\1\47\2\6\12\0\34\47\10\0\2\6"+
    "\27\47\15\0\14\6\35\47\3\6\4\0\57\47\16\0"+
    "\16\6\1\47\12\0\6\6\5\47\1\0\12\47\12\0"+
    "\5\47\1\6\51\47\16\0\11\6\3\47\1\0\10\47"+
    "\2\0\2\6\12\0\6\6\27\47\3\6\1\47\3\0"+
    "\62\47\1\0\1\47\3\0\2\47\2\0\5\47\2\0"+
    "\1\47\1\0\1\47\30\6\3\47\2\6\13\47\5\0"+
    "\2\6\3\47\2\0\12\6\6\47\2\6\6\47\2\6"+
    "\6\47\11\6\7\47\1\6\7\47\1\6\53\47\1\6"+
    "\12\47\12\6\163\47\10\0\1\6\2\0\2\6\12\0"+
    "\6\6\244\47\14\6\27\47\4\6\61\47\4\6\u0100\117"+
    "\156\47\2\6\152\47\46\6\7\47\14\6\5\47\5\6"+
    "\1\47\1\0\12\47\1\6\15\47\1\6\5\47\1\6"+
    "\1\47\1\6\2\47\1\6\2\47\1\6\154\47\41\6"+
    "\153\47\22\6\100\47\2\6\66\47\50\6\15\47\3\6"+
    "\20\0\20\6\20\0\3\6\2\47\30\6\3\47\31\6"+
    "\1\47\6\6\5\47\1\6\207\47\2\6\1\0\4\6"+
    "\1\47\13\6\12\0\7\6\32\47\4\6\1\47\1\6"+
    "\32\47\13\6\131\47\3\6\6\47\2\6\6\47\2\6"+
    "\6\47\2\6\3\47\3\6\2\47\3\6\2\47\22\6"+
    "\3\0\4\6\14\47\1\6\32\47\1\6\23\47\1\6"+
    "\2\47\1\6\17\47\2\6\16\47\42\6\173\47\105\6"+
    "\65\47\210\6\1\0\202\6\35\47\3\6\61\47\17\6"+
    "\1\0\37\6\40\47\15\6\36\47\5\6\46\47\5\0"+
    "\5\6\36\47\2\6\44\47\4\6\10\47\1\6\5\47"+
    "\52\6\236\47\2\6\12\0\6\6\44\47\4\6\44\47"+
    "\4\6\50\47\10\6\64\47\234\6\67\47\11\6\26\47"+
    "\12\6\10\47\230\6\6\47\2\6\1\47\1\6\54\47"+
    "\1\6\2\47\3\6\1\47\2\6\27\47\12\6\27\47"+
    "\11\6\37\47\101\6\23\47\1\6\2\47\12\6\26\47"+
    "\12\6\32\47\106\6\70\47\6\6\2\47\100\6\1\47"+
    "\3\0\1\6\2\0\5\6\4\0\4\47\1\6\3\47"+
    "\1\6\33\47\4\6\3\0\4\6\1\0\40\6\35\47"+
    "\3\6\35\47\43\6\10\47\1\6\34\47\2\0\31\6"+
    "\66\47\12\6\26\47\12\6\23\47\15\6\22\47\156\6"+
    "\111\47\67\6\63\47\15\6\63\47\15\6\3\0\65\47"+
    "\17\0\37\6\12\0\17\6\4\0\55\47\13\0\2\6"+
    "\1\0\22\6\31\47\7\6\12\0\6\6\3\0\44\47"+
    "\16\0\1\6\12\0\20\6\43\47\1\0\2\6\1\47"+
    "\11\6\3\0\60\47\16\0\4\47\5\6\3\0\3\6"+
    "\12\0\1\47\1\6\1\47\43\6\22\47\1\6\31\47"+
    "\14\0\6\6\1\0\101\6\7\47\1\6\1\47\1\6"+
    "\4\47\1\6\17\47\1\6\12\47\7\6\57\47\14\0"+
    "\5\6\12\0\6\6\4\0\1\6\10\47\2\6\2\47"+
    "\2\6\26\47\1\6\7\47\1\6\2\47\1\6\5\47"+
    "\2\6\1\0\1\47\7\0\2\6\2\0\2\6\3\0"+
    "\2\6\1\47\6\6\1\0\5\6\5\47\2\0\2\6"+
    "\7\0\3\6\5\0\213\6\65\47\22\0\4\47\5\6"+
    "\12\0\46\6\60\47\24\0\2\47\1\6\1\47\10\6"+
    "\12\0\246\6\57\47\7\0\2\6\11\0\27\6\4\47"+
    "\2\0\42\6\60\47\21\0\3\6\1\47\13\6\12\0"+
    "\46\6\53\47\15\0\10\6\12\0\66\6\32\47\3\6"+
    "\17\0\4\6\12\0\u0166\6\100\47\12\0\25\6\2\47"+
    "\12\0\50\47\7\0\1\47\4\0\10\6\1\0\10\6"+
    "\1\47\13\0\50\47\2\6\4\47\20\0\46\6\71\47"+
    "\7\6\11\47\1\6\45\47\10\0\1\6\10\0\1\47"+
    "\17\6\12\0\30\6\36\47\2\6\26\0\1\6\16\0"+
    "\111\6\7\47\1\6\2\47\1\6\46\47\6\0\3\6"+
    "\1\0\1\6\2\0\1\6\7\0\1\47\1\0\10\6"+
    "\12\0\246\6\232\47\146\6\157\47\21\6\304\47\274\6"+
    "\57\47\321\6\107\47\271\6\71\47\7\6\37\47\1\6"+
    "\12\0\146\6\36\47\2\6\5\0\13\6\60\47\7\0"+
    "\11\6\4\47\14\6\12\0\11\6\25\47\5\6\23\47"+
    "\160\6\105\47\13\6\1\47\56\0\20\6\4\0\15\47"+
    "\100\6\2\47\36\6\355\47\23\6\363\47\15\6\37\47"+
    "\121\6\u018c\47\4\6\153\47\5\6\15\47\3\6\11\47"+
    "\7\6\12\47\3\6\2\0\1\6\4\0\301\6\5\0"+
    "\3\6\26\0\2\6\7\0\36\6\4\0\224\6\3\0"+
    "\273\6\125\47\1\6\107\47\1\6\2\47\2\6\1\47"+
    "\2\6\2\47\2\6\4\47\1\6\14\47\1\6\1\47"+
    "\1\6\7\47\1\6\101\47\1\6\4\47\2\6\10\47"+
    "\1\6\7\47\1\6\34\47\1\6\4\47\1\6\5\47"+
    "\1\6\1\47\3\6\7\47\1\6\u0154\47\2\6\31\47"+
    "\1\6\31\47\1\6\37\47\1\6\31\47\1\6\37\47"+
    "\1\6\31\47\1\6\37\47\1\6\31\47\1\6\37\47"+
    "\1\6\31\47\1\6\10\47\2\6\151\0\4\6\62\0"+
    "\10\6\1\0\16\6\1\0\26\6\5\0\1\6\17\0"+
    "\120\6\7\0\1\6\21\0\2\6\7\0\1\6\2\0"+
    "\1\6\5\0\325\6\305\47\13\6\7\0\51\6\104\47"+
    "\7\0\5\6\12\0\246\6\4\47\1\6\33\47\1\6"+
    "\2\47\1\6\1\47\2\6\1\47\1\6\12\47\1\6"+
    "\4\47\1\6\1\47\1\6\1\47\6\6\1\47\4\6"+
    "\1\47\1\6\1\47\1\6\1\47\1\6\3\47\1\6"+
    "\2\47\1\6\1\47\2\6\1\47\1\6\1\47\1\6"+
    "\1\47\1\6\1\47\1\6\1\47\1\6\2\47\1\6"+
    "\1\47\2\6\4\47\1\6\7\47\1\6\4\47\1\6"+
    "\4\47\1\6\1\47\1\6\12\47\1\6\21\47\5\6"+
    "\3\47\1\6\5\47\1\6\21\47\104\6\327\47\51\6"+
    "\65\47\13\6\336\47\2\6\u0182\47\16\6\u0131\47\37\6"+
    "\36\47\343\6\1\0\36\6\140\0\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27904];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\23\0\4\1\1\2\3\3\1\4\2\5\1\6\3\4"+
    "\1\7\1\10\1\3\1\11\1\4\1\10\3\4\1\3"+
    "\1\12\1\13\1\14\1\4\2\14\1\15\1\4\2\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\15\1\30\1\31\1\15\1\32\1\33\1\34"+
    "\1\35\1\36\3\3\1\37\1\40\1\4\1\41\1\42"+
    "\1\43\2\44\1\45\1\3\1\15\1\46\2\47\1\50"+
    "\1\15\1\51\1\52\1\15\1\53\1\54\3\15\1\3"+
    "\2\43\1\3\2\47\1\3\1\55\1\56\2\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\3\1\65\3\0\1\66"+
    "\1\67\1\0\1\10\3\0\16\10\1\0\1\70\1\0"+
    "\1\71\1\72\2\10\2\0\1\73\1\4\5\0\1\74"+
    "\1\75\2\0\1\76\2\77\1\100\1\76\1\101\1\102"+
    "\1\76\1\103\1\104\1\105\1\106\1\107\1\76\1\110"+
    "\1\111\1\112\1\76\1\113\1\76\2\0\1\114\1\0"+
    "\2\115\10\0\1\116\1\117\2\120\1\116\1\121\1\122"+
    "\1\123\1\124\1\125\2\116\3\0\1\126\1\127\1\130"+
    "\1\76\1\0\1\131\1\132\6\0\1\133\1\60\1\61"+
    "\1\63\1\0\1\134\2\65\3\0\34\10\2\135\2\136"+
    "\1\10\2\137\1\10\12\0\1\77\4\0\1\140\2\0"+
    "\1\141\1\142\5\0\1\120\2\0\1\143\1\0\1\144"+
    "\1\145\3\0\2\146\1\61\1\63\4\0\11\10\1\147"+
    "\12\10\1\150\15\10\10\0\1\151\1\0\1\152\1\0"+
    "\1\153\5\0\1\154\3\0\1\61\1\63\2\0\1\155"+
    "\1\156\5\10\1\157\3\10\1\160\10\10\1\156\7\10"+
    "\1\161\1\10\1\162\12\10\20\0\1\61\1\63\1\0"+
    "\1\163\12\10\1\164\4\10\1\165\15\10\1\0\1\10"+
    "\1\166\3\10\15\0\2\167\3\0\1\61\1\63\1\0"+
    "\3\10\1\170\2\10\1\0\1\171\17\10\1\172\3\10"+
    "\1\173\1\0\4\10\2\0\1\174\12\0\2\175\1\0"+
    "\2\10\2\176\1\10\1\177\2\10\2\200\10\10\1\150"+
    "\1\201\1\202\2\10\2\203\1\173\4\0\1\204\2\10"+
    "\1\205\1\206\7\0\1\207\1\210\4\0\1\211\1\10"+
    "\2\176\2\212\1\213\1\177\1\0\1\10\1\0\1\214"+
    "\2\200\1\215\1\216\2\10\1\0\3\10\2\217\3\10"+
    "\2\203\1\220\1\0\1\173\1\0\1\10\1\0\1\10"+
    "\1\221\1\222\5\0\2\223\2\0\1\10\2\212\1\0"+
    "\1\10\2\0\2\215\1\10\1\0\2\224\1\225\1\10"+
    "\1\0\5\10\2\220\2\173\2\204\1\10\2\0\1\226"+
    "\5\0\1\227\1\177\2\230\4\0\1\230\1\215\1\0"+
    "\2\10\2\0\2\224\1\231\1\225\1\0\1\232\1\10"+
    "\2\233\2\234\1\235\1\220\1\0\1\173\2\0\1\10"+
    "\1\236\3\0\2\237\5\0\2\10\2\0\2\231\1\0"+
    "\1\232\2\240\2\233\1\241\2\234\1\242\2\0\1\204"+
    "\2\243\3\0\2\244\2\0\1\230\1\0\2\10\2\0"+
    "\1\231\1\0\1\225\2\241\2\242\2\173\1\0\2\243"+
    "\1\245\1\0\1\246\1\247\2\250\3\230\1\0\1\10"+
    "\1\216\1\0\1\216\1\241\1\0\1\242\1\0\1\173"+
    "\1\204\2\245\3\0\2\251\1\245\4\0\1\252\3\230";

  private static int [] zzUnpackAction() {
    int [] result = new int[796];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\120\0\240\0\360\0\u0140\0\u0190\0\u01e0\0\u0230"+
    "\0\u0280\0\u02d0\0\u0320\0\u0370\0\u03c0\0\u0410\0\u0460\0\u04b0"+
    "\0\u0500\0\u0550\0\u05a0\0\u05f0\0\u0640\0\u0690\0\u06e0\0\u0730"+
    "\0\u0780\0\u07d0\0\u0640\0\u0820\0\u0640\0\u0870\0\u08c0\0\u0910"+
    "\0\u0960\0\u09b0\0\u0a00\0\u0a50\0\u0aa0\0\u0af0\0\u0b40\0\u0b90"+
    "\0\u0be0\0\u0640\0\u0c30\0\u0c80\0\u0cd0\0\u0640\0\u0640\0\u0d20"+
    "\0\u0d70\0\u0c80\0\u0640\0\u0dc0\0\u0e10\0\u0e60\0\u0640\0\u0640"+
    "\0\u0640\0\u0640\0\u0640\0\u0640\0\u0640\0\u0640\0\u0eb0\0\u0f00"+
    "\0\u0640\0\u0f50\0\u0fa0\0\u0640\0\u0ff0\0\u1040\0\u0640\0\u1090"+
    "\0\u10e0\0\u1130\0\u1180\0\u0640\0\u0640\0\u11d0\0\u0640\0\u1220"+
    "\0\u1270\0\u0640\0\u12c0\0\u0640\0\u1310\0\u1360\0\u1360\0\u1360"+
    "\0\u13b0\0\u0640\0\u1400\0\u1450\0\u0f50\0\u14a0\0\u0640\0\u0640"+
    "\0\u14f0\0\u1540\0\u1590\0\u15e0\0\u0640\0\u1630\0\u1680\0\u0640"+
    "\0\u16d0\0\u1720\0\u0640\0\u1770\0\u0640\0\u16d0\0\u17c0\0\u1810"+
    "\0\u0640\0\u1860\0\u0640\0\u18b0\0\u1900\0\u1950\0\u19a0\0\u0780"+
    "\0\u0640\0\u0640\0\u07d0\0\u19f0\0\u1a40\0\u1a90\0\u1ae0\0\u1b30"+
    "\0\u1b80\0\u1bd0\0\u1c20\0\u1c70\0\u1cc0\0\u1d10\0\u1d60\0\u1db0"+
    "\0\u1e00\0\u1e50\0\u1ea0\0\u1ef0\0\u1f40\0\u1f90\0\u0640\0\u1fe0"+
    "\0\u0640\0\u2030\0\u2080\0\u20d0\0\u0be0\0\u0c80\0\u0640\0\u2120"+
    "\0\u2170\0\u0d20\0\u21c0\0\u0e10\0\u2210\0\u0ff0\0\u0640\0\u2260"+
    "\0\u22b0\0\u0640\0\u2300\0\u2350\0\u0640\0\u23a0\0\u0640\0\u0640"+
    "\0\u23f0\0\u0640\0\u0640\0\u0640\0\u0640\0\u0640\0\u2440\0\u0640"+
    "\0\u0640\0\u0640\0\u2490\0\u0640\0\u24e0\0\u0ff0\0\u2530\0\u2580"+
    "\0\u1040\0\u0640\0\u25d0\0\u10e0\0\u1130\0\u1180\0\u2620\0\u2670"+
    "\0\u26c0\0\u2710\0\u2760\0\u0640\0\u0640\0\u27b0\0\u2800\0\u2850"+
    "\0\u0640\0\u0640\0\u0640\0\u0640\0\u0640\0\u28a0\0\u28f0\0\u1360"+
    "\0\u0f50\0\u2940\0\u0640\0\u0640\0\u0640\0\u2990\0\u29e0\0\u0640"+
    "\0\u0640\0\u15e0\0\u2a30\0\u2a80\0\u2ad0\0\u2b20\0\u1720\0\u2b70"+
    "\0\u2bc0\0\u2c10\0\u2c60\0\u2cb0\0\u0640\0\u0640\0\u2d00\0\u2d50"+
    "\0\u2da0\0\u2df0\0\u2e40\0\u2e90\0\u2ee0\0\u2f30\0\u2f80\0\u2fd0"+
    "\0\u3020\0\u3070\0\u30c0\0\u3110\0\u3160\0\u31b0\0\u3200\0\u3250"+
    "\0\u32a0\0\u32f0\0\u3340\0\u3390\0\u33e0\0\u3430\0\u3480\0\u34d0"+
    "\0\u3520\0\u3570\0\u35c0\0\u3610\0\u3660\0\u36b0\0\u0640\0\u3700"+
    "\0\u3750\0\u37a0\0\u37f0\0\u3840\0\u3890\0\u38e0\0\u3930\0\u3980"+
    "\0\u23a0\0\u2440\0\u39d0\0\u3a20\0\u3a70\0\u3ac0\0\u3b10\0\u3b60"+
    "\0\u0640\0\u3bb0\0\u3c00\0\u3c50\0\u3ca0\0\u0640\0\u3cf0\0\u3d40"+
    "\0\u0640\0\u0640\0\u3d90\0\u3de0\0\u3e30\0\u3e80\0\u3ed0\0\u0640"+
    "\0\u3f20\0\u3f70\0\u0640\0\u3fc0\0\u0640\0\u0640\0\u4010\0\u4060"+
    "\0\u40b0\0\u0640\0\u4100\0\u4150\0\u41a0\0\u41f0\0\u4240\0\u4290"+
    "\0\u42e0\0\u4330\0\u4380\0\u43d0\0\u4420\0\u4470\0\u44c0\0\u4510"+
    "\0\u4560\0\u45b0\0\u4600\0\u4650\0\u46a0\0\u46f0\0\u4740\0\u4790"+
    "\0\u47e0\0\u4830\0\u4880\0\u48d0\0\u4920\0\u4970\0\u49c0\0\u4a10"+
    "\0\u4a60\0\u4ab0\0\u4b00\0\u4b50\0\u4ba0\0\u4bf0\0\u4c40\0\u4c90"+
    "\0\u4ce0\0\u4d30\0\u4d80\0\u4dd0\0\u4e20\0\u4e70\0\u4ec0\0\u4f10"+
    "\0\u4f60\0\u4fb0\0\u5000\0\u0640\0\u5050\0\u0640\0\u24e0\0\u0640"+
    "\0\u50a0\0\u50f0\0\u5140\0\u5190\0\u28f0\0\u0640\0\u51e0\0\u5230"+
    "\0\u5280\0\u52d0\0\u5320\0\u5370\0\u53c0\0\u0640\0\u0640\0\u5410"+
    "\0\u5460\0\u54b0\0\u5500\0\u5550\0\u19f0\0\u55a0\0\u55f0\0\u5640"+
    "\0\u19f0\0\u5690\0\u56e0\0\u5730\0\u5780\0\u57d0\0\u5820\0\u5870"+
    "\0\u58c0\0\u19f0\0\u5910\0\u5960\0\u59b0\0\u5a00\0\u5a50\0\u5aa0"+
    "\0\u5af0\0\u19f0\0\u5b40\0\u19f0\0\u5b90\0\u5be0\0\u5c30\0\u5c80"+
    "\0\u5cd0\0\u5d20\0\u5d70\0\u5dc0\0\u5e10\0\u5e60\0\u5eb0\0\u5f00"+
    "\0\u5f50\0\u5fa0\0\u5ff0\0\u6040\0\u6090\0\u60e0\0\u6130\0\u6180"+
    "\0\u61d0\0\u6220\0\u6270\0\u62c0\0\u6310\0\u6360\0\u63b0\0\u6400"+
    "\0\u6450\0\u0640\0\u64a0\0\u64f0\0\u6540\0\u6590\0\u65e0\0\u6630"+
    "\0\u6680\0\u66d0\0\u6720\0\u6770\0\u19f0\0\u67c0\0\u6810\0\u6860"+
    "\0\u68b0\0\u19f0\0\u6900\0\u6950\0\u69a0\0\u69f0\0\u6a40\0\u6a90"+
    "\0\u6ae0\0\u6b30\0\u6b80\0\u6bd0\0\u6c20\0\u6c70\0\u6cc0\0\u6d10"+
    "\0\u6d60\0\u19f0\0\u6db0\0\u6e00\0\u6e50\0\u6ea0\0\u6ef0\0\u6f40"+
    "\0\u6f90\0\u6fe0\0\u7030\0\u7080\0\u70d0\0\u7120\0\u7170\0\u71c0"+
    "\0\u7210\0\u7260\0\u0640\0\u72b0\0\u7300\0\u7350\0\u73a0\0\u0640"+
    "\0\u0640\0\u73f0\0\u7440\0\u7490\0\u74e0\0\u19f0\0\u7530\0\u7580"+
    "\0\u75d0\0\u19f0\0\u7620\0\u7670\0\u76c0\0\u7710\0\u7760\0\u77b0"+
    "\0\u7800\0\u7850\0\u78a0\0\u78f0\0\u7940\0\u7990\0\u79e0\0\u7a30"+
    "\0\u7a80\0\u19f0\0\u7ad0\0\u7b20\0\u7b70\0\u7bc0\0\u7c10\0\u7c60"+
    "\0\u7cb0\0\u3750\0\u7d00\0\u7d50\0\u7da0\0\u7df0\0\u7e40\0\u7e90"+
    "\0\u7ee0\0\u7f30\0\u7f80\0\u7fd0\0\u8020\0\u8070\0\u80c0\0\u8110"+
    "\0\u0640\0\u8160\0\u81b0\0\u8200\0\u8250\0\u82a0\0\u82f0\0\u8340"+
    "\0\u8390\0\u83e0\0\u8430\0\u8480\0\u84d0\0\u8520\0\u8570\0\u85c0"+
    "\0\u8610\0\u8660\0\u86b0\0\u8700\0\u8750\0\u19f0\0\u19f0\0\u19f0"+
    "\0\u87a0\0\u87f0\0\u8840\0\u8890\0\u88e0\0\u8930\0\u8980\0\u89d0"+
    "\0\u8a20\0\u8a70\0\u8ac0\0\u3840\0\u0640\0\u0640\0\u8b10\0\u8b60"+
    "\0\u8bb0\0\u8c00\0\u8c50\0\u8ca0\0\u8cf0\0\u0640\0\u0640\0\u8d40"+
    "\0\u8d90\0\u8de0\0\u8e30\0\u19f0\0\u8e80\0\u8ed0\0\u8f20\0\u8f70"+
    "\0\u8fc0\0\u19f0\0\u9010\0\u9060\0\u90b0\0\u9100\0\u19f0\0\u9150"+
    "\0\u91a0\0\u91f0\0\u9240\0\u9290\0\u92e0\0\u9330\0\u9380\0\u93d0"+
    "\0\u9420\0\u9470\0\u94c0\0\u9510\0\u9560\0\u95b0\0\u9600\0\u9650"+
    "\0\u96a0\0\u96f0\0\u9740\0\u9790\0\u97e0\0\u9830\0\u9880\0\u98d0"+
    "\0\u0640\0\u9920\0\u9970\0\u99c0\0\u9a10\0\u9a60\0\u0640\0\u9ab0"+
    "\0\u9b00\0\u9b50\0\u9ba0\0\u9bf0\0\u9c40\0\u9c90\0\u9ce0\0\u9d30"+
    "\0\u9d80\0\u9dd0\0\u9e20\0\u9e70\0\u9ec0\0\u9f10\0\u9f60\0\u9fb0"+
    "\0\ua000\0\ua050\0\ua0a0\0\ua0f0\0\ua140\0\ua190\0\ua1e0\0\ua230"+
    "\0\ua280\0\ua2d0\0\ua320\0\ua370\0\ua3c0\0\ua410\0\ua460\0\ua4b0"+
    "\0\u0640\0\ua500\0\ua550\0\ua5a0\0\ua5f0\0\ua640\0\u19f0\0\ua690"+
    "\0\u9ce0\0\ua6e0\0\ua730\0\ua780\0\ua7d0\0\ua820\0\u9d80\0\ua870"+
    "\0\ua8c0\0\ua910\0\ua960\0\ua9b0\0\uaa00\0\uaa50\0\uaaa0\0\uaaf0"+
    "\0\uab40\0\uab90\0\uabe0\0\uac30\0\uac80\0\uacd0\0\uad20\0\uad70"+
    "\0\u19f0\0\uadc0\0\uae10\0\uae60\0\uaeb0\0\uaf00\0\uaf50\0\u0640"+
    "\0\uafa0\0\uaff0\0\ub040\0\u0640\0\ub090\0\ub0e0\0\ub130\0\ub180"+
    "\0\ub1d0\0\ub220\0\ub270\0\ub2c0\0\ub310\0\ub360\0\ub3b0\0\ub400"+
    "\0\ub450\0\ub4a0\0\ub4f0\0\ub540\0\ub590\0\ub5e0\0\ub630\0\ub680"+
    "\0\ub6d0\0\ub720\0\ub770\0\ub7c0\0\ub810\0\ub860\0\ub8b0\0\ub900"+
    "\0\ub950\0\ub9a0\0\u0640\0\ub9f0\0\uba40\0\uba90\0\ub1d0\0\ubae0"+
    "\0\ubb30\0\ubb80\0\ubbd0\0\ubc20\0\ubc70\0\ubcc0\0\ubd10\0\ubd60"+
    "\0\ubdb0\0\ube00\0\ube50\0\ubea0\0\ubef0\0\ubf40\0\ubf90\0\ubfe0"+
    "\0\uc030\0\uc080\0\u0640\0\u0640\0\u0640\0\uc0d0\0\uba90\0\ubae0"+
    "\0\uc120\0\uc170\0\uc1c0\0\u19f0\0\uc210\0\u0640\0\uc260\0\uc2b0"+
    "\0\uc300\0\uc350\0\uc3a0\0\ubf40\0\uc3f0\0\uc440\0\uc490\0\uc4e0"+
    "\0\uc530\0\u19f0\0\u0640\0\uc580\0\uc5d0\0\uc620\0\uc670\0\uc6c0"+
    "\0\u0640\0\uc670\0\uc6c0\0\uc710";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[796];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\3\24\2\25\1\26\4\24\1\27\103\24\1\25\1\0"+
    "\17\30\1\31\4\30\1\32\73\30\2\33\1\34\2\35"+
    "\1\36\3\33\1\37\7\33\1\40\21\33\13\37\4\33"+
    "\30\37\4\33\1\35\1\0\1\33\2\41\3\42\3\33"+
    "\1\43\1\44\11\33\1\45\13\33\1\46\2\33\13\43"+
    "\4\33\30\43\4\33\1\42\1\0\1\33\2\47\3\42"+
    "\3\33\1\43\1\50\11\33\1\45\13\33\1\46\2\33"+
    "\13\43\4\33\30\43\4\33\1\42\1\0\1\33\2\51"+
    "\2\52\1\53\16\33\1\54\12\33\1\55\54\33\1\56"+
    "\1\33\1\52\1\0\1\57\2\60\2\52\1\53\4\57"+
    "\1\61\11\57\1\62\12\57\1\55\54\57\1\56\1\57"+
    "\1\52\1\57\1\63\2\64\2\65\1\66\1\63\1\67"+
    "\1\70\1\71\3\63\1\72\1\73\1\74\1\75\2\63"+
    "\1\76\1\77\12\63\1\100\2\63\1\101\13\63\1\102"+
    "\1\103\1\63\1\104\30\63\1\105\1\106\1\63\1\107"+
    "\1\65\1\0\10\110\1\111\3\110\1\112\7\110\1\113"+
    "\65\110\1\114\1\110\1\115\3\110\1\33\5\116\3\33"+
    "\1\43\7\33\1\117\17\33\1\120\1\33\13\43\4\33"+
    "\30\43\4\33\1\116\1\0\3\121\2\122\1\123\2\121"+
    "\1\124\46\121\1\125\36\121\1\122\1\121\1\63\2\126"+
    "\1\127\1\130\1\131\2\63\1\132\2\63\1\133\6\63"+
    "\1\134\33\63\1\135\1\136\1\137\1\140\30\63\1\141"+
    "\1\142\1\63\1\143\1\130\1\0\3\144\2\145\1\146"+
    "\4\144\1\147\103\144\1\145\1\0\1\33\2\41\2\150"+
    "\1\151\13\33\1\152\72\33\1\153\1\33\1\150\1\0"+
    "\1\33\5\154\110\33\1\154\1\0\5\155\1\156\3\155"+
    "\1\157\31\155\13\157\4\155\30\157\6\155\1\33\5\116"+
    "\17\33\11\160\5\33\4\160\13\33\6\160\24\33\1\161"+
    "\1\33\1\116\1\0\1\33\2\41\2\122\1\123\17\33"+
    "\11\162\5\33\4\162\13\33\6\162\24\33\1\163\1\33"+
    "\1\122\1\0\3\33\2\150\1\151\17\33\11\164\5\33"+
    "\4\164\13\33\6\164\26\33\1\150\1\0\3\24\2\25"+
    "\1\26\110\24\1\25\124\0\1\25\114\0\3\24\2\25"+
    "\1\26\4\24\1\165\103\24\1\25\1\0\17\30\1\166"+
    "\4\30\1\167\112\30\1\170\4\30\1\171\112\30\1\172"+
    "\4\30\1\173\73\30\2\0\1\34\16\0\1\40\101\0"+
    "\1\35\114\0\2\37\7\0\1\37\13\0\11\37\5\0"+
    "\13\37\4\0\30\37\4\0\1\37\3\0\1\40\116\0"+
    "\2\41\120\0\3\42\110\0\1\42\1\0\2\43\7\0"+
    "\1\43\13\0\11\43\5\0\13\43\4\0\30\43\4\0"+
    "\1\43\12\0\1\174\14\0\1\175\4\0\1\176\1\177"+
    "\6\0\13\174\4\0\1\200\1\201\1\202\1\203\1\204"+
    "\1\205\2\174\1\206\2\174\1\207\1\174\1\210\1\174"+
    "\1\211\1\174\1\212\1\213\1\214\3\174\1\215\1\216"+
    "\24\0\1\217\4\0\1\220\74\0\2\46\116\0\2\47"+
    "\7\0\1\221\116\0\1\174\1\222\13\0\1\175\4\0"+
    "\1\176\1\177\6\0\13\174\4\0\1\200\1\201\1\202"+
    "\1\203\1\204\1\205\2\174\1\206\2\174\1\207\1\174"+
    "\1\210\1\174\1\211\1\174\1\223\1\213\1\214\2\174"+
    "\1\224\1\215\1\216\6\0\2\225\21\0\1\226\12\0"+
    "\1\55\54\0\1\56\6\0\1\52\133\0\1\227\4\0"+
    "\1\230\132\0\1\231\60\0\1\57\2\232\3\0\4\57"+
    "\1\61\11\57\1\62\12\57\1\55\54\57\1\56\1\57"+
    "\1\0\1\57\72\0\1\233\26\0\2\64\3\234\1\0"+
    "\1\67\1\70\1\71\3\0\1\72\1\73\1\74\1\75"+
    "\2\0\1\76\1\77\15\0\1\101\13\0\1\102\1\235"+
    "\1\0\1\104\30\0\1\236\1\106\1\0\1\107\1\234"+
    "\2\0\5\234\1\0\1\67\1\70\1\71\3\0\1\72"+
    "\1\73\1\74\1\75\2\0\1\76\1\77\15\0\1\101"+
    "\13\0\1\102\1\235\1\0\1\104\30\0\1\236\1\106"+
    "\1\0\1\107\1\234\2\0\2\234\1\65\2\234\1\0"+
    "\1\67\1\70\1\71\3\0\1\72\1\73\1\74\1\75"+
    "\2\0\1\76\1\77\15\0\1\101\13\0\1\102\1\235"+
    "\1\0\1\104\30\0\1\236\1\106\1\0\1\107\1\234"+
    "\20\0\1\237\4\0\1\230\132\0\1\240\116\0\1\241"+
    "\61\0\3\242\3\0\17\242\4\243\3\244\10\242\1\245"+
    "\4\242\1\246\1\247\1\250\1\251\1\252\5\242\1\253"+
    "\1\242\1\254\1\242\1\255\7\242\1\256\1\242\1\257"+
    "\1\260\1\261\1\262\1\263\1\242\1\264\1\265\5\242"+
    "\3\0\2\266\6\0\1\267\13\0\11\270\5\0\13\267"+
    "\4\0\30\267\7\0\2\271\2\272\1\273\110\0\1\272"+
    "\1\0\10\110\1\274\3\110\1\275\7\110\1\276\65\110"+
    "\1\0\1\110\1\0\3\110\3\274\3\0\2\274\1\110"+
    "\46\274\1\277\36\274\1\0\1\274\3\300\3\0\6\300"+
    "\1\0\42\300\1\301\36\300\1\0\1\300\17\110\1\302"+
    "\4\110\1\303\73\110\1\0\5\116\110\0\1\116\2\0"+
    "\5\120\110\0\1\120\1\0\3\121\3\0\2\121\1\0"+
    "\46\121\1\0\36\121\1\0\1\121\3\0\1\122\114\0"+
    "\3\304\3\0\2\304\1\305\14\304\4\306\3\307\20\304"+
    "\1\310\6\304\1\311\3\304\1\312\7\304\1\313\2\304"+
    "\1\314\1\304\1\315\1\316\2\304\1\317\5\304\3\0"+
    "\5\320\50\0\1\321\1\322\36\0\1\320\2\0\2\320"+
    "\1\130\2\320\50\0\1\321\1\322\36\0\1\320\14\0"+
    "\1\323\126\0\1\324\35\0\1\325\37\0\3\242\3\0"+
    "\17\242\4\243\3\244\10\242\1\245\4\242\1\246\1\242"+
    "\1\250\1\251\1\252\5\242\1\253\1\242\1\254\1\242"+
    "\1\255\7\242\1\256\1\242\1\257\1\260\1\261\1\262"+
    "\1\326\1\242\1\264\1\265\5\242\13\0\1\327\31\0"+
    "\13\327\4\0\30\327\121\0\1\330\121\0\1\331\2\0"+
    "\3\332\2\145\1\146\110\332\1\145\4\0\1\145\114\0"+
    "\3\332\2\145\1\146\60\332\1\333\3\332\1\334\16\332"+
    "\1\335\2\332\1\336\1\332\1\145\4\0\1\150\115\0"+
    "\2\337\22\0\11\340\63\0\5\154\110\0\1\154\1\0"+
    "\2\157\1\341\6\0\1\157\13\0\11\157\5\0\13\157"+
    "\4\0\30\157\4\0\1\157\26\0\11\342\5\0\4\342"+
    "\13\0\6\342\55\0\11\343\5\0\4\343\13\0\6\343"+
    "\55\0\11\344\5\0\4\344\13\0\6\344\24\0\1\345"+
    "\3\0\3\165\2\346\1\347\110\165\1\346\1\0\17\30"+
    "\1\166\4\30\1\0\112\30\1\0\4\30\1\167\73\30"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\30\174\4\0\1\174\33\0\1\350\150\0\1\351\117\0"+
    "\1\352\34\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\1\174\1\353\15\174\1\354\10\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\23\174\1\355\3\174\1\356\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\357\6\174\1\360\3\174\1\361\2\174\1\362"+
    "\3\174\1\363\1\364\4\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\4\174"+
    "\1\365\23\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\16\174\1\366\7\174"+
    "\1\367\1\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\10\174\1\370\12\174"+
    "\1\371\4\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\6\174\1\372\5\174"+
    "\1\373\1\374\12\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\10\174\1\375"+
    "\17\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\16\174\1\376\11\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\1\377\22\174\1\u0100\4\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\2\174\1\u0101\17\174\1\u0102\5\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\7\174\1\u0103\17\174\1\u0104\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\15\174\1\u0105\12\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\27\174\1\u0106"+
    "\4\0\1\174\1\0\3\216\2\u0107\1\u0108\110\216\1\u0107"+
    "\1\0\3\220\2\52\1\53\110\220\1\52\1\0\3\222"+
    "\3\0\110\222\1\0\1\222\1\174\1\u0109\1\u010a\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\2\174\1\u0101"+
    "\17\174\1\u010b\5\174\4\0\1\174\1\0\1\174\1\u010c"+
    "\1\u010d\6\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\21\174\1\u010e\6\174\4\0\1\174\1\0\3\230\3\0"+
    "\110\230\1\0\1\230\45\0\1\u010f\151\0\1\u0110\64\0"+
    "\1\245\4\0\1\u0111\1\247\1\250\1\0\1\252\7\0"+
    "\1\254\13\0\1\u0112\1\0\1\261\1\0\1\u0113\1\0"+
    "\1\264\55\0\1\u0114\137\0\1\u0115\5\0\1\u0116\1\0"+
    "\1\u0117\7\0\1\u0118\37\0\7\244\111\0\7\u0119\176\0"+
    "\1\u011a\32\0\11\u011b\5\0\4\u011b\13\0\6\u011b\142\0"+
    "\1\u011c\32\0\11\u011d\5\0\4\u011d\13\0\6\u011d\22\0"+
    "\1\u011e\32\0\11\u011f\5\0\4\u011f\13\0\6\u011f\30\0"+
    "\2\267\1\u0120\6\0\1\267\13\0\11\267\5\0\13\267"+
    "\4\0\30\267\2\0\1\u0121\1\0\1\267\26\0\11\270"+
    "\65\0\1\u0122\114\0\3\274\3\0\110\274\1\0\1\274"+
    "\14\0\1\110\103\0\3\300\3\0\17\300\4\u0123\3\u0124"+
    "\23\300\1\u0125\25\300\1\u0126\10\300\1\0\1\300\17\302"+
    "\1\u0127\100\302\3\303\3\110\110\303\1\110\26\0\7\307"+
    "\111\0\7\u0128\111\0\11\u0129\5\0\4\u0129\13\0\6\u0129"+
    "\55\0\11\u012a\5\0\4\u012a\13\0\6\u012a\22\0\1\u012b"+
    "\32\0\11\u012c\5\0\4\u012c\13\0\6\u012c\74\0\1\245"+
    "\4\0\1\u0111\1\0\1\250\1\0\1\252\7\0\1\254"+
    "\13\0\1\u0112\1\0\1\261\3\0\1\264\35\0\11\u011d"+
    "\5\0\4\u011d\13\0\6\u011d\22\0\1\u012d\5\0\2\327"+
    "\7\0\1\327\13\0\11\327\5\0\13\327\4\0\30\327"+
    "\2\0\1\u012e\1\0\1\327\1\0\3\332\2\145\1\146"+
    "\72\332\1\u012f\15\332\1\145\1\0\3\332\2\145\1\146"+
    "\71\332\1\u0130\16\332\1\145\1\0\3\332\2\145\1\146"+
    "\103\332\1\u0131\4\332\1\145\1\0\3\336\2\u0132\1\u0133"+
    "\110\336\1\u0132\26\0\11\340\63\0\2\341\142\0\11\u0134"+
    "\5\0\4\u0134\13\0\6\u0134\55\0\11\u0135\5\0\4\u0135"+
    "\13\0\6\u0135\55\0\11\u0136\5\0\4\u0136\13\0\6\u0136"+
    "\24\0\1\345\6\0\1\346\177\0\1\u0137\126\0\1\u0138"+
    "\117\0\1\u0139\25\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u013a\6\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\10\174\1\u013b\17\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\5\174"+
    "\1\u013c\22\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\u013d\27\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\21\174\1\u013e\6\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\1\u013f\27\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\1\u0140\27\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\13\174\1\u0141\14\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\16\174\1\u0142\11\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\17\174\1\u0143"+
    "\10\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\1\174\1\u0144\26\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\5\174\1\u0145\22\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\22\174\1\u0146\5\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\15\174\1\u0147"+
    "\12\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\13\174\1\u0148\1\174\1\u0149"+
    "\12\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\15\174\1\u014a\12\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\17\174\1\u014b\10\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\2\174\1\u014c\5\174\1\u014d\11\174\1\u014e\5\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\15\174\1\u014f\12\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\22\174\1\u0150\5\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\2\174\1\u0151"+
    "\25\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\1\174\1\u0152\26\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\1\u0153\27\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\1\u0154"+
    "\27\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\20\174\1\u0155\7\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\17\174\1\u0156\10\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\10\174\1\u0157\17\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\4\174\1\u0158"+
    "\6\174\1\u0159\14\174\4\0\1\174\4\0\1\u0107\114\0"+
    "\1\174\1\u0109\1\u010a\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\30\174\4\0\1\174\2\0\2\u010a\115\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\1\u015a\27\174\4\0\1\174\1\0\1\174\1\u010c\1\u010d"+
    "\6\0\1\174\13\0\11\174\5\0\13\174\4\0\30\174"+
    "\4\0\1\174\2\0\2\u010d\115\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\22\174\1\u015b\5\174"+
    "\4\0\1\174\51\0\1\u015c\133\0\1\u015d\145\0\1\u011e"+
    "\55\0\1\u015e\141\0\1\u015f\122\0\1\u0160\110\0\1\u0161"+
    "\11\0\1\u0162\120\0\1\u0163\16\0\114\u011a\1\u0164\3\u011a"+
    "\25\0\11\u0165\5\0\4\u0165\13\0\6\u0165\30\0\114\u011c"+
    "\1\u0166\3\u011c\25\0\11\u0167\5\0\4\u0167\13\0\6\u0167"+
    "\55\0\11\u0168\5\0\4\u0168\13\0\6\u0168\31\0\2\u0120"+
    "\111\0\1\u0121\17\0\1\110\10\0\7\u0124\100\0\1\110"+
    "\10\0\7\300\100\0\1\110\42\0\1\u0169\25\0\1\u016a"+
    "\26\0\1\110\10\0\11\u016b\5\0\4\u016b\13\0\6\u016b"+
    "\30\0\17\302\1\u0127\4\302\1\110\73\302\25\0\11\u016c"+
    "\5\0\4\u016c\13\0\6\u016c\55\0\11\u016d\5\0\4\u016d"+
    "\13\0\6\u016d\55\0\11\u016e\5\0\4\u016e\13\0\6\u016e"+
    "\30\0\3\332\2\145\1\146\61\332\1\u016f\26\332\1\145"+
    "\1\0\3\332\2\145\1\146\64\332\1\u0170\23\332\1\145"+
    "\1\0\3\332\2\145\1\146\67\332\1\u0171\20\332\1\145"+
    "\4\0\1\u0132\141\0\11\u0172\5\0\4\u0172\13\0\6\u0172"+
    "\55\0\11\u0173\5\0\4\u0173\13\0\6\u0173\55\0\11\u0174"+
    "\5\0\4\u0174\13\0\6\u0174\24\0\1\345\75\0\1\u0175"+
    "\131\0\1\u0176\117\0\1\u0177\13\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\22\174\1\u0178\5\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\17\174\1\u0179\10\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\5\174\1\u017a\22\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\2\174"+
    "\1\u017b\25\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\4\174\1\u017c\23\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\20\174\1\u017d\7\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\21\174\1\u017e\6\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\23\174"+
    "\1\u017f\4\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\20\174\1\u0180\7\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\2\174"+
    "\1\u0181\6\174\5\0\13\174\4\0\3\174\1\u0182\15\174"+
    "\1\u0183\6\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\23\174\1\u0184\4\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\2\174\1\u0185\17\174\1\u0186\1\174"+
    "\1\u0187\3\174\1\216\3\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\4\174\1\u0188"+
    "\23\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\1\u0189\27\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\13\174\1\u018a\14\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\2\174"+
    "\1\u018b\25\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\16\174\1\u018c\11\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\13\174\1\u018d\14\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\13\174\1\u018e\14\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\22\174"+
    "\1\u018f\5\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\4\174\1\u0190\20\174"+
    "\1\u0191\2\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\4\174\1\u0192\23\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u0193\4\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\12\174\1\u0194\15\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\13\174"+
    "\1\u0195\14\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\15\174\1\u0196\12\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\15\174\1\u0197\12\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\16\174\1\u0198\11\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\4\174"+
    "\1\u0199\23\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\2\174\1\u019a\25\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\16\174\1\u019b\11\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\4\174\1\u019c\23\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\15\174"+
    "\1\u0197\4\174\1\u019d\5\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\1\u019e"+
    "\27\174\4\0\1\174\47\0\1\u019f\146\0\1\u01a0\70\0"+
    "\1\u01a1\141\0\1\u01a2\115\0\1\u01a3\135\0\1\u01a4\122\0"+
    "\1\u01a5\111\0\1\u01a6\43\0\11\u01a7\5\0\4\u01a7\13\0"+
    "\6\u01a7\107\0\1\u0169\25\0\1\u016a\37\0\11\u016b\5\0"+
    "\4\u016b\13\0\6\u016b\55\0\11\u01a8\5\0\4\u01a8\13\0"+
    "\6\u01a8\55\0\11\u01a9\5\0\4\u01a9\13\0\6\u01a9\30\0"+
    "\3\332\2\145\1\146\76\332\1\u01aa\1\332\1\u01ab\5\332"+
    "\1\u01ac\1\332\1\145\1\0\3\332\2\145\1\146\76\332"+
    "\1\u01ad\11\332\1\145\1\0\3\332\2\145\1\146\60\332"+
    "\1\u01ae\27\332\1\145\26\0\11\u01af\5\0\4\u01af\13\0"+
    "\6\u01af\55\0\11\u01b0\5\0\4\u01b0\13\0\6\u01b0\55\0"+
    "\11\u01b1\5\0\4\u01b1\13\0\6\u01b1\24\0\1\345\107\0"+
    "\1\u01b2\13\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\20\174\1\u01b3\7\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\20\174\1\u01b4\7\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\4\174\1\u01b5"+
    "\23\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\2\174\1\u01b6\25\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\13\174\1\u01b7\14\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\21\174\1\u01b8\6\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\14\174\1\u01b9"+
    "\13\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\1\u01ba\27\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\4\174\1\u01bb\23\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\27\174"+
    "\1\u01bc\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\6\174\1\u01bd\21\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\13\174\1\u01be\14\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\7\174\1\u01bf\20\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\1\u01c0\27\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\15\174\1\u01c1\12\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\13\174\1\u01c2\14\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\22\174"+
    "\1\u01c3\5\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\20\174\1\u01c4\7\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\4\174\1\u01c5\23\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\23\174\1\u01c6\4\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\22\174"+
    "\1\u01c7\5\174\1\216\3\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\6\174\1\u01c8"+
    "\21\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\20\174\1\u01c9\7\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\15\174\1\u01ca\12\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\10\174\1\u01cb\17\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\4\174\1\u01cc"+
    "\23\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\3\174\1\u01cd\24\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\25\174\1\u01ce\2\174\4\0\1\174\1\0"+
    "\1\174\1\u01cf\1\u01d0\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\30\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\16\174\1\u01d1"+
    "\11\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\5\174\1\u01d2\22\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\26\174\1\u01d3\1\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\4\174\1\u01d4\23\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\22\174\1\u01d5"+
    "\5\174\4\0\1\174\42\0\1\u01d6\163\0\1\u01d7\53\0"+
    "\1\u01d8\150\0\1\u01d9\131\0\1\u01da\117\0\1\u01db\101\0"+
    "\1\u01dc\117\0\1\u01dd\56\0\11\u01de\5\0\4\u01de\13\0"+
    "\6\u01de\55\0\11\u01df\5\0\4\u01df\13\0\6\u01df\55\0"+
    "\11\u01e0\5\0\4\u01e0\13\0\6\u01e0\30\0\3\332\2\145"+
    "\1\146\63\332\1\u01e1\24\332\1\145\1\0\3\332\2\145"+
    "\1\146\54\332\1\u01e2\33\332\1\145\1\0\3\u01ac\2\u01e3"+
    "\1\u01e4\110\u01ac\1\u01e3\1\0\3\332\2\145\1\146\76\332"+
    "\1\u01e5\7\332\1\u01e6\1\332\1\145\1\0\3\332\2\145"+
    "\1\146\102\332\1\u01e7\5\332\1\145\26\0\11\u01e8\5\0"+
    "\4\u01e8\13\0\6\u01e8\55\0\11\u01e9\5\0\4\u01e9\13\0"+
    "\6\u01e9\55\0\11\u01ea\5\0\4\u01ea\13\0\6\u01ea\24\0"+
    "\1\345\3\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\1\u01eb\27\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\10\174"+
    "\1\u01ec\17\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\20\174\1\u01ed\7\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\11\174\1\u01ee\16\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\4\174\1\u01ef\23\174\4\0\1\174\1\0\1\174"+
    "\1\u01f0\1\u01f1\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\30\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\15\174\1\u01f2\12\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\20\174\1\u01f3\7\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\174\1\u01f4\26\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\14\174"+
    "\1\u01f5\13\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\16\174\1\u01f6\11\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\20\174\1\u01f7\7\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\13\174\1\u01f8\14\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\3\174"+
    "\1\u01f9\24\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\10\174\1\u01fa\17\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\4\174\1\u01fb\23\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\14\174\1\u01fc\13\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\3\174"+
    "\1\u01fd\24\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\7\174\1\u01fe\20\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\4\174\1\u01ff\23\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\u0200\27\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\10\174\1\u0201"+
    "\17\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\2\174\1\u0202\25\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\20\174\1\u0203\7\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\1\u0204\27\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\21\174\1\u0205\6\174"+
    "\4\0\1\174\1\0\1\174\1\u01cf\1\u01d0\6\0\1\u0206"+
    "\13\0\11\174\1\0\1\u0207\3\0\13\u0206\4\0\30\u0206"+
    "\4\0\1\174\2\0\2\u01d0\6\0\1\u0206\25\0\1\u0207"+
    "\3\0\13\u0206\4\0\30\u0206\6\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\3\174\1\u0208\24\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u0209\5\174\4\0\1\174"+
    "\1\0\1\174\1\u0109\1\u010a\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u020a\6\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\4\174\1\u020b\23\174\4\0\1\174\42\0\1\u020c"+
    "\143\0\1\u020d\73\0\1\u020e\162\0\1\u020f\117\0\1\u0210"+
    "\101\0\1\u0211\133\0\1\u0212\117\0\1\u0213\42\0\11\u0214"+
    "\5\0\4\u0214\13\0\6\u0214\55\0\11\300\5\0\4\300"+
    "\13\0\6\300\55\0\11\u0215\5\0\4\u0215\13\0\6\u0215"+
    "\30\0\3\332\2\145\1\146\74\332\1\u0216\13\332\1\145"+
    "\1\0\3\332\2\145\1\146\67\332\1\u0217\20\332\1\145"+
    "\4\0\1\u01e3\114\0\3\332\2\145\1\146\63\332\1\u0218"+
    "\24\332\1\145\1\0\3\u01e6\2\u0219\1\u021a\110\u01e6\1\u0219"+
    "\1\0\3\332\2\145\1\146\76\332\1\u021b\11\332\1\145"+
    "\115\0\1\345\3\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\2\174\1\u021c\25\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\24\174\1\u021d\3\174\4\0\1\174\1\0\1\174"+
    "\1\u021e\1\u021f\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\30\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\21\174\1\u0220\6\174"+
    "\4\0\1\174\1\0\1\174\1\u01f0\1\u01f1\6\0\1\u0221"+
    "\13\0\11\174\5\0\13\u0221\4\0\30\u0221\4\0\1\174"+
    "\2\0\2\u01f1\6\0\1\u0221\31\0\13\u0221\4\0\30\u0221"+
    "\6\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\6\174\1\u0222\21\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\23\174"+
    "\1\u0223\4\174\4\0\1\174\1\0\1\174\1\u0224\1\u0225"+
    "\6\0\1\174\13\0\11\174\5\0\13\174\4\0\30\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\21\174\1\u0226\6\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\16\174\1\u0227\11\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\30\174"+
    "\1\216\3\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\21\174\1\u0228\6\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\16\174\1\u0229\11\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\2\174\1\u022a\25\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\4\174\1\u022b"+
    "\23\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\4\174\1\u022c\23\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\20\174\1\u022d\7\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\20\174\1\u022e\7\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\17\174\1\u022f"+
    "\10\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\26\174\1\u0230\1\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\20\174\1\u0231\7\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\13\174\1\u0232\14\174\4\0\1\174\1\0\1\174\1\u0233"+
    "\1\u0234\6\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\30\174\4\0\1\174\1\0\2\u0206\1\u0235\6\0\1\u0206"+
    "\11\0\1\u0236\1\0\11\u0206\1\0\1\u0237\3\0\13\u0206"+
    "\1\u0238\3\0\30\u0206\4\0\1\u0206\1\0\3\u0239\6\0"+
    "\1\u0239\1\0\1\u0239\5\0\1\u0239\1\0\1\u0239\1\0"+
    "\11\u0239\1\0\1\u0239\1\0\15\u0239\4\0\30\u0239\4\0"+
    "\1\u0239\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\4\174\1\u023a\23\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\7\174\1\u023b\20\174\4\0\1\174\1\0\1\174\1\u010c"+
    "\1\u010d\6\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\21\174\1\u023c\6\174\4\0\1\174\2\0\5\u020c\104\0"+
    "\1\u023d\1\u023e\2\0\1\u020c\67\0\1\u023f\32\0\5\u0240"+
    "\110\0\1\u0240\37\0\1\u0241\147\0\1\u0242\133\0\1\u0243"+
    "\101\0\1\u0244\117\0\1\u0245\60\0\11\u0246\5\0\4\u0246"+
    "\13\0\6\u0246\55\0\11\u0247\5\0\4\u0247\13\0\6\u0247"+
    "\30\0\3\332\2\145\1\146\72\332\1\u0248\15\332\1\145"+
    "\1\0\3\332\2\145\1\146\106\332\1\u0249\1\332\1\145"+
    "\1\0\3\332\2\145\1\146\74\332\1\u024a\13\332\1\145"+
    "\4\0\1\u0219\114\0\3\332\2\145\1\146\63\332\1\u024b"+
    "\24\332\1\145\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\22\174\1\u024c\5\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\1\u024d\27\174\4\0\1\174\1\0\1\u024e\1\u021e"+
    "\1\u021f\3\0\3\u024f\1\u024e\13\u024f\11\u0250\5\u024f\13\u024e"+
    "\4\u024f\30\u024e\4\u024f\1\174\2\u024f\2\u021f\3\0\17\u024f"+
    "\11\u0251\60\u024f\1\0\1\u024f\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\21\174\1\u0252\6\174\4\0"+
    "\1\174\1\0\2\u0221\1\u0253\6\0\1\u0221\13\0\11\u0221"+
    "\1\0\1\u0254\3\0\13\u0221\4\0\30\u0221\4\0\1\u0221"+
    "\1\0\1\174\1\u0255\1\u0256\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\30\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\6\174"+
    "\1\u0257\21\174\4\0\1\174\1\0\1\u0258\1\u0224\1\u0225"+
    "\3\0\3\u0259\1\u025a\13\u0259\11\u0258\5\u0259\13\u025a\4\u0259"+
    "\30\u025a\4\u0259\1\174\2\u0259\2\u0225\3\0\3\u0259\1\u025a"+
    "\31\u0259\13\u025a\4\u0259\30\u025a\4\u0259\1\0\1\u0259\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\4\174"+
    "\1\u025b\23\174\4\0\1\174\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\25\174\1\u025c\2\174"+
    "\4\0\1\174\1\0\1\174\1\u025d\1\u025e\6\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\30\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\15\174\1\u025f\12\174\4\0\1\174\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\1\u0260"+
    "\27\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\15\174\1\u0261\12\174\4\0"+
    "\1\174\1\0\1\174\1\u0262\1\u0263\6\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\30\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\16\174\1\u0264\11\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\16\174\1\u0265"+
    "\11\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\16\174\1\u0266\11\174\4\0"+
    "\1\174\1\0\1\u0267\1\u0233\1\u0234\3\0\3\u0268\1\u0269"+
    "\13\u0268\11\u0267\5\u0268\13\u0269\4\u0268\30\u0269\4\u0268\1\174"+
    "\2\u0268\2\u0234\3\0\3\u0268\1\u0269\31\u0268\13\u0269\4\u0268"+
    "\30\u0269\4\u0268\1\0\1\u0268\1\0\2\u0235\20\0\1\u0236"+
    "\13\0\1\u0237\16\0\1\u0238\42\0\2\u0236\6\0\1\u0206"+
    "\31\0\13\u0206\4\0\30\u0206\6\0\3\u026a\6\0\1\u026a"+
    "\1\0\1\u026a\5\0\1\u026a\1\0\1\u026a\1\0\11\u026a"+
    "\1\0\1\u026a\1\0\15\u026a\4\0\30\u026a\4\0\1\u026a"+
    "\2\0\2\u0238\55\0\1\u026b\37\0\3\u0239\6\0\1\u0239"+
    "\1\0\1\u0239\5\0\1\u0239\1\0\1\u0239\1\0\11\u0239"+
    "\1\0\1\u0239\1\0\1\u026c\14\u0239\4\0\30\u0239\4\0"+
    "\1\u0239\1\0\1\174\1\u026d\1\u026e\6\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\30\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\20\174\1\u026f\7\174\4\0\1\174\2\0\2\u0270\116\0"+
    "\5\u0240\104\0\1\u0271\3\0\1\u0240\61\0\1\254\141\0"+
    "\1\u0272\53\0\1\u0273\143\0\1\u0274\117\0\1\u0275\35\0"+
    "\3\332\2\145\1\146\101\332\1\u0276\6\332\1\145\1\0"+
    "\3\u0249\2\u0277\1\u0278\110\u0249\1\u0277\1\0\3\332\2\145"+
    "\1\146\72\332\1\u0279\15\332\1\145\1\0\3\332\2\145"+
    "\1\146\74\332\1\u027a\13\332\1\145\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\22\174\1\u027b"+
    "\5\174\4\0\1\174\1\0\2\u024e\1\u024f\3\0\3\u024f"+
    "\1\u024e\13\u024f\11\u024e\5\u024f\13\u024e\4\u024f\30\u024e\4\u024f"+
    "\1\174\4\u024f\3\0\110\u024f\1\0\1\u024f\1\u024e\1\u027c"+
    "\1\u027d\3\0\3\u024f\1\u024e\13\u024f\11\u0250\5\u024f\13\u024e"+
    "\4\u024f\30\u024e\4\u024f\1\174\2\u024f\2\u027d\3\0\17\u024f"+
    "\11\u0251\60\u024f\1\0\1\u024f\1\0\2\u0253\34\0\1\u0254"+
    "\60\0\3\u027e\6\0\1\u027e\1\0\1\u027e\5\0\1\u027e"+
    "\1\0\1\u027e\1\0\11\u027e\1\0\1\u027e\1\0\15\u027e"+
    "\4\0\30\u027e\4\0\1\u027e\1\0\1\174\1\u0255\1\u0256"+
    "\6\0\1\u027f\13\0\11\174\1\0\1\u0280\3\0\13\u027f"+
    "\4\0\30\u027f\4\0\1\174\2\0\2\u0256\6\0\1\u0281"+
    "\25\0\1\u0280\3\0\13\u0281\4\0\30\u0281\6\0\2\u0258"+
    "\1\u0259\3\0\3\u0259\1\u0258\13\u0259\11\u0258\5\u0259\13\u0258"+
    "\4\u0259\30\u0258\4\u0259\1\174\4\u0259\3\0\110\u0259\1\0"+
    "\1\u0259\2\u025a\1\u0282\3\0\3\u0259\1\u025a\11\u0259\1\u0225"+
    "\1\u0259\11\u025a\5\u0259\13\u025a\4\u0259\30\u025a\4\u0259\1\u0283"+
    "\1\u0259\1\174\1\u0284\1\u0285\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\30\174\4\0\1\174\1\0\1\174"+
    "\1\u0286\1\u0287\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\30\174\1\216\3\0\1\174\1\0\1\174\1\u025d"+
    "\1\u025e\6\0\1\u0288\13\0\11\174\5\0\13\u0288\4\0"+
    "\30\u0288\4\0\1\174\2\0\2\u025e\6\0\1\u0288\31\0"+
    "\13\u0288\4\0\30\u0288\6\0\1\174\1\u0289\1\u028a\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\30\174\4\0"+
    "\1\174\1\0\2\174\7\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\21\174\1\u028b\6\174\4\0\1\174\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\22\174\1\u028c\5\174\4\0\1\174\1\0\2\u0262\1\u0263"+
    "\3\0\3\u0263\1\u0262\13\u0263\11\u0262\5\u0263\13\u0262\4\u0263"+
    "\30\u0262\4\u0263\1\174\1\0\3\u0263\3\0\110\u0263\2\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\25\174\1\u028d\2\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\20\174\1\u028e"+
    "\7\174\4\0\1\174\1\0\2\174\7\0\1\174\13\0"+
    "\11\174\5\0\13\174\4\0\15\174\1\u028f\12\174\4\0"+
    "\1\174\1\0\2\u0267\1\u0268\3\0\3\u0268\1\u0267\13\u0268"+
    "\11\u0267\5\u0268\13\u0267\4\u0268\30\u0267\4\u0268\1\174\4\u0268"+
    "\3\0\110\u0268\1\0\1\u0268\2\u0269\1\u0290\3\0\3\u0268"+
    "\1\u0269\7\u0268\1\u0234\1\u0268\1\u0234\1\u0268\11\u0269\5\u0268"+
    "\13\u0269\4\u0268\30\u0269\4\u0268\1\u0291\1\u0268\3\u026a\6\0"+
    "\1\u026a\1\0\1\u026a\5\0\1\u026a\1\0\1\u026a\1\0"+
    "\11\u026a\1\0\1\u026a\1\0\1\u0292\14\u026a\4\0\30\u026a"+
    "\4\0\1\u026a\2\0\2\u026b\53\0\1\u0238\41\0\1\u0239"+
    "\2\u026c\6\0\1\u0293\1\0\1\u0239\5\0\1\u0239\1\0"+
    "\1\u0239\1\0\11\u0239\1\0\1\u0239\1\0\1\u026c\1\u0239"+
    "\13\u0293\4\0\30\u0293\4\0\1\u0239\1\0\1\174\1\u026d"+
    "\1\u026e\6\0\1\174\13\0\1\174\10\u0294\5\0\13\174"+
    "\4\0\30\174\4\0\1\174\2\0\2\u026e\23\0\10\u0295"+
    "\62\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\16\174\1\u0296\11\174\4\0\1\174\1\0\3\u0270"+
    "\3\0\110\u0270\40\0\1\u0297\26\0\1\u0298\112\0\1\u0299"+
    "\142\0\1\u029a\117\0\1\u029b\14\0\3\332\2\145\1\146"+
    "\106\332\1\u029c\1\332\1\145\4\0\1\u0277\114\0\3\332"+
    "\2\145\1\146\101\332\1\u029d\6\332\1\145\1\0\3\332"+
    "\2\145\1\146\72\332\1\u029e\15\332\1\145\1\0\2\174"+
    "\7\0\1\174\13\0\11\174\5\0\13\174\4\0\4\174"+
    "\1\u029f\23\174\4\0\1\174\1\0\1\u024e\1\u027c\1\u027d"+
    "\3\0\3\u024f\1\u024e\13\u024f\11\u024e\5\u024f\13\u024e\4\u024f"+
    "\30\u024e\4\u024f\1\174\2\u024f\2\u027d\3\0\110\u024f\1\0"+
    "\1\u024f\3\u027e\6\0\1\u027e\1\0\1\u027e\5\0\1\u027e"+
    "\1\0\1\u027e\1\0\11\u027e\1\0\1\u027e\1\0\1\u02a0"+
    "\14\u027e\4\0\30\u027e\4\0\1\u027e\1\0\1\u027f\1\u02a1"+
    "\1\u02a2\6\0\1\u027f\11\0\1\u02a3\1\0\11\u027f\1\0"+
    "\1\u02a4\3\0\13\u027f\1\u02a5\3\0\30\u027f\4\0\1\u027f"+
    "\1\0\3\u02a6\6\0\1\u02a6\1\0\1\u02a6\5\0\1\u02a6"+
    "\1\0\1\u02a6\1\0\11\u02a6\1\0\1\u02a6\1\0\15\u02a6"+
    "\4\0\30\u02a6\4\0\1\u02a6\1\0\1\u0281\1\u02a7\1\u02a2"+
    "\6\0\1\u0281\11\0\1\u02a3\1\0\11\u0281\1\0\1\u02a4"+
    "\3\0\13\u0281\1\u02a5\3\0\30\u0281\4\0\1\u0281\1\0"+
    "\1\u0259\2\u0282\3\0\15\u0259\1\u0225\72\u0259\1\0\1\u0259"+
    "\2\u0283\1\u02a8\6\0\1\u0283\11\0\1\u02a9\1\0\11\u0283"+
    "\5\0\13\u0283\4\0\30\u0283\4\0\1\u0283\1\0\1\174"+
    "\1\u0284\1\u0285\6\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\5\174\1\u02aa\14\174\1\u02ab\5\174\4\0\1\174"+
    "\2\0\2\u0285\64\0\1\u02ac\14\0\1\u02ad\13\0\1\u02ae"+
    "\1\u0286\1\u0287\3\0\3\u02af\1\u02b0\13\u02af\11\u02ae\5\u02af"+
    "\13\u02b0\4\u02af\30\u02b0\4\u02af\1\174\2\u02af\2\u0287\3\0"+
    "\3\u02af\1\u02b0\31\u02af\13\u02b0\4\u02af\30\u02b0\4\u02af\1\0"+
    "\1\u02af\2\u0288\1\u02b1\6\0\1\u0288\11\0\1\u025e\1\0"+
    "\11\u0288\1\0\1\u02b2\3\0\13\u0288\4\0\30\u0288\4\0"+
    "\1\u0288\1\0\1\174\1\u0289\1\u028a\6\0\1\u02b3\13\0"+
    "\11\174\5\0\13\u02b3\4\0\30\u02b3\4\0\1\174\2\0"+
    "\2\u028a\6\0\1\u02b3\31\0\13\u02b3\4\0\30\u02b3\6\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\4\174\1\u0252\23\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\21\174\1\u02b4"+
    "\6\174\4\0\1\174\1\0\1\174\1\u02b5\1\u02b6\6\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\30\174\1\216"+
    "\3\0\1\174\1\0\1\174\1\u02b7\1\u02b8\6\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\30\174\4\0\1\174"+
    "\1\0\2\174\7\0\1\174\13\0\11\174\5\0\13\174"+
    "\4\0\4\174\1\u02b9\23\174\4\0\1\174\1\0\1\u0268"+
    "\2\u0290\3\0\13\u0268\1\u0234\1\u0268\1\u0234\72\u0268\1\0"+
    "\1\u0268\2\u0291\1\u02ba\6\0\1\u0291\7\0\1\u02bb\1\0"+
    "\1\u02bb\1\0\11\u0291\5\0\13\u0291\4\0\30\u0291\4\0"+
    "\1\u0291\1\0\1\u026a\2\u0292\6\0\1\u026a\1\0\1\u026a"+
    "\5\0\1\u026a\1\0\1\u026a\1\0\11\u026a\1\0\1\u026a"+
    "\1\0\1\u0292\14\u026a\1\u0238\3\0\30\u026a\4\0\1\u026a"+
    "\1\0\2\u0293\1\u02bc\6\0\1\u0293\1\0\1\u0239\5\0"+
    "\1\u0239\1\0\1\u026c\1\0\11\u0293\1\0\1\u02bd\1\0"+
    "\1\u026c\1\u0239\13\u0293\1\u0238\3\0\30\u0293\4\0\1\u0293"+
    "\1\0\2\174\7\0\1\174\11\0\1\u02be\1\0\11\u0294"+
    "\5\0\13\174\4\0\30\174\4\0\1\174\24\0\1\u02be"+
    "\1\0\11\u0295\62\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\25\174\1\u02bf\2\174\4\0\1\174"+
    "\61\0\1\u02c0\131\0\1\u02c1\113\0\1\u02c2\117\0\1\u02c3"+
    "\31\0\3\u029c\2\u02c4\1\u02c5\110\u029c\1\u02c4\1\0\3\332"+
    "\2\145\1\146\106\332\1\u02c6\1\332\1\145\1\0\3\332"+
    "\2\145\1\146\101\332\1\u02c7\6\332\1\145\1\0\1\u027e"+
    "\2\u02a0\6\0\1\u027e\1\0\1\u027e\5\0\1\u027e\1\0"+
    "\1\u027e\1\0\11\u027e\1\0\1\u027e\1\0\1\u02a0\14\u027e"+
    "\4\0\30\u027e\4\0\1\u027e\2\0\2\u02a2\20\0\1\u02a3"+
    "\13\0\1\u02a4\16\0\1\u02a5\42\0\2\u02a3\6\0\1\u0281"+
    "\31\0\13\u0281\4\0\30\u0281\6\0\3\u02c8\6\0\1\u02c8"+
    "\1\0\1\u02c8\5\0\1\u02c8\1\0\1\u02c8\1\0\11\u02c8"+
    "\1\0\1\u02c8\1\0\15\u02c8\4\0\30\u02c8\4\0\1\u02c8"+
    "\2\0\2\u02a5\55\0\1\u02c9\37\0\3\u02a6\6\0\1\u02a6"+
    "\1\0\1\u02a6\5\0\1\u02a6\1\0\1\u02a6\1\0\11\u02a6"+
    "\1\0\1\u02a6\1\0\1\u02ca\14\u02a6\4\0\30\u02a6\4\0"+
    "\1\u02a6\2\0\2\u02a8\20\0\1\u02a9\75\0\2\u02a9\6\0"+
    "\1\u0283\31\0\13\u0283\4\0\30\u0283\6\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\1\u02cb\27\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\20\174\1\u02cc\7\174\4\0\1\174"+
    "\63\0\1\u02cd\137\0\1\u02ce\15\0\2\u02ae\1\u02af\3\0"+
    "\3\u02af\1\u02ae\13\u02af\11\u02ae\5\u02af\13\u02ae\4\u02af\30\u02ae"+
    "\4\u02af\1\174\4\u02af\3\0\110\u02af\1\0\1\u02af\2\u02b0"+
    "\1\u02cf\3\0\3\u02af\1\u02b0\7\u02af\1\u0287\1\u02af\1\u0287"+
    "\1\u02af\11\u02b0\5\u02af\13\u02b0\4\u02af\30\u02b0\4\u02af\1\u02d0"+
    "\1\u02af\1\0\2\u02b1\20\0\1\u025e\13\0\1\u02b2\60\0"+
    "\3\u02d1\6\0\1\u02d1\1\0\1\u02d1\5\0\1\u02d1\1\0"+
    "\1\u02d1\1\0\11\u02d1\1\0\1\u02d1\1\0\15\u02d1\4\0"+
    "\30\u02d1\4\0\1\u02d1\1\0\2\u02b3\1\u02d2\6\0\1\u02b3"+
    "\13\0\11\u02b3\5\0\13\u02b3\4\0\30\u02b3\4\0\1\u02b3"+
    "\1\0\1\174\1\u02d3\1\u02d4\6\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\30\174\4\0\1\174\1\0\1\u02d5"+
    "\1\u02b5\1\u02b6\3\0\3\u02d6\1\u02d7\13\u02d6\11\u02d5\5\u02d6"+
    "\13\u02d7\4\u02d6\30\u02d7\4\u02d6\1\174\2\u02d6\2\u02b6\3\0"+
    "\3\u02d6\1\u02d7\31\u02d6\13\u02d7\4\u02d6\30\u02d7\4\u02d6\1\0"+
    "\1\u02d6\1\u02d8\1\u02b7\1\u02b8\3\0\3\u02d9\1\u02da\13\u02d9"+
    "\11\u02d8\5\u02d9\13\u02da\4\u02d9\30\u02da\4\u02d9\1\174\2\u02d9"+
    "\2\u02b8\3\0\3\u02d9\1\u02da\31\u02d9\13\u02da\4\u02d9\30\u02da"+
    "\4\u02d9\1\0\1\u02d9\1\0\2\u02ba\16\0\1\u02bb\1\0"+
    "\1\u02bb\75\0\2\u02bb\6\0\1\u0291\31\0\13\u0291\4\0"+
    "\30\u0291\6\0\1\u0239\2\u02bc\6\0\1\u0239\1\0\1\u0239"+
    "\5\0\1\u0239\1\0\1\u026c\1\0\11\u0239\1\0\1\u02bd"+
    "\1\0\1\u026c\14\u0239\1\u0238\3\0\30\u0239\4\0\1\u0239"+
    "\1\0\3\u02db\6\0\1\u02db\1\0\1\u02db\5\0\1\u02db"+
    "\1\0\1\u02db\1\0\11\u02db\1\0\1\u02db\1\0\1\u02dc"+
    "\14\u02db\4\0\30\u02db\4\0\1\u02db\26\0\11\u02dd\62\0"+
    "\1\174\1\u02de\1\u02df\6\0\1\174\13\0\11\174\5\0"+
    "\13\174\4\0\30\174\1\216\3\0\1\174\71\0\1\u02e0"+
    "\65\0\1\u02e1\117\0\1\u02e2\64\0\1\u02c4\114\0\3\u02c6"+
    "\2\u02e3\1\u02e4\110\u02c6\1\u02e3\1\0\3\332\2\145\1\146"+
    "\106\332\1\u02e5\1\332\1\145\1\0\3\u02c8\6\0\1\u02c8"+
    "\1\0\1\u02c8\5\0\1\u02c8\1\0\1\u02c8\1\0\11\u02c8"+
    "\1\0\1\u02c8\1\0\1\u02e6\14\u02c8\4\0\30\u02c8\4\0"+
    "\1\u02c8\2\0\2\u02e7\53\0\1\u02a5\41\0\1\u02a6\2\u02ca"+
    "\6\0\1\u02e8\1\0\1\u02a6\5\0\1\u02a6\1\0\1\u02a6"+
    "\1\0\11\u02a6\1\0\1\u02a6\1\0\1\u02ca\1\u02a6\13\u02e8"+
    "\4\0\30\u02e8\4\0\1\u02a6\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\13\174\1\u02e9\14\174"+
    "\4\0\1\174\1\0\2\174\7\0\1\174\13\0\11\174"+
    "\5\0\13\174\4\0\23\174\1\u02ea\4\174\4\0\1\174"+
    "\76\0\1\u02eb\127\0\1\u02ec\12\0\1\u02af\2\u02cf\3\0"+
    "\13\u02af\1\u0287\1\u02af\1\u0287\72\u02af\1\0\1\u02af\2\u02d0"+
    "\1\u02ed\6\0\1\u02d0\7\0\1\u02ee\1\0\1\u02ee\1\0"+
    "\11\u02d0\5\0\13\u02d0\4\0\30\u02d0\4\0\1\u02d0\1\0"+
    "\3\u02d1\6\0\1\u02d1\1\0\1\u02d1\5\0\1\u02d1\1\0"+
    "\1\u02d1\1\0\11\u02d1\1\0\1\u02d1\1\0\1\u02ef\14\u02d1"+
    "\4\0\30\u02d1\4\0\1\u02d1\2\0\2\u02d2\115\0\2\u02d3"+
    "\1\u02d4\3\0\3\u02d4\1\u02d3\13\u02d4\11\u02d3\5\u02d4\13\u02d3"+
    "\4\u02d4\30\u02d3\4\u02d4\1\174\1\0\3\u02d4\3\0\110\u02d4"+
    "\2\0\2\u02d5\1\u02d6\3\0\3\u02d6\1\u02d5\13\u02d6\11\u02d5"+
    "\5\u02d6\13\u02d5\4\u02d6\30\u02d5\4\u02d6\1\174\4\u02d6\3\0"+
    "\110\u02d6\1\0\1\u02d6\2\u02d7\1\u02f0\3\0\3\u02d6\1\u02d7"+
    "\7\u02d6\1\u02b6\1\u02d6\1\u02b6\1\u02d6\11\u02d7\5\u02d6\13\u02d7"+
    "\4\u02d6\30\u02d7\4\u02d6\1\u02f1\1\u02d6\2\u02d8\1\u02d9\3\0"+
    "\3\u02d9\1\u02d8\13\u02d9\11\u02d8\5\u02d9\13\u02d8\4\u02d9\30\u02d8"+
    "\4\u02d9\1\174\4\u02d9\3\0\110\u02d9\1\0\1\u02d9\2\u02da"+
    "\1\u02f2\3\0\3\u02d9\1\u02da\11\u02d9\1\u02b8\1\u02d9\11\u02da"+
    "\5\u02d9\13\u02da\4\u02d9\30\u02da\4\u02d9\1\u02f3\1\u02d9\3\u02db"+
    "\6\0\1\u02db\1\0\1\u02db\5\0\1\u02db\1\0\1\u02db"+
    "\1\0\11\u02db\1\0\1\u02db\1\0\1\u02f4\14\u02db\4\0"+
    "\30\u02db\4\0\1\u02db\1\0\1\u02db\2\u02dc\6\0\1\u02f5"+
    "\1\0\1\u02db\5\0\1\u02db\1\0\1\u02db\1\0\11\u02db"+
    "\1\0\1\u02db\1\0\1\u02f4\1\u02db\13\u02f5\4\0\30\u02f5"+
    "\4\0\1\u02db\24\0\1\u02f6\1\0\11\u02dd\62\0\1\u02f7"+
    "\1\u02de\1\u02df\3\0\3\u02f8\1\u02f9\13\u02f8\11\u02f7\5\u02f8"+
    "\13\u02f9\4\u02f8\30\u02f9\4\u02f8\1\174\2\u02f8\2\u02df\3\0"+
    "\3\u02f8\1\u02f9\31\u02f8\13\u02f9\4\u02f8\30\u02f9\4\u02f8\1\0"+
    "\1\u02f8\72\0\1\u02fa\105\0\1\u02fb\117\0\1\u02fc\42\0"+
    "\1\u02e3\114\0\3\u02e5\2\u02fd\1\u02fe\110\u02e5\1\u02fd\1\0"+
    "\1\u02c8\2\u02ff\6\0\1\u02c8\1\0\1\u02c8\5\0\1\u02c8"+
    "\1\0\1\u02c8\1\0\11\u02c8\1\0\1\u02c8\1\0\1\u02e6"+
    "\14\u02c8\1\u02a5\3\0\30\u02c8\4\0\1\u02c8\1\0\1\u02e8"+
    "\1\u0300\1\u0301\6\0\1\u02e8\1\0\1\u02a6\5\0\1\u02a6"+
    "\1\0\1\u02ca\1\0\11\u02e8\1\0\1\u0302\1\0\1\u02ca"+
    "\1\u02a6\13\u02e8\1\u02a5\3\0\30\u02e8\4\0\1\u02e8\1\0"+
    "\2\174\7\0\1\174\13\0\11\174\5\0\13\174\4\0"+
    "\21\174\1\u0303\6\174\4\0\1\174\1\0\2\174\7\0"+
    "\1\174\13\0\11\174\5\0\13\174\4\0\4\174\1\u0304"+
    "\23\174\4\0\1\174\104\0\1\u0305\102\0\1\u0306\32\0"+
    "\2\u02ed\16\0\1\u02ee\1\0\1\u02ee\75\0\2\u02ee\6\0"+
    "\1\u02d0\31\0\13\u02d0\4\0\30\u02d0\6\0\1\u02d1\2\u02ef"+
    "\6\0\1\u02d1\1\0\1\u02d1\5\0\1\u02d1\1\0\1\u02d1"+
    "\1\0\11\u02d1\1\0\1\u02d1\1\0\1\u02ef\14\u02d1\4\0"+
    "\30\u02d1\4\0\1\u02d1\1\0\1\u02d6\2\u02f0\3\0\13\u02d6"+
    "\1\u02b6\1\u02d6\1\u02b6\72\u02d6\1\0\1\u02d6\2\u02f1\1\u0307"+
    "\6\0\1\u02f1\7\0\1\u0308\1\0\1\u0308\1\0\11\u02f1"+
    "\5\0\13\u02f1\4\0\30\u02f1\4\0\1\u02f1\1\0\1\u02d9"+
    "\2\u02f2\3\0\15\u02d9\1\u02b8\72\u02d9\1\0\1\u02d9\2\u02f3"+
    "\1\u0309\6\0\1\u02f3\11\0\1\u030a\1\0\11\u02f3\5\0"+
    "\13\u02f3\4\0\30\u02f3\4\0\1\u02f3\1\0\1\u02db\2\u02f4"+
    "\6\0\1\u02f5\1\0\1\u02db\5\0\1\u02db\1\0\1\u02db"+
    "\1\0\11\u02db\1\0\1\u02db\1\0\1\u02f4\1\u02db\13\u02f5"+
    "\1\u0238\3\0\30\u02f5\4\0\1\u02db\1\0\2\u02f5\1\u030b"+
    "\6\0\1\u02f5\1\0\1\u02db\5\0\1\u02db\1\0\1\u02dc"+
    "\1\0\11\u02f5\1\0\1\u02db\1\0\1\u02f4\1\u02db\13\u02f5"+
    "\1\u0238\3\0\30\u02f5\4\0\1\u02f5\26\0\11\u030c\62\0"+
    "\2\u02f7\1\u02f8\3\0\3\u02f8\1\u02f7\13\u02f8\11\u02f7\5\u02f8"+
    "\13\u02f7\4\u02f8\30\u02f7\4\u02f8\1\174\4\u02f8\3\0\110\u02f8"+
    "\1\0\1\u02f8\2\u02f9\1\u030d\3\0\3\u02f8\1\u02f9\7\u02f8"+
    "\1\u02df\1\u02f8\1\u02df\1\u02f8\11\u02f9\5\u02f8\13\u02f9\4\u02f8"+
    "\30\u02f9\4\u02f8\1\u030e\1\u02f8\104\0\1\u030f\16\0\1\u02fd"+
    "\114\0\1\u02a6\2\u0301\6\0\1\u02a6\1\0\1\u02a6\5\0"+
    "\1\u02a6\1\0\1\u02ca\1\0\11\u02a6\1\0\1\u0302\1\0"+
    "\1\u02ca\14\u02a6\1\u02a5\3\0\30\u02a6\4\0\1\u02a6\1\0"+
    "\3\u0310\6\0\1\u0310\1\0\1\u0310\5\0\1\u0310\1\0"+
    "\1\u0310\1\0\11\u0310\1\0\1\u0310\1\0\1\u0311\14\u0310"+
    "\4\0\30\u0310\4\0\1\u0310\1\0\2\174\7\0\1\174"+
    "\13\0\11\174\5\0\13\174\4\0\4\174\1\u0312\23\174"+
    "\4\0\1\174\67\0\1\u0313\32\0\2\u0307\16\0\1\u0308"+
    "\1\0\1\u0308\75\0\2\u0308\6\0\1\u02f1\31\0\13\u02f1"+
    "\4\0\30\u02f1\7\0\2\u0309\20\0\1\u030a\75\0\2\u030a"+
    "\6\0\1\u02f3\31\0\13\u02f3\4\0\30\u02f3\6\0\1\u02db"+
    "\2\u030b\6\0\1\u02db\1\0\1\u02db\5\0\1\u02db\1\0"+
    "\1\u02dc\1\0\11\u02db\1\0\1\u02db\1\0\1\u02f4\14\u02db"+
    "\1\u0238\3\0\30\u02db\4\0\1\u02db\1\0\1\u02f8\2\u030d"+
    "\3\0\13\u02f8\1\u02df\1\u02f8\1\u02df\72\u02f8\1\0\1\u02f8"+
    "\2\u030e\1\u0314\6\0\1\u030e\7\0\1\u0315\1\0\1\u0315"+
    "\1\0\11\u030e\5\0\13\u030e\4\0\30\u030e\4\0\1\u030e"+
    "\37\0\1\u0316\61\0\3\u0310\6\0\1\u0310\1\0\1\u0310"+
    "\5\0\1\u0310\1\0\1\u0310\1\0\11\u0310\1\0\1\u0310"+
    "\1\0\1\u0317\14\u0310\4\0\30\u0310\4\0\1\u0310\1\0"+
    "\1\u0310\2\u0311\6\0\1\u0318\1\0\1\u0310\5\0\1\u0310"+
    "\1\0\1\u0310\1\0\11\u0310\1\0\1\u0310\1\0\1\u0317"+
    "\1\u0310\13\u0318\4\0\30\u0318\4\0\1\u0310\2\0\2\u0314"+
    "\16\0\1\u0315\1\0\1\u0315\75\0\2\u0315\6\0\1\u030e"+
    "\31\0\13\u030e\4\0\30\u030e\66\0\1\u0319\37\0\1\u0310"+
    "\2\u031a\6\0\1\u0318\1\0\1\u0310\5\0\1\u0310\1\0"+
    "\1\u0310\1\0\11\u0310\1\0\1\u0310\1\0\1\u0317\1\u0310"+
    "\13\u0318\1\u02a5\3\0\30\u0318\4\0\1\u0310\1\0\1\u0318"+
    "\1\u031b\1\u031c\6\0\1\u0318\1\0\1\u0310\5\0\1\u0310"+
    "\1\0\1\u0311\1\0\11\u0318\1\0\1\u0310\1\0\1\u0317"+
    "\1\u0310\13\u0318\1\u02a5\3\0\30\u0318\4\0\1\u0318\1\0"+
    "\1\u0310\2\u031c\6\0\1\u0310\1\0\1\u0310\5\0\1\u0310"+
    "\1\0\1\u0311\1\0\11\u0310\1\0\1\u0310\1\0\1\u0317"+
    "\14\u0310\1\u02a5\3\0\30\u0310\4\0\1\u0310\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[51040];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\23\0\1\1\1\11\5\1\1\11\1\1\1\11\14\1"+
    "\1\11\3\1\2\11\3\1\1\11\3\1\10\11\2\1"+
    "\1\11\2\1\1\11\2\1\1\11\4\1\2\11\1\1"+
    "\1\11\2\1\1\11\1\1\1\11\5\1\1\11\4\1"+
    "\2\11\4\1\1\11\2\1\1\11\2\1\1\11\1\1"+
    "\1\11\3\1\1\11\1\1\1\11\2\1\3\0\2\11"+
    "\1\0\1\1\3\0\16\1\1\0\1\11\1\0\1\11"+
    "\3\1\2\0\1\11\1\1\5\0\1\1\1\11\2\0"+
    "\1\11\2\1\1\11\1\1\2\11\1\1\5\11\1\1"+
    "\3\11\1\1\1\11\1\1\2\0\1\1\1\0\1\11"+
    "\1\1\10\0\2\11\3\1\5\11\2\1\3\0\3\11"+
    "\1\1\1\0\2\11\6\0\4\1\1\0\2\11\1\1"+
    "\3\0\34\1\1\11\7\1\12\0\1\11\4\0\1\11"+
    "\2\0\2\11\5\0\1\11\2\0\1\11\1\0\2\11"+
    "\3\0\1\11\3\1\4\0\42\1\10\0\1\11\1\0"+
    "\1\11\1\0\1\11\5\0\1\11\3\0\2\1\2\0"+
    "\2\11\47\1\20\0\2\1\1\0\1\11\35\1\1\0"+
    "\5\1\15\0\1\11\1\1\3\0\2\11\1\0\6\1"+
    "\1\0\25\1\1\0\4\1\2\0\1\1\12\0\1\11"+
    "\1\1\1\0\32\1\4\0\3\1\2\11\7\0\2\11"+
    "\4\0\10\1\1\0\1\1\1\0\7\1\1\0\13\1"+
    "\1\0\1\1\1\0\1\1\1\0\2\1\1\11\5\0"+
    "\1\11\1\1\2\0\3\1\1\0\1\1\2\0\3\1"+
    "\1\0\4\1\1\0\14\1\2\0\1\11\5\0\4\1"+
    "\4\0\2\1\1\0\2\1\2\0\4\1\1\0\10\1"+
    "\1\0\1\1\2\0\1\1\1\11\3\0\1\11\1\1"+
    "\5\0\2\1\2\0\2\1\1\0\11\1\2\0\3\1"+
    "\3\0\1\11\1\1\2\0\1\1\1\0\2\1\2\0"+
    "\1\1\1\0\7\1\1\0\3\1\1\0\3\11\4\1"+
    "\1\0\2\1\1\0\1\11\1\1\1\0\1\1\1\0"+
    "\4\1\3\0\1\1\1\11\1\1\4\0\1\11\3\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[796];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** the stack of open (nested) input streams to read from */
  private java.util.Deque<ZzFlexStreamInfo> zzStreams
    = new java.util.ArrayDeque<ZzFlexStreamInfo>();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    long yychar;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtBOL;
    boolean zzAtEOF;
    boolean zzEOFDone;
    int zzFinalHighSurrogate;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, char [] zzBuffer,
                  boolean zzAtBOL, boolean zzAtEOF, boolean zzEOFDone,
                  int zzFinalHighSurrogate, int yyline, long yychar,
                  int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtBOL       = zzAtBOL;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.zzFinalHighSurrogate = zzFinalHighSurrogate;
      this.yyline        = yyline;
      this.yychar        = yychar;
      this.yycolumn      = yycolumn;
    }
  }

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  private boolean zzEOFDone;

  /* user code: */

  int balance = 0;
  int commentbalance = 0;
  int action_line = 0;
  StringBuilder actionText = new StringBuilder();

  boolean isYYEOF;
  boolean notUnix;
  boolean caseless;
  boolean inclusive_states;

  int nextState;

  boolean macroDefinition;

  Timer t = new Timer();

  @Override
  protected int lexLine() {
    return yyline;
  }

  @Override
  protected int lexColumn() {
    return yycolumn;
  }

  @Override
  protected String lexText() {
    return yytext();
  }

  @Override
  protected void lexPushStream(File f) throws IOException {
    // yypushStream in skeleton.nested
    yypushStream(Files.newBufferedReader(f.toPath(), Options.encoding));
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public LexScan(java.io.Reader in) {
    states.insert("YYINITIAL", true);
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;           // indicate end of file
    zzEndRead = zzStartRead;  // invalidate buffer

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopStream (usually in an {@code <<EOF>>} action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtBOL, zzAtEOF, zzEOFDone,
                        zzFinalHighSurrogate, yyline, yychar, yycolumn)
    );
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    yyResetPosition();
  }


  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack.
   *
   * @throws java.util.NoSuchElementException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos;
    zzAtBOL       = s.zzAtBOL;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    zzFinalHighSurrogate = s.zzFinalHighSurrogate;
    yyline        = s.yyline;
    yychar        = s.yychar;
    yycolumn      = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to {@code ZZ_INITIAL}.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }

  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
    
  yyclose();    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':  // fall through
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case YYINITIAL: {
              return symbol(EOF);
            }  // fall though
            case 797: break;
            case COMMENT: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_COMMENT);
            }  // fall though
            case 798: break;
            case STATELIST: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_MACROS);
            }  // fall though
            case 799: break;
            case MACROS: {
              if ( yymoreStreams() ) {
                                  file = popFile();
                                  yypopStream();
                                }
                                else
                                  throw new ScannerException(file,ErrorMessages.EOF_IN_MACROS);
            }  // fall though
            case 800: break;
            case JAVA_CODE: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_ACTION, action_line-1);
            }  // fall though
            case 801: break;
            case STATES: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_STATES);
            }  // fall though
            case 802: break;
            case STRING_CONTENT: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_STRING);
            }  // fall though
            case 803: break;
            case CHARCLASS: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 804: break;
            case COPY: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_MACROS);
            }  // fall though
            case 805: break;
            case REPEATEXP: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 806: break;
            case REGEXP_CODEPOINT_SEQUENCE: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 807: break;
            case STRING_CODEPOINT_SEQUENCE: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_STRING);
            }  // fall though
            case 808: break;
            case CHARCLASS_CODEPOINT: {
              throw new ScannerException(file,ErrorMessages.EOF_IN_REGEXP);
            }  // fall though
            case 809: break;
            default:
              {
                if ( yymoreStreams() ) {
             file = popFile();
             yypopStream();
           }
           else {
             return symbol(EOF);
           }
              }
        }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { userCode.append(yytext());
            }
            // fall through
          case 171: break;
          case 2:
            { /* ignore */
            }
            // fall through
          case 172: break;
          case 3:
            { throw new ScannerException(file,ErrorMessages.UNEXPECTED_CHAR, yyline, yycolumn);
            }
            // fall through
          case 173: break;
          case 4:
            { 
            }
            // fall through
          case 174: break;
          case 5:
            { yybegin(MACROS);
            }
            // fall through
          case 175: break;
          case 6:
            { states.insert(yytext(),inclusive_states);
            }
            // fall through
          case 176: break;
          case 7:
            { return symbol(IDENT, yytext());
            }
            // fall through
          case 177: break;
          case 8:
            { throw new ScannerException(file,ErrorMessages.UNKNOWN_OPTION, yyline, yycolumn);
            }
            // fall through
          case 178: break;
          case 9:
            { if (null == unicodeProperties) {
                                  populateDefaultVersionUnicodeProperties();
                                  initUnicodeCharClasses();
                                }
                                yybegin(REGEXP);
                                return symbol(EQUALS);
            }
            // fall through
          case 179: break;
          case 10:
            { yybegin(STATES); return symbol_countUpdate(LESSTHAN, null);
            }
            // fall through
          case 180: break;
          case 11:
            { return symbol_countUpdate(RBRACE, null);
            }
            // fall through
          case 181: break;
          case 12:
            { yypushback(yylength()); yybegin(REGEXP);
            }
            // fall through
          case 182: break;
          case 13:
            { return symbol(CHAR, yytext().codePointAt(0));
            }
            // fall through
          case 183: break;
          case 14:
            { if (macroDefinition) { yybegin(MACROS); } return symbol(REGEXPEND);
            }
            // fall through
          case 184: break;
          case 15:
            { return symbol(BANG);
            }
            // fall through
          case 185: break;
          case 16:
            { string.setLength(0); nextState = REGEXP; yybegin(STRING_CONTENT);
            }
            // fall through
          case 186: break;
          case 17:
            { return symbol(DOLLAR);
            }
            // fall through
          case 187: break;
          case 18:
            { return symbol(OPENBRACKET);
            }
            // fall through
          case 188: break;
          case 19:
            { return symbol(CLOSEBRACKET);
            }
            // fall through
          case 189: break;
          case 20:
            { return symbol(STAR);
            }
            // fall through
          case 190: break;
          case 21:
            { return symbol(PLUS);
            }
            // fall through
          case 191: break;
          case 22:
            { return symbol(POINT);
            }
            // fall through
          case 192: break;
          case 23:
            { return symbol(LOOKAHEAD);
            }
            // fall through
          case 193: break;
          case 24:
            { return symbol(QUESTION);
            }
            // fall through
          case 194: break;
          case 25:
            { yybegin(CHARCLASS); return symbol(OPENCLASS);
            }
            // fall through
          case 195: break;
          case 26:
            { bolUsed = true; return symbol(HAT);
            }
            // fall through
          case 196: break;
          case 27:
            { yybegin(REGEXPSTART); return symbol(LBRACE);
            }
            // fall through
          case 197: break;
          case 28:
            { return symbol(BAR);
            }
            // fall through
          case 198: break;
          case 29:
            { return symbol(TILDE);
            }
            // fall through
          case 199: break;
          case 30:
            { actionText.append(yytext());
            }
            // fall through
          case 200: break;
          case 31:
            { balance++; actionText.append('{');
            }
            // fall through
          case 201: break;
          case 32:
            { if (balance > 0) {
                 balance--;
                 actionText.append('}');
               }
               else {
                 yybegin(REGEXPSTART);
                 Action a = new Action(actionText.toString(), action_line);
                 actions.add(a);
                 return symbol(ACTION, a);
               }
            }
            // fall through
          case 202: break;
          case 33:
            { return symbol(COMMA);
            }
            // fall through
          case 203: break;
          case 34:
            { yybegin(REGEXP); return symbol(MORETHAN);
            }
            // fall through
          case 204: break;
          case 35:
            { string.append(yytext());
            }
            // fall through
          case 205: break;
          case 36:
            { throw new ScannerException(file,ErrorMessages.UNTERMINATED_STR, yyline, yycolumn);
            }
            // fall through
          case 206: break;
          case 37:
            { yybegin(nextState); return symbol(STRING, string.toString());
            }
            // fall through
          case 207: break;
          case 38:
            { throw new ScannerException(file,ErrorMessages.EOL_IN_CHARCLASS,yyline,yycolumn);
            }
            // fall through
          case 208: break;
          case 39:
            { throw new ScannerException(file,ErrorMessages.UNEXPECTED_NL, yyline, yycolumn);
            }
            // fall through
          case 209: break;
          case 40:
            { string.setLength(0); nextState = CHARCLASS; yybegin(STRING_CONTENT);
            }
            // fall through
          case 210: break;
          case 41:
            { return symbol(DASH);
            }
            // fall through
          case 211: break;
          case 42:
            { balance++; return symbol(OPENCLASS);
            }
            // fall through
          case 212: break;
          case 43:
            { if (balance > 0) balance--; else yybegin(REGEXP); return symbol(CLOSECLASS);
            }
            // fall through
          case 213: break;
          case 44:
            { return symbol(HAT);
            }
            // fall through
          case 214: break;
          case 45:
            { yybegin(REGEXP); return symbol(RBRACE);
            }
            // fall through
          case 215: break;
          case 46:
            { yybegin(REGEXP);
            }
            // fall through
          case 216: break;
          case 47:
            { throw new ScannerException(file,ErrorMessages.CTOR_ARG,yyline,yycolumn);
            }
            // fall through
          case 217: break;
          case 48:
            { yybegin(MACROS); ctorArgs.add(yytext().trim());
            }
            // fall through
          case 218: break;
          case 49:
            { int codePoint = Integer.parseInt(yytext(), 16);
                    if (codePoint <= unicodeProperties.getMaximumCodePoint()) {
                      string.append(Character.toChars(codePoint));
                    } else {
                      throw new ScannerException(file,ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn);
                    }
            }
            // fall through
          case 219: break;
          case 50:
            { yybegin(REGEXP); return symbol(STRING, string.toString());
            }
            // fall through
          case 220: break;
          case 51:
            { int codePoint = Integer.parseInt(yytext(), 16);
                    if (codePoint <= unicodeProperties.getMaximumCodePoint()) {
                      string.append(Character.toChars(codePoint));
                    } else {
                      throw new ScannerException(file, ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn);
                    }
            }
            // fall through
          case 221: break;
          case 52:
            { yybegin(STRING_CONTENT);
            }
            // fall through
          case 222: break;
          case 53:
            { t.start();
                             yybegin(MACROS);
                             macroDefinition = true;
                             return symbol(USERCODE,userCode);
            }
            // fall through
          case 223: break;
          case 54:
            { if (commentbalance > 0)
                commentbalance--;
              else
                yybegin(nextState);
            }
            // fall through
          case 224: break;
          case 55:
            { commentbalance++;
            }
            // fall through
          case 225: break;
          case 56:
            { nextState = MACROS; yybegin(COMMENT);
            }
            // fall through
          case 226: break;
          case 57:
            { Out.warning(ErrorMessages.NOT_AT_BOL, yyline); yypushback(1);
            }
            // fall through
          case 227: break;
          case 58:
            { if (null == unicodeProperties) {
                                  populateDefaultVersionUnicodeProperties();
                                  initUnicodeCharClasses();
                                }
                                macroDefinition = false;
                                yybegin(REGEXPSTART);
                                return symbol(DELIMITER);
            }
            // fall through
          case 228: break;
          case 59:
            { nextState = REGEXPSTART; yybegin(COMMENT);
            }
            // fall through
          case 229: break;
          case 60:
            { actionText.setLength(0); yybegin(JAVA_CODE); action_line = yyline+1; return symbol(REGEXPEND);
            }
            // fall through
          case 230: break;
          case 61:
            { nextState = REGEXP; yybegin(COMMENT);
            }
            // fall through
          case 231: break;
          case 62:
            { return symbol(CHAR, yytext().codePointAt(1));
            }
            // fall through
          case 232: break;
          case 63:
            { return symbol(CHAR, Integer.parseInt(yytext().substring(1,yylength()), 8));
            }
            // fall through
          case 233: break;
          case 64:
            { return symbol(DIGITCLASSNOT);
            }
            // fall through
          case 234: break;
          case 65:
            { return symbol(NEWLINE);
            }
            // fall through
          case 235: break;
          case 66:
            { return symbol(WHITESPACECLASSNOT);
            }
            // fall through
          case 236: break;
          case 67:
            { return symbol(WORDCLASSNOT);
            }
            // fall through
          case 237: break;
          case 68:
            { return symbol(CHAR, (int)'\b');
            }
            // fall through
          case 238: break;
          case 69:
            { return symbol(DIGITCLASS);
            }
            // fall through
          case 239: break;
          case 70:
            { return symbol(CHAR, (int)'\f');
            }
            // fall through
          case 240: break;
          case 71:
            { return symbol(CHAR, (int)'\n');
            }
            // fall through
          case 241: break;
          case 72:
            { return symbol(CHAR, (int)'\r');
            }
            // fall through
          case 242: break;
          case 73:
            { return symbol(WHITESPACECLASS);
            }
            // fall through
          case 243: break;
          case 74:
            { return symbol(CHAR, (int)'\t');
            }
            // fall through
          case 244: break;
          case 75:
            { return symbol(WORDCLASS);
            }
            // fall through
          case 245: break;
          case 76:
            { yybegin(REPEATEXP);
                                   return symbol(REPEAT,
                                                 Integer.valueOf(yytext().trim().substring(1).trim()));
            }
            // fall through
          case 246: break;
          case 77:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { if (macroDefinition) {
                              yybegin(EATWSPNL);
                              return symbol(BAR);
                            }
                            else {
                              yybegin(REGEXPSTART);
                              return symbol(NOACTION);
                            }
            }
            // fall through
          case 247: break;
          case 78:
            { string.append(yytext().substring(1, yytext().offsetByCodePoints(1, 1)));
            }
            // fall through
          case 248: break;
          case 79:
            { string.append('\"');
            }
            // fall through
          case 249: break;
          case 80:
            { string.append( (char) Integer.parseInt(yytext().substring(1,yylength()), 8));
            }
            // fall through
          case 250: break;
          case 81:
            { string.append('\b');
            }
            // fall through
          case 251: break;
          case 82:
            { string.append('\f');
            }
            // fall through
          case 252: break;
          case 83:
            { string.append('\n');
            }
            // fall through
          case 253: break;
          case 84:
            { string.append('\r');
            }
            // fall through
          case 254: break;
          case 85:
            { string.append('\t');
            }
            // fall through
          case 255: break;
          case 86:
            { return symbol(INTERSECTION);
            }
            // fall through
          case 256: break;
          case 87:
            { return symbol(DIFFERENCE);
            }
            // fall through
          case 257: break;
          case 88:
            { yypushback(1); yycolumn--; return symbol(CHAR, (int)'-');
            }
            // fall through
          case 258: break;
          case 89:
            { /* union is the default operation - '||' can be ignored */
            }
            // fall through
          case 259: break;
          case 90:
            { return symbol(SYMMETRICDIFFERENCE);
            }
            // fall through
          case 260: break;
          case 91:
            { return symbol(REPEAT, Integer.valueOf(yytext().substring(1).trim()));
            }
            // fall through
          case 261: break;
          case 92:
            { int codePoint = Integer.parseInt(yytext().substring(0, yylength() - 1), 16);
                        if (codePoint <= unicodeProperties.getMaximumCodePoint()) {
                          yybegin(CHARCLASS);
                          return symbol(CHAR, codePoint);
                        } else {
                          throw new ScannerException(file, ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn);
                        }
            }
            // fall through
          case 262: break;
          case 93:
            { string.setLength(0); yybegin(COPY);
            }
            // fall through
          case 263: break;
          case 94:
            { inclusive_states = true; yybegin(STATELIST);
            }
            // fall through
          case 264: break;
          case 95:
            { inclusive_states = false; yybegin(STATELIST);
            }
            // fall through
          case 265: break;
          case 96:
            { string.setLength(0); yybegin(REGEXP_CODEPOINT_SEQUENCE);
            }
            // fall through
          case 266: break;
          case 97:
            { return symbol_countUpdate(MACROUSE, makeMacroIdent());
            }
            // fall through
          case 267: break;
          case 98:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -2);
            { if (macroDefinition) {
                              yybegin(EATWSPNL);
                              return symbol(BAR);
                            }
                            else {
                              yybegin(REGEXPSTART);
                              return symbol(NOACTION);
                            }
            }
            // fall through
          case 268: break;
          case 99:
            { yybegin(STRING_CODEPOINT_SEQUENCE);
            }
            // fall through
          case 269: break;
          case 100:
            { yybegin(CHARCLASS_CODEPOINT);
            }
            // fall through
          case 270: break;
          case 101:
            { return symbol(MACROUSE, yytext().substring(1,yylength()-1));
            }
            // fall through
          case 271: break;
          case 102:
            { classCode = conc(classCode,string);  yybegin(MACROS);
            }
            // fall through
          case 272: break;
          case 103:
            { cupCompatible = true;
                                isImplementing = concExc(isImplementing, "java_cup.runtime.Scanner");
                                if (functionName == null)
                                  functionName = "next_token";
                                if (tokenType == null)
                                  tokenType = "java_cup.runtime.Symbol";
                                if (eofVal == null)
                                  eofVal = "return new java_cup.runtime.Symbol("+cupSymbol+".EOF);";
                                if (!Options.jlex) eofclose = true;
            }
            // fall through
          case 273: break;
          case 104:
            { isInteger = true;
            }
            // fall through
          case 274: break;
          case 105:
            { String trimmedText = yytext().trim();
                                 String propertyValue = trimmedText.substring(3,trimmedText.length()-1);
                                 IntCharSet set = unicodeProperties.getIntCharSet(propertyValue);
                                 if (null == set) {
                                   throw new ScannerException(file,ErrorMessages.INVALID_UNICODE_PROPERTY, yyline, yycolumn + 3);
                                 }
                                 return symbol(UNIPROPCCLASSNOT, set);
            }
            // fall through
          case 275: break;
          case 106:
            { String trimmedText = yytext().trim();
                                 String propertyValue = trimmedText.substring(3,trimmedText.length()-1);
                                 IntCharSet set = unicodeProperties.getIntCharSet(propertyValue);
                                 if (null == set) {
                                   throw new ScannerException(file,ErrorMessages.INVALID_UNICODE_PROPERTY, yyline, yycolumn + 3);
                                 }
                                 return symbol(UNIPROPCCLASS, set);
            }
            // fall through
          case 276: break;
          case 107:
            { return symbol(CHAR, Integer.parseInt(yytext().substring(2,yylength()), 16));
            }
            // fall through
          case 277: break;
          case 108:
            { string.append( (char) Integer.parseInt(yytext().substring(2,yylength()), 16));
            }
            // fall through
          case 278: break;
          case 109:
            { populateDefaultVersionUnicodeProperties();
                                charClasses.init(127, this);
            }
            // fall through
          case 279: break;
          case 110:
            { populateDefaultVersionUnicodeProperties();
                                charClasses.init(255, this);
            }
            // fall through
          case 280: break;
          case 111:
            { charCount = true;
            }
            // fall through
          case 281: break;
          case 112:
            { cup2Compatible = true;
                                isImplementing = concExc(isImplementing, "Scanner");
                                lineCount = true;
                                columnCount = true;
                                if (functionName == null)
                                  functionName = "readNextTerminal";
                                if (tokenType == null)
                                  tokenType = "ScannerToken<? extends Object>";
                                if (eofVal == null)
                                  eofVal = "return token(SpecialTerminals.EndOfInputStream);";
                                if (!Options.jlex) eofclose = true;
                                // %unicode:
                                populateDefaultVersionUnicodeProperties();
                                initUnicodeCharClasses();
            }
            // fall through
          case 282: break;
          case 113:
            { lineCount = true;
            }
            // fall through
          case 283: break;
          case 114:
            { /* no-op - this is the only generation method */
            }
            // fall through
          case 284: break;
          case 115:
            { populateDefaultVersionUnicodeProperties();
                                initUnicodeCharClasses();
            }
            // fall through
          case 285: break;
          case 116:
            { debugOption = true;
            }
            // fall through
          case 286: break;
          case 117:
            { isFinal = true;
            }
            // fall through
          case 287: break;
          case 118:
            { isYYEOF = true;
            }
            // fall through
          case 288: break;
          case 119:
            { eofCode = conc(eofCode,string); yybegin(MACROS);
            }
            // fall through
          case 289: break;
          case 120:
            { isInteger = true;
                                if (eofVal == null)
                                  eofVal = "return 0;";
                                eofclose = true;
            }
            // fall through
          case 290: break;
          case 121:
            { columnCount = true;
            }
            // fall through
          case 291: break;
          case 122:
            { isPublic = true;
            }
            // fall through
          case 292: break;
          case 123:
            { tokenType = yytext().substring(6).trim();
            }
            // fall through
          case 293: break;
          case 124:
            { throw new ScannerException(file,ErrorMessages.EOF_WO_ACTION);
            }
            // fall through
          case 294: break;
          case 125:
            { initCode = conc(initCode,string);    yybegin(MACROS);
            }
            // fall through
          case 295: break;
          case 126:
            { throw new ScannerException(file,ErrorMessages.NO_BUFFER_SIZE, yyline);
            }
            // fall through
          case 296: break;
          case 127:
            { className = yytext().substring(7).trim();
            }
            // fall through
          case 297: break;
          case 128:
            { throw new ScannerException(file,ErrorMessages.QUIL_CUPSYM, yyline);
            }
            // fall through
          case 298: break;
          case 129:
            { isIntWrap = true;
            }
            // fall through
          case 299: break;
          case 130:
            { notUnix = true;
            }
            // fall through
          case 300: break;
          case 131:
            { throw new ScannerException(file,ErrorMessages.QUIL_THROW, yyline);
            }
            // fall through
          case 301: break;
          case 132:
            { String v = yytext().substring(8).trim();
                                       if (v.length() == 0) {
                                         populateDefaultVersionUnicodeProperties();
                                       } else {
                                         try {
                                           unicodeProperties = new UnicodeProperties(v);
                                         } catch (UnicodeProperties.UnsupportedUnicodeVersionException e) {
                                           throw new ScannerException
                                             (file, ErrorMessages.UNSUPPORTED_UNICODE_VERSION, yyline);
                                         }
                                       }
                                       initUnicodeCharClasses();
            }
            // fall through
          case 302: break;
          case 133:
            { actionText.setLength(0); yybegin(JAVA_CODE);
                                   Symbol s = symbol_countUpdate(EOFRULE, null);
                                   action_line = s.left+1;
                                   return s;
            }
            // fall through
          case 303: break;
          case 134:
            // lookahead expression with fixed lookahead length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -1);
            { yybegin(REGEXP); return symbol(EOFRULE);
            }
            // fall through
          case 304: break;
          case 135:
            { int codePoint = Integer.parseInt(yytext().substring(2,yylength()), 16);
                if (codePoint <= unicodeProperties.getMaximumCodePoint()) {
                  return symbol(CHAR, codePoint);
                } else {
                  throw new ScannerException(file,ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn+2);
                }
            }
            // fall through
          case 305: break;
          case 136:
            { int codePoint = Integer.parseInt(yytext().substring(2,yylength()), 16);
                if (codePoint <= unicodeProperties.getMaximumCodePoint()) {
                  string.append(Character.toChars(codePoint));
                } else {
                  throw new ScannerException(file,ErrorMessages.CODEPOINT_OUT_OF_RANGE, yyline, yycolumn+2);
                }
            }
            // fall through
          case 306: break;
          case 137:
            { isAbstract = true;
            }
            // fall through
          case 307: break;
          case 138:
            { bufferSize = Integer.parseInt(yytext().substring(8).trim());
            }
            // fall through
          case 308: break;
          case 139:
            { caseless = true;
            }
            // fall through
          case 309: break;
          case 140:
            { cupDebug = true;
            }
            // fall through
          case 310: break;
          case 141:
            { cupSymbol = yytext().substring(8).trim();
                                if (cupCompatible) Out.warning(ErrorMessages.CUPSYM_AFTER_CUP, yyline);
            }
            // fall through
          case 311: break;
          case 142:
            { eofclose = true;
            }
            // fall through
          case 312: break;
          case 143:
            { includeFile(yytext().substring(9).trim());
            }
            // fall through
          case 313: break;
          case 144:
            { lexThrow = concExc(lexThrow,yytext().substring(8).trim());
            }
            // fall through
          case 314: break;
          case 145:
            { includeFile(yytext().trim().substring(9).trim());
            }
            // fall through
          case 315: break;
          case 146:
            { actionText.setLength(0); yybegin(JAVA_CODE); action_line = yyline+1; return symbol(EOFRULE);
            }
            // fall through
          case 316: break;
          case 147:
            { eofVal = string.toString(); yybegin(MACROS);
            }
            // fall through
          case 317: break;
          case 148:
            { throw new ScannerException(file,ErrorMessages.QUIL_EOFTHROW, yyline);
            }
            // fall through
          case 318: break;
          case 149:
            { isExtending = yytext().substring(9).trim();
            }
            // fall through
          case 319: break;
          case 150:
            { return symbol(LETTERCLASS);
            }
            // fall through
          case 320: break;
          case 151:
            { visibility = "private"; Skeleton.makePrivate();
            }
            // fall through
          case 321: break;
          case 152:
            { yybegin(CTOR_ARG); ctorTypes.add(yytext().substring(8).trim());
            }
            // fall through
          case 322: break;
          case 153:
            { eofThrow = concExc(eofThrow,yytext().substring(10).trim());
            }
            // fall through
          case 323: break;
          case 154:
            { functionName = yytext().substring(10).trim();
            }
            // fall through
          case 324: break;
          case 155:
            { throw new ScannerException(file,ErrorMessages.QUIL_INITTHROW, yyline);
            }
            // fall through
          case 325: break;
          case 156:
            { throw new ScannerException(file,ErrorMessages.QUIL_SCANERROR, yyline);
            }
            // fall through
          case 326: break;
          case 157:
            { standalone = true; isInteger = true;
            }
            // fall through
          case 327: break;
          case 158:
            { return symbol(JLETTERCLASS);
            }
            // fall through
          case 328: break;
          case 159:
            { eofThrow = concExc(eofThrow,string); yybegin(MACROS);
            }
            // fall through
          case 329: break;
          case 160:
            { isImplementing = concExc(isImplementing, yytext().substring(12).trim());
            }
            // fall through
          case 330: break;
          case 161:
            { initThrow = concExc(initThrow,yytext().substring(11).trim());
            }
            // fall through
          case 331: break;
          case 162:
            { scanErrorException = yytext().substring(11).trim();
            }
            // fall through
          case 332: break;
          case 163:
            { throw new ScannerException(file,ErrorMessages.QUIL_YYLEXTHROW, yyline);
            }
            // fall through
          case 333: break;
          case 164:
            { initThrow = concExc(initThrow,string);  yybegin(MACROS);
            }
            // fall through
          case 334: break;
          case 165:
            { lexThrow = concExc(lexThrow,yytext().substring(12).trim());
            }
            // fall through
          case 335: break;
          case 166:
            { return symbol(LOWERCLASS);
            }
            // fall through
          case 336: break;
          case 167:
            { return symbol(UPPERCLASS);
            }
            // fall through
          case 337: break;
          case 168:
            { lexThrow = concExc(lexThrow,string); yybegin(MACROS);
            }
            // fall through
          case 338: break;
          case 169:
            { eofclose = false;
            }
            // fall through
          case 339: break;
          case 170:
            { return symbol(JLETTERDIGITCLASS);
            }
            // fall through
          case 340: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Converts an int token code into the name of the
   * token by reflection on the cup symbol class/interface sym
   */
  private static String getTokenName(int token) {
    try {
      java.lang.reflect.Field [] classFields = sym.class.getFields();
      for (int i = 0; i < classFields.length; i++) {
        if (classFields[i].getInt(null) == token) {
          return classFields[i].getName();
        }
      }
    } catch (Exception e) {
      e.printStackTrace(System.err);
    }

    return "UNKNOWN TOKEN";
  }

  /**
   * Same as next_token but also prints the token to standard out
   * for debugging.
   */
  public Symbol debug_next_token() throws java.io.IOException {
    Symbol s = next_token();
    System.out.println( "line:" + (yyline+1) + " col:" + (yycolumn+1) + " --"+ yytext() + "--" + getTokenName(s.sym) + "--");
    return s;
  }

  /**
   * Runs the scanner on input files.
   *
   * This main method is the debugging routine for the scanner.
   * It prints debugging information about each returned token to
   * System.out until the end of file is reached, or an error occured.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java LexScan [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          // Side-effect: is encodingName valid?
          java.nio.charset.Charset.forName(encodingName);
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        LexScan scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new LexScan(reader);
          while ( !scanner.zzAtEOF ) scanner.debug_next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
