package generator

import (
	"fmt"
	"io/ioutil"
)

// VersionTemplate generate the version file
func VersionTemplate(filename, version string) error {

	tpl := `// Code generated by go-bluetooth generator DO NOT EDIT.

package profile

const Version = %s
`

	err := ioutil.WriteFile(filename, []byte(fmt.Sprintf(tpl, version)), 0644)
	if err != nil {
		return fmt.Errorf("tpl write: %s", err)
	}

	return nil
}
