/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/interactive_test_data_adaptor.cpp
 *
 * @brief [LEVEL: beta] implementation of @ref
 * diagnostics::unittest::Interactive_Test_Data_Adaptor class
 *
 * $Id: interactive_test_data_adaptor.cpp,v 1.4 2005/06/23 09:54:25 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/test_system/interactive_test_data_adaptor.hpp>

#include <diagnostics/unittest/test_system/test_data_source.hpp>
#include <diagnostics/unittest/test_system_exception.hpp>
#include <diagnostics/unittest/test_exception.hpp>

#include <iostream>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

Interactive_Test_Data_Adaptor::~Interactive_Test_Data_Adaptor()
{
}


Interactive_Test_Data_Adaptor::Interactive_Test_Data_Adaptor() 
    : m_test_data_source(NULL)
{
}


Test_Data_Source* Interactive_Test_Data_Adaptor::backend() const
{
    return m_test_data_source;
}


void Interactive_Test_Data_Adaptor::attach(Test_Data_Source * const test_data_source)
{
    if(test_data_source==NULL) throw Test_System_Exception("test_data_source==NULL");
    m_test_data_source=test_data_source;
}

    
::std::string const & Interactive_Test_Data_Adaptor::get(::std::string const & id) const 
{
    if(m_test_data_source==NULL) throw Test_System_Exception("test_data_source==NULL");
 
	if(m_test_data_source->exists_entry(id)) 
		return m_test_data_source->get_entry(id);

	::std::string initial;
	if(p_missing_test_data(id,initial)){
		m_test_data_source->set_entry(id,initial);
		return m_test_data_source->get_entry(id);
	}
	
	throw Test_Exception("Entry with ID: "+id+" does not exist");
}

bool Interactive_Test_Data_Adaptor::compare(::std::string const & id,::std::string const & data) const
{
    if(m_test_data_source==NULL) throw Test_System_Exception("test_data_source==NULL");

	::std::string new_data(data);

    if(!m_test_data_source->exists_entry(id)) {
		if(p_missing_test_data(id,new_data)){
			m_test_data_source->set_entry(id,new_data);
			return true;
		}
		throw Test_Exception("Entry with ID: "+id+" does not exist");
    }
    else {
		::std::string const & original(get(id));
		if(original==data) 
			return true;
		else {
			if(p_mismatching_test_data(id,original,new_data)){
				m_test_data_source->set_entry(id,new_data);
				return true;
			}
			return false;
		}
    }
}




UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


// vim:ts=4:sw=4
