// Generated by IcedCoffeeScript 1.3.3f
(function() {
  var Theme, color, colorize, colorizeToArray, colorizeToCallback, extendedTypeOf, subcolorizeToCallback,
    __hasProp = {}.hasOwnProperty;

  color = require('cli-color');

  extendedTypeOf = require('./util').extendedTypeOf;

  Theme = {
    ' ': function(s) {
      return s;
    },
    '+': color.green,
    '-': color.red
  };

  subcolorizeToCallback = function(key, diff, output, color, indent) {
    var item, looksLikeDiff, m, op, prefix, subindent, subkey, subvalue, _i, _j, _k, _len, _len1, _len2, _ref, _ref1;
    prefix = key ? "" + key + ": " : '';
    subindent = indent + '  ';
    switch (extendedTypeOf(diff)) {
      case 'object':
        if (('__old' in diff) && ('__new' in diff) && (Object.keys(diff).length === 2)) {
          subcolorizeToCallback(key, diff.__old, output, '-', indent);
          return subcolorizeToCallback(key, diff.__new, output, '+', indent);
        } else {
          output(color, "" + indent + prefix + "{");
          for (subkey in diff) {
            if (!__hasProp.call(diff, subkey)) continue;
            subvalue = diff[subkey];
            if (m = subkey.match(/^(.*)__deleted$/)) {
              subcolorizeToCallback(m[1], subvalue, output, '-', subindent);
            } else if (m = subkey.match(/^(.*)__added$/)) {
              subcolorizeToCallback(m[1], subvalue, output, '+', subindent);
            } else {
              subcolorizeToCallback(subkey, subvalue, output, color, subindent);
            }
          }
          return output(color, "" + indent + "}");
        }
        break;
      case 'array':
        output(color, "" + indent + prefix + "[");
        looksLikeDiff = true;
        for (_i = 0, _len = diff.length; _i < _len; _i++) {
          item = diff[_i];
          if ((extendedTypeOf(item) !== 'array') || !((item.length === 2) || ((item.length === 1) && (item[0] === ' '))) || !(typeof item[0] === 'string') || item[0].length !== 1 || !((_ref = item[0]) === ' ' || _ref === '-' || _ref === '+' || _ref === '~')) {
            looksLikeDiff = false;
          }
        }
        if (looksLikeDiff) {
          for (_j = 0, _len1 = diff.length; _j < _len1; _j++) {
            _ref1 = diff[_j], op = _ref1[0], subvalue = _ref1[1];
            if (op === ' ' && !(subvalue != null)) {
              output(' ', subindent + '...');
            } else {
              if (op !== ' ' && op !== '~' && op !== '+' && op !== '-') {
                throw new Error("Unexpected op '" + op + "' in " + (JSON.stringify(diff, null, 2)));
              }
              if (op === '~') op = ' ';
              subcolorizeToCallback('', subvalue, output, op, subindent);
            }
          }
        } else {
          for (_k = 0, _len2 = diff.length; _k < _len2; _k++) {
            subvalue = diff[_k];
            subcolorizeToCallback('', subvalue, output, color, subindent);
          }
        }
        return output(color, "" + indent + "]");
      default:
        return output(color, indent + prefix + JSON.stringify(diff));
    }
  };

  colorizeToCallback = function(diff, output) {
    return subcolorizeToCallback('', diff, output, ' ', '');
  };

  colorizeToArray = function(diff) {
    var output;
    output = [];
    colorizeToCallback(diff, function(color, line) {
      return output.push("" + color + line);
    });
    return output;
  };

  colorize = function(diff, options) {
    var output;
    if (options == null) options = {};
    output = [];
    colorizeToCallback(diff, function(color, line) {
      var _ref, _ref1, _ref2;
      if ((_ref = options.color) != null ? _ref : true) {
        return output.push(((_ref1 = (_ref2 = options.theme) != null ? _ref2[color] : void 0) != null ? _ref1 : Theme[color])("" + color + line) + "\n");
      } else {
        return output.push("" + color + line + "\n");
      }
    });
    return output.join('');
  };

  module.exports = {
    colorize: colorize,
    colorizeToArray: colorizeToArray,
    colorizeToCallback: colorizeToCallback
  };

}).call(this);
