#!/bin/bash
# This is a sample script used to generate atoms.h5 (proatom densities) using `horton`.
# Refer to `horton` documentation [http://theochem.github.io/horton/2.1.1/user_postproc_aim.html#simple-template-file-for-psi4]
# for more information.

# First generate Psi4 inputs for each atom.
horton-atomdb.py input psi4 1-20 template.in

# Make a small modification on the autogenerated script from horton to match the updated filename.
sed -i '24a\
mv *.molden atom.default.molden
' run_psi4.sh

# Run Psi4 calculations for each atom.
./run_psi4.sh

# Collect the results into h5 file.
horton-atomdb.py convert
