The files in this directory are used to build a self-contained Python package for BornAgain.

Python “wheels” are currently the standard (and the easiest) way to distribute Python packages, esp. via Python's standard platform, PyPI. Python standard library has also dedicated tools to produce such ‘wheels’ (e.g., `setuptools`) and the ‘wheels’ can be installed easily via `pip`. For further details, see [Python Packaging User Guide](https://packaging.python.org) and [PEP 427](https://www.python.org/dev/peps/pep-0427).

The directory structure and its files are needed by Python `setuptools` to make the wheel. The structure and configurations are prescribed by `setuptools`; for further details and examples, consult the [documentation](https://setuptools.pypa.io/en/latest/userguide/index.html).

The wheel is built ultimately by invoking the Python interpreter which will use the directory structure and the configuration files to build the wheel.

The following commands can be used to build the wheel:
* `python3 -m build --wheel -o <destination>`  
  Builds the wheel in the given destination. This is the command used currently to build the BornAgain wheel.

* `python3 -m build -o <destination>`  
  Builds the wheel plus a source distribution in the given destination.

* `python3 setup.py build bdist_wheel`  
  Invokes a Python virtual environment (`venv`), installs the prerequisite packages (`numpy`, `matplotlib`, etc.) and then, builds the wheel plus a source distribution.


The produced wheel can be installed via `pip`:
```
pip3 install [--user] <wheel-filename>
```

or by invoking a specific version of Python:

```
python3.9 -m pip install [--user] <wheel-filename>
```

The wheel is a simple zip file; hence, its content can be seen via
```
unzip -l <wheel-filename>
```

To upload the wheel to the PyPI repository one can use:
```
python3 -m twine upload --repository <repo-nam> --config-file pypirc.conf --non-interactive --verbose <wheel-filename>
```

The `<repo-name>` can be either `testpypi` for the PyPI test repository or `pypi` for the main repository.

The required PyPI token (generated by PyPI website) must be stored in `pypirc.conf`; for instance:
```
[testpypi]
  repository = https://test.pypi.org/legacy/
  username = __token__
  password = SomeVeryLongPrivatePyPIToken
```