/* Copyright (C) Teemu Suutari */

#ifndef TDCSDECOMPRESSOR_HPP
#define TDCSDECOMPRESSOR_HPP

#include "XPKDecompressor.hpp"

class TDCSDecompressor : public XPKDecompressor
{
public:
	TDCSDecompressor(uint32_t hdr,uint32_t recursionLevel,const Buffer &packedData,std::unique_ptr<XPKDecompressor::State> &state,bool verify);

	virtual ~TDCSDecompressor();

	virtual const std::string &getSubName() const noexcept override final;

	virtual void decompressImpl(Buffer &rawData,const Buffer &previousData,bool verify) override final;

	static bool detectHeaderXPK(uint32_t hdr) noexcept;
	static std::unique_ptr<XPKDecompressor> create(uint32_t hdr,uint32_t recursionLevel,const Buffer &packedData,std::unique_ptr<XPKDecompressor::State> &state,bool verify);

private:
	const Buffer	&_packedData;

	static XPKDecompressor::Registry<TDCSDecompressor> _XPKregistration;
};

#endif
