---
layout: default
title: Resources
nav_order: 12
---

# Resources

_Is this page missing a link? Open a PR!_

## ViewComponent libraries

- [Primer ViewComponents](https://primer.style/view-components/)
- [GOV.UK Rails Components](https://govuk-components.netlify.app/)
- [Polaris ViewComponents](https://github.com/baoagency/polaris_view_components)

## Frameworks using ViewComponent

- [Motion](https://github.com/unabridged/motion)
- [StimulusReflex](https://docs.stimulusreflex.com/)
- [ViewComponentReflex](https://github.com/joshleblanc/view_component_reflex)

## ViewComponent extensions

- [ViewComponent::Storybook](https://github.com/jonspalmer/view_component_storybook)
- [ViewComponent Contrib](https://github.com/palkan/view_component-contrib)
- [Lookbook](https://github.com/allmarkedup/lookbook)
- [ViewComponentAttributes](https://github.com/Amba-Health/view_component_attributes)

## Podcasts

- [Code with Jason - ViewComponent with Joel Hawksley, Staff Engineer at GitHub](https://www.codewithjason.com/podcast/9936046-130-viewcomponent-with-joel-hawksley-staff-engineer-at-github/)
- [Remote Ruby - ViewComponents and the Future of Assets](https://remoteruby.transistor.fm/125)
- [Ruby Rogues - RUX: JSX-Style Rails View Components](https://rubyrogues.com/rux-jsx-style-rails-view-components-ruby-517)
- [Code with Jason - ViewComponent with Joel Hawksley of GitHub](https://www.codewithjason.com/podcast/9478227-088-viewcomponent-with-joel-hawksley-of-github/)
- [Ruby Rogues - Rethinking the View Layer with Components](https://devchat.tv/ruby-rogues/rr-461-rethinking-the-view-layer-with-components-with-joel-hawksley/)
- [Ruby on Rails Podcast - ViewComponents in Action with Andrew Mason](https://5by5.tv/rubyonrails/320)
- [The Ruby Blend - ViewComponent at GitHub with Joel Hawksley](https://the-ruby-blend.fireside.fm/9)
- [The Ruby Blend - Components, HAML vs ERB, and Design Systems](https://the-ruby-blend.fireside.fm/4)
- [Ruby on Rails Podcast - Introducing ActionView::Component with Joel Hawksley](http://5by5.tv/rubyonrails/276)
- [Ruby on Rails Podcast - Choosing the Right Tech Stack with Dave Paola](https://5by5.tv/rubyonrails/307)

## Conference talks

- [Frontendless Rails frontend, RailsConf 2021](https://www.youtube.com/watch?v=sIxvxp7E0xg)
- [ViewComponents in the Real World, RailsConf 2021](https://www.youtube.com/watch?v=QoetqsBCsbE)
- [Encapsulating Views, RailsConf 2020](https://youtu.be/YVYRus_2KZM)
- [Rethinking the View Layer with Components, RailsConf 2019](https://www.youtube.com/watch?v=y5Z5a6QdA-M)

## Articles

- [Ruby-on-Rails ViewComponents tutorial and examples](https://www.bootrails.com/blog/ruby-on-rails-viewcomponents-tutorial-and-examples/)
- [From partials to ViewComponents: writing reusable front-end code in Rails](https://dev.to/nejremeslnici/from-partials-to-viewcomponents-writing-reusable-front-end-code-in-rails-1c9o)
- [Snapshot testing ViewComponents with RSpec](https://www.bearer.com/blog/snapshot-testing-viewcomponents-with-rspec)
- [Don't Cloud Your View With Logic.](https://www.beflagrant.com/blog/dont-cloud-view-with-logic)
- [The problem that ViewComponent solves for me](https://www.codewithjason.com/the-problem-that-viewcomponent-solves-for-me/)
- [Simplify Rails Views Using ViewComponents with Tailwind CSS and RSpec](https://stefcoetzee.com/rails-viewcomponent-rspec-tailwind)
- [Typed View Components with dry-types](https://ryanbigg.com/2022/03/typed-view-components)
- [Hotwire: Turbo-Streaming ViewComponents](https://thoughtbot.com/blog/hotwire-turbo-streaming-viewcomponents)
- [View Components, Storybook and Tailwind: The Holy Trinity?](https://finnian.io/blog/view-components-storybook-tailwind-the-holy-trinity/)
- [Refactoring my Ruby on Rails front-end with ViewComponent](https://anchietajunior.hashnode.dev/refactoring-my-ruby-on-rails-front-end-with-viewcomponent)
- [An Introduction to the ViewComponent Gem](https://www.honeybadger.io/blog/ruby-view-components/)
- [Building a Component Library in Rails With Storybook](https://orbit.love/blog/building-a-component-library-in-rails-with-storybook)
- [Introducing ViewComponent - The Next Level In Rails Views](https://teamhq.app/blog/tech/15-introducing-viewcomponent-the-next-level-in-rails-views)
- [Rails to Introduce View Components, Dev.to](https://dev.to/andy/rails-to-introduce-view-components-3ome)
- [ActionView::Components in Rails 6.1, Drifting Ruby](https://www.driftingruby.com/episodes/actionview-components-in-rails-6-1)

## Etcetera

- [Demo repository, view-component-demo](https://github.com/viewcomponent/demo)
