/*
 * names.h: Header for names.c
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef _NAMES_H_
#define _NAMES_H_

#include "window.h"
#include "irc.h"

/* from names.c - "iklmnpst" */
#define MODE_INVITE	((Long) 0x0001)
#define MODE_KEY	((Long) 0x0002)
#define MODE_LIMIT	((Long) 0x0004)
#define MODE_MODERATED	((Long) 0x0008)
#define MODE_MSGS	((Long) 0x0010)
#define MODE_PRIVATE	((Long) 0x0020)
#define MODE_SECRET	((Long) 0x0040)
#define MODE_TOPIC	((Long) 0x0080)

/* ChannelList: structure for the list of channels you are current on */
typedef	struct	channel_stru
{
	struct	channel_stru	*next;	/* pointer to next channel entry */
	char	*channel;		/* channel name */
	int	server;			/* server index for this channel */
	unsigned Long	mode;		/* Current mode settings for channel */
	int	limit;			/* max users for the channel */
	char	*key;			/* key for this channel */
	char	chop;			/* true if you are chop */
	Window	*window;		/* the window that the channel is "on" */
	NickList	*nicks;		/* pointer to list of nicks on channel */
}	ChannelList;

extern	int	is_channel_mode();
extern	int	is_chanop();
extern	ChannelList	*lookup_channel();
extern	char	*get_channel_mode();
extern	void	add_channel();
extern	void	add_to_channel();
extern	void	remove_channel();
extern	void	remove_from_channel();
extern	int	is_on_channel();
extern	void	list_channels();
extern	void	reconnect_all_channels();
extern	void	switch_channels();
extern	char	*what_channel();
extern	char	*walk_channels();
extern	char	*real_channel();
extern	char	*old_current_channel();
extern	void	rename_nick();
extern	void	update_channel_mode();
extern	void	set_channel_window();
extern	char	*create_channel_list();
extern	int	get_channel_oper();
extern	void	channel_server_delete();
extern	void	change_server_channels();
extern	void	clear_channel_list();

#endif /* _NAMES_H_ */
