#ifndef _LINUX_PCMCIA_H
#define _LINUX_PCMCIA_H

#include <sys/ioctl.h>

#ifdef __KERNEL__

struct pcmcia_slot {
  unsigned int flags;
  int event;
  struct wait_queue *queue;
  };

#define PCMCIA_BUSY   0x01
#define PCMCIA_EVENT  0x02

struct pcmcia_ctrl {
  int csc_irq;
  void (*csc_on)(unsigned int slot, int irq);
  void (*csc_off)(unsigned int slot);
  int (*csc_poll)(unsigned int slot);
  void (*csc_ack)(unsigned int slot, int event);
  int (*ioctl)(unsigned int slot, unsigned int cmd, unsigned long arg);
  };

#endif /* KERNEL */

/* Definitions for card status flags */
#define PC_DETECT    0x01
#define PC_BATDEAD   0x02
#define PC_BATWARN   0x04
#define PC_WRPROT    0x08
#define PC_READY     0x10
#define PC_POWERON   0x20
#define PC_GPI       0x40

/* Various card configuration flags */
#define PC_PWR_OFF   0x00
#define PC_VCC_MASK  0x03
#define PC_VCC_3V    0x01
#define PC_VCC_5V    0x02
#define PC_VPP_MASK  0x0C
#define PC_VPP_5V    0x04
#define PC_VPP_12V   0x08
#define PC_PWR_AUTO  0x10
#define PC_IOCARD    0x20
#define PC_RESET     0x40

/* Flags for I/O port and memory windows */
#define MAP_ACTIVE 0x01
#define MAP_16BIT  0x02
#define MAP_WAIT   0x04
#define MAP_0WS    0x08
#define MAP_CS16   0x10
#define MAP_WRPROT 0x20
#define MAP_ATTRIB 0x40

/* Definitions for I/O port window ioctl calls */
struct pcmcia_io_map {
  unsigned char map, flags;
  unsigned short start, stop;
  };

/* Definitions for memory window ioctl calls */
struct pcmcia_mem_map {
  unsigned char map, flags;
  unsigned char extra_ws;
  unsigned long sys_start, sys_stop;
  unsigned long card_start;
  };

/* ioctl definitions for PCMCIA devices */
#define PCMCIA_GET_STATUS     _IOR ('p', 0, unsigned int)
#define PCMCIA_GET_FLAGS      _IOR ('p', 1, unsigned int)
#define PCMCIA_SET_FLAGS      _IOW ('p', 2, unsigned int)
#define PCMCIA_GET_IRQ        _IOR ('p', 3, unsigned int)
#define PCMCIA_SET_IRQ        _IOW ('p', 4, unsigned int)
#define PCMCIA_GET_IO_MAP     _IOWR('p', 5, struct pcmcia_io_map)
#define PCMCIA_SET_IO_MAP     _IOW ('p', 6, struct pcmcia_io_map)
#define PCMCIA_GET_MEM_MAP    _IOWR('p', 7, struct pcmcia_mem_map)
#define PCMCIA_SET_MEM_MAP    _IOW ('p', 8, struct pcmcia_mem_map)

#endif /* _LINUX_PCMCIA_H */
