
package Paws::Macie2::DisableMacie;
  use Moose;

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DisableMacie');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/macie');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'DELETE');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Macie2::DisableMacieResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::DisableMacie - Arguments for method DisableMacie on L<Paws::Macie2>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DisableMacie on the
L<Amazon Macie 2|Paws::Macie2> service. Use the attributes of this class
as arguments to method DisableMacie.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DisableMacie.

=head1 SYNOPSIS

    my $macie2 = Paws->service('Macie2');
    my $DisableMacieResponse = $macie2->DisableMacie();

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/macie2/DisableMacie>

=head1 ATTRIBUTES



=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DisableMacie in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

