package Coerce::Types::Standard;

use 5.006;
use strict;
use warnings;
use parent 'Types::Standard';
our @EXPORT_OK = ( Types::Standard->type_names );

our $meta = __PACKAGE__->meta;

our $VERSION = '0.000001';

{
	# all powerfull
	no strict 'refs';
	my $counter = 0;
	*{"Type::Tiny::by"} = sub {
		my ($parent, $hide) = (shift, shift);
		my $self = do { 
			exists $meta->{types}->{$_} && exists $meta->{types}->{$_}->{abuse}
				&& $meta->{types}->{$_}->{abuse} eq "$hide" 
					and return $meta->{types}->{$_} foreach $meta->type_names; 
			undef; 
		} || $meta->add_type({ 
			name => $parent->name . $counter++,
			parent => $parent,
			coercion => $parent->{abuse}->($hide),
			abuse => $hide
		});
		return $self;
	};
}

$meta->add_type({
	name => 'StrToArray',
	parent => scalar $meta->ArrayRef, 
	abuse => \&_strToArray
});

sub _strToArray {
	my $hide = shift;
	return sub { 
		defined $_[0] ? [split $hide, $_[0]] : $_[0];
	}
}

$meta->add_type({
	name => 'StrToHash',
	parent => scalar $meta->HashRef, 
	abuse => \&_strToHash
});

sub _strToHash {
	my $hide = shift;
	return sub {
		defined $_[0] ? +{split $hide, $_[0]} : $_[0];
	}
}

$meta->add_type({
	name => 'ArrayToHash',
	parent => scalar $meta->HashRef,
	coercion => sub {
		defined $_[0] ? +{ 
			map {
				$_
			} @{ $_[0] }
		} : $_[0];
	}
});

$meta->add_type({
	name => 'HashToArray',
	parent => scalar $meta->ArrayRef,
	coercion => sub {
		defined $_[0] ? [
			map { $_, $_[0]->{$_} } sort keys %{ $_[0] }
		] : $_[0];
	}
});


# TBC .....

__PACKAGE__->meta->make_immutable;

1;

__END__

=head1 NAME

Coerce::Types::Standard - Coercing

=head1 VERSION

Version 0.01

=cut

=head1 SYNOPSIS

	package Headache;

    use Coerce::Types::Standard qw/Str HashRef ArrayRef StrToHash StrToArray/;

	attributes(
		[qw/sleep/] => [StrToHash->by(' '), {coe}]
	);

=head1 AUTHOR

Robert Acock, C<< <thisusedtobeanemail at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-coerce-types-standard at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Coerce-Types-Standard>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Coerce::Types::Standard

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Coerce-Types-Standard>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Coerce-Types-Standard>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Coerce-Types-Standard>

=item * Search CPAN

L<http://search.cpan.org/dist/Coerce-Types-Standard/>

=back

=head1 ACKNOWLEDGEMENTS

=head1 LICENSE AND COPYRIGHT

Copyright 2017 Robert Acock.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of Coerce::Types::Standard
