/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TLongDoubleHashMap;
import gnu.trove.TLongDoubleProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongDoubleHashMap
extends TLongHash
implements Serializable {
    protected transient double[] _values;

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new double[capacity];
        return capacity;
    }

    public double put(long key, double value) {
        double previous = 0.0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        double[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._values = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            long o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public double get(long key) {
        int index = this.index(key);
        return index < 0 ? 0.0 : this._values[index];
    }

    public void clear() {
        super.clear();
        long[] keys = this._set;
        double[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0L;
            vals[i] = 0.0;
            states[i] = 0;
        }
    }

    public double remove(long key) {
        double prev = 0.0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongDoubleHashMap)) {
            return false;
        }
        TLongDoubleHashMap that = (TLongDoubleHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = 0.0;
    }

    public double[] getValues() {
        double[] vals = new double[this.size()];
        double[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public long[] keys() {
        long[] keys = new long[this.size()];
        long[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(double val) {
        byte[] states = this._states;
        double[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongDoubleProcedure procedure) {
        byte[] states = this._states;
        long[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TDoubleFunction function) {
        byte[] states = this._states;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(long key) {
        return this.adjustValue(key, 1.0);
    }

    public boolean adjustValue(long key, double amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        class WriteProcedure
        implements TLongDoubleProcedure {
            IOException e;
            private final /* synthetic */ TLongDoubleHashMap this$0;
            private final /* synthetic */ ObjectOutputStream val$stream;

            public boolean execute(long key, double value) {
                try {
                    this.val$stream.writeLong(key);
                    this.val$stream.writeDouble(value);
                }
                catch (IOException ioe) {
                    this.e = ioe;
                    return false;
                }
                return true;
            }

            /* synthetic */ WriteProcedure(TLongDoubleHashMap this$0, ObjectOutputStream val$stream) {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TLongDoubleHashMap tLongDoubleHashMap) {
            }
        }
        WriteProcedure writeProcedure = new WriteProcedure(this, stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.e;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = stream.readLong();
            double val = stream.readDouble();
            this.put(key, val);
        }
    }

    public TLongDoubleHashMap() {
    }

    public TLongDoubleHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongDoubleHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    private static final class EqProcedure
    implements TLongDoubleProcedure {
        private final TLongDoubleHashMap _otherMap;

        public final boolean execute(long key, double value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(double v1, double v2) {
            return v1 == v2;
        }

        EqProcedure(TLongDoubleHashMap otherMap) {
            this._otherMap = otherMap;
        }
    }
}

