/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.stack;

import java.util.ArrayList;
import java.util.Stack;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Oracle;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.stack.StackConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwapLazyOracle
extends Oracle {
    private ArrayList<Integer> swapArray;
    private boolean swapArrayActive = false;

    public SwapLazyOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        super(manager, history);
        this.setGuideName("swaplazy");
        this.swapArray = new ArrayList();
    }

    @Override
    public GuideUserAction predict(DependencyStructure gold, ParserConfiguration configuration) throws MaltChainedException {
        StackConfig config = (StackConfig)configuration;
        Stack<DependencyNode> stack = config.getStack();
        if (!this.swapArrayActive) {
            this.createSwapArray(gold);
            this.swapArrayActive = true;
        }
        if (stack.size() < 2) {
            return this.updateActionContainers(1, null);
        }
        DependencyNode left = (DependencyNode)stack.get(stack.size() - 2);
        DependencyNode right = (DependencyNode)stack.get(stack.size() - 1);
        int leftIndex = left.getIndex();
        int rightIndex = right.getIndex();
        if (this.swapArray.get(leftIndex) > this.swapArray.get(rightIndex) && this.necessarySwap(gold, config.getDependencyGraph(), right, config.getInput())) {
            return this.updateActionContainers(2, null);
        }
        if (!left.isRoot() && gold.getTokenNode(leftIndex).getHead().getIndex() == rightIndex && this.nodeComplete(gold, config.getDependencyGraph(), leftIndex)) {
            return this.updateActionContainers(4, gold.getTokenNode(leftIndex).getHeadEdge().getLabelSet());
        }
        if (gold.getTokenNode(rightIndex).getHead().getIndex() == leftIndex && this.nodeComplete(gold, config.getDependencyGraph(), rightIndex)) {
            return this.updateActionContainers(3, gold.getTokenNode(rightIndex).getHeadEdge().getLabelSet());
        }
        return this.updateActionContainers(1, null);
    }

    private boolean nodeComplete(DependencyStructure gold, DependencyStructure parseDependencyGraph, int nodeIndex) {
        if (gold.getTokenNode(nodeIndex).hasLeftDependent()) {
            if (!parseDependencyGraph.getTokenNode(nodeIndex).hasLeftDependent()) {
                return false;
            }
            if (gold.getTokenNode(nodeIndex).getLeftmostDependent().getIndex() != parseDependencyGraph.getTokenNode(nodeIndex).getLeftmostDependent().getIndex()) {
                return false;
            }
        }
        if (gold.getTokenNode(nodeIndex).hasRightDependent()) {
            if (!parseDependencyGraph.getTokenNode(nodeIndex).hasRightDependent()) {
                return false;
            }
            if (gold.getTokenNode(nodeIndex).getRightmostDependent().getIndex() != parseDependencyGraph.getTokenNode(nodeIndex).getRightmostDependent().getIndex()) {
                return false;
            }
        }
        return true;
    }

    private boolean necessarySwap(DependencyStructure gold, DependencyStructure parse, DependencyNode node, Stack<DependencyNode> input) throws MaltChainedException {
        DependencyNode left = node;
        int index = input.size() - 1;
        if (index < 0) {
            return true;
        }
        DependencyNode right = input.peek();
        int rc = -1;
        while (this.projectiveInterval(parse, left, right)) {
            if (rc == right.getIndex()) {
                return false;
            }
            if (gold.getDependencyNode(node.getIndex()).getHead().getIndex() == right.getIndex()) {
                return !this.leftComplete(gold, node);
            }
            if (gold.getDependencyNode(right.getIndex()).getHead().getIndex() == node.getIndex()) {
                if (gold.getDependencyNode(right.getIndex()).hasRightDependent()) {
                    rc = gold.getDependencyNode(right.getIndex()).getRightmostProperDescendantIndex();
                } else {
                    return false;
                }
            }
            if (index <= 0) break;
            left = right;
            right = (DependencyNode)input.get(--index);
        }
        return true;
    }

    private boolean projectiveInterval(DependencyStructure parse, DependencyNode left, DependencyNode right) throws MaltChainedException {
        int l = this.swapArray.get(left.getIndex());
        int r = this.swapArray.get(right.getIndex());
        DependencyNode node = null;
        if (l > r) {
            return false;
        }
        for (int i = l + 1; i < r; ++i) {
            for (int j = 0; j < this.swapArray.size(); ++j) {
                if (this.swapArray.get(j) != i) continue;
                node = parse.getDependencyNode(j);
                break;
            }
            while (node.hasHead()) {
                node = node.getHead();
            }
            if (node == left || node == right) continue;
            return false;
        }
        return true;
    }

    private boolean leftComplete(DependencyStructure gold, DependencyNode right) throws MaltChainedException {
        if (!gold.getDependencyNode(right.getIndex()).hasLeftDependent()) {
            return true;
        }
        if (!right.hasLeftDependent()) {
            return false;
        }
        return gold.getDependencyNode(right.getIndex()).getLeftmostDependent().getIndex() == right.getLeftmostDependent().getIndex();
    }

    @Override
    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        this.swapArrayActive = false;
    }

    @Override
    public void terminate() throws MaltChainedException {
    }

    private void createSwapArray(DependencyStructure goldDependencyGraph) throws MaltChainedException {
        this.swapArray.clear();
        for (int i = 0; i <= goldDependencyGraph.getHighestDependencyNodeIndex(); ++i) {
            this.swapArray.add(new Integer(i));
        }
        this.createSwapArray(goldDependencyGraph.getDependencyRoot(), 0);
    }

    private int createSwapArray(DependencyNode n, int order) {
        int o = order;
        if (n != null) {
            int i;
            for (i = 0; i < n.getLeftDependentCount(); ++i) {
                o = this.createSwapArray(n.getLeftDependent(i), o);
            }
            this.swapArray.set(n.getIndex(), o++);
            for (i = n.getRightDependentCount(); i >= 0; --i) {
                o = this.createSwapArray(n.getRightDependent(i), o);
            }
        }
        return o;
    }
}

