#include "uulib/pack.h"

void uu_pack(const struct uu *in, uu_t out) {
  U32 tmp;
  //U8  *out = ptr;

  tmp = in->time_low;
  out[3] = (U8)tmp; tmp >>= 8;
  out[2] = (U8)tmp; tmp >>= 8;
  out[1] = (U8)tmp; tmp >>= 8;
  out[0] = (U8)tmp;

  tmp = in->time_mid;
  out[5] = (U8)tmp; tmp >>= 8;
  out[4] = (U8)tmp;

  tmp = in->time_high_and_version;
  out[7] = (U8)tmp; tmp >>= 8;
  out[6] = (U8)tmp;

  tmp = in->clock_seq_and_variant;
  out[9] = (U8)tmp; tmp >>= 8;
  out[8] = (U8)tmp;

  memcpy(out+10, in->node, 6);
}

void uu_pack4(const struct uu4 *in, uu_t out) {
  U32 tmp;

  tmp = in->rand_a;
  out[ 3] = (U8)tmp; tmp >>= 8;
  out[ 2] = (U8)tmp; tmp >>= 8;
  out[ 1] = (U8)tmp; tmp >>= 8;
  out[ 0] = (U8)tmp;

  tmp = in->rand_b_and_version;
  out[ 7] = (U8)tmp; tmp >>= 8;
  out[ 6] = (U8)tmp; tmp >>= 8;
  out[ 5] = (U8)tmp; tmp >>= 8;
  out[ 4] = (U8)tmp;

  tmp = in->rand_c_and_variant;
  out[11] = (U8)tmp; tmp >>= 8;
  out[10] = (U8)tmp; tmp >>= 8;
  out[ 9] = (U8)tmp; tmp >>= 8;
  out[ 8] = (U8)tmp;

  tmp = in->rand_d;
  out[15] = (U8)tmp; tmp >>= 8;
  out[14] = (U8)tmp; tmp >>= 8;
  out[13] = (U8)tmp; tmp >>= 8;
  out[12] = (U8)tmp;
}

void uu_pack6(const struct uu6 *in, uu_t out) {
  U32 tmp;

  tmp = in->time_high;
  out[3] = (U8)tmp; tmp >>= 8;
  out[2] = (U8)tmp; tmp >>= 8;
  out[1] = (U8)tmp; tmp >>= 8;
  out[0] = (U8)tmp;

  tmp = in->time_mid;
  out[5] = (U8)tmp; tmp >>= 8;
  out[4] = (U8)tmp;

  tmp = in->time_low_and_version;
  out[7] = (U8)tmp; tmp >>= 8;
  out[6] = (U8)tmp;

  tmp = in->clock_seq_and_variant;
  out[9] = (U8)tmp; tmp >>= 8;
  out[8] = (U8)tmp;

  memcpy(out+10, in->node, 6);
}

void uu_pack7(const struct uu7 *in, uu_t out) {
  U64 tmp;

  tmp = in->time_high;
  out[3] = (U8)tmp; tmp >>= 8;
  out[2] = (U8)tmp; tmp >>= 8;
  out[1] = (U8)tmp; tmp >>= 8;
  out[0] = (U8)tmp;

  tmp = in->time_low;
  out[5] = (U8)tmp; tmp >>= 8;
  out[4] = (U8)tmp;

  tmp = in->rand_a_and_version;
  out[7] = (U8)tmp; tmp >>= 8;
  out[6] = (U8)tmp;

  tmp = in->rand_b_and_variant;
  out[15] = (U8)tmp; tmp >>= 8;
  out[14] = (U8)tmp; tmp >>= 8;
  out[13] = (U8)tmp; tmp >>= 8;
  out[12] = (U8)tmp; tmp >>= 8;
  out[11] = (U8)tmp; tmp >>= 8;
  out[10] = (U8)tmp; tmp >>= 8;
  out[ 9] = (U8)tmp; tmp >>= 8;
  out[ 8] = (U8)tmp;
}

/* ex:set ts=2 sw=2 itab=spaces: */
