package Net::Async::Spotify::Object::Generated::PlaylistTrack;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::PlaylistTrack - Package representing Spotify PlaylistTrack Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify PlaylistTrack Object attributes:

=over 4

=item added_at

Type:Timestamp
Description:The date and time the track or episode was added. Note that some very old playlists may return null in this field.

=item added_by

Type:PublicUserObject
Description:The Spotify user who added the track or episode. Note that some very old playlists may return null in this field.

=item is_local

Type:Boolean
Description:Whether this track or episode is a local file or not.

=item track

Type:TrackObject | EpisodeObject
Description:Information about the track or episode.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        added_at => 'Timestamp',
        added_by => 'PublicUserObject',
        is_local => 'Boolean',
        track => 'TrackObject | EpisodeObject',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
