/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.tuebadz;

import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZHeadFinder;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZTreeReaderFactory;

public class TueBaDZLanguagePack
extends AbstractTreebankLanguagePack {
    private boolean limitedGF = false;
    private static String[] gfToKeepArray = new String[]{"ON", "OA", "OD"};
    private static String[] tuebadzPunctTags = new String[]{"$.", "$,", "$-LRB"};
    private static String[] tuebadzSFPunctTags = new String[]{"$."};
    private static String[] tuebadzPunctWords = new String[]{"`", "-", ",", ";", ":", "!", "?", "/", ".", "...", "'", "\"", "[", "]", "*"};
    private static String[] tuebadzSFPunctWords = new String[]{".", "!", "?"};
    private static char[] annotationIntroducingChars = new char[]{':', '^', '~', '%', '#', '='};
    private boolean leaveGF = false;
    private static final long serialVersionUID = 2697418320262700673L;

    public TueBaDZLanguagePack() {
        this(false);
    }

    public TueBaDZLanguagePack(boolean leaveGF) {
        this(leaveGF, '-');
    }

    public TueBaDZLanguagePack(boolean leaveGF, char gfChar) {
        this(false, leaveGF, gfChar);
    }

    public TueBaDZLanguagePack(boolean useLimitedGF, boolean leaveGF, char gfChar) {
        super(gfChar);
        this.leaveGF = leaveGF;
        this.limitedGF = useLimitedGF;
    }

    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    public String[] punctuationTags() {
        return tuebadzPunctTags;
    }

    public String[] punctuationWords() {
        return tuebadzPunctWords;
    }

    public String[] sentenceFinalPunctuationTags() {
        return tuebadzSFPunctTags;
    }

    public String[] startSymbols() {
        return new String[]{"TOP"};
    }

    public String[] sentenceFinalPunctuationWords() {
        return tuebadzSFPunctWords;
    }

    public String treebankFileExtension() {
        return ".penn";
    }

    public String basicCategory(String category) {
        String basicCat = super.basicCategory(category);
        if (!this.leaveGF) {
            basicCat = this.stripGF(basicCat);
        }
        return basicCat;
    }

    public String stripGF(String category) {
        if (category == null) {
            return null;
        }
        int index = category.lastIndexOf(this.gfCharacter);
        if (!(index <= 0 || this.limitedGF && TueBaDZLanguagePack.containsKeptGF(category, index))) {
            category = category.substring(0, index);
        }
        return category;
    }

    private static boolean containsKeptGF(String category, int index) {
        for (String gf : gfToKeepArray) {
            int gfLength = gf.length();
            if (gfLength >= category.length() - index || !category.substring(index + 1).equals(gf)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaveGF() {
        return this.leaveGF;
    }

    public void setLeaveGF(boolean leaveGF) {
        this.leaveGF = leaveGF;
    }

    public String getEncoding() {
        return "iso-8859-15";
    }

    public static void main(String[] args) {
        String[] strs;
        TueBaDZLanguagePack tlp = new TueBaDZLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        for (String str : strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3", "CARD-HD"}) {
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }

    public boolean isLimitedGF() {
        return this.limitedGF;
    }

    public void setLimitedGF(boolean limitedGF) {
        this.limitedGF = limitedGF;
    }

    public TreeReaderFactory treeReaderFactory() {
        return new TueBaDZTreeReaderFactory(this);
    }

    public HeadFinder headFinder() {
        return new TueBaDZHeadFinder();
    }
}

