/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGrammar
implements Serializable,
Iterable<BinaryRule> {
    private static final BinaryRule[] EMPTY_BINARY_RULE_ARRAY = new BinaryRule[0];
    private String stateSpace;
    private int numStates;
    private List<BinaryRule> allRules;
    private transient List<BinaryRule>[] rulesWithParent;
    private transient List<BinaryRule>[] rulesWithLC;
    private transient List<BinaryRule>[] rulesWithRC;
    private transient Set<BinaryRule>[] ruleSetWithLC;
    private transient Set<BinaryRule>[] ruleSetWithRC;
    private transient BinaryRule[][] splitRulesWithLC;
    private transient BinaryRule[][] splitRulesWithRC;
    private transient Map<BinaryRule, BinaryRule> ruleMap;
    private transient boolean[] synthetic;
    private static final long serialVersionUID = 1L;

    public int numRules() {
        return this.allRules.size();
    }

    public List<BinaryRule> rules() {
        return this.allRules;
    }

    public String stateSpace() {
        return this.stateSpace;
    }

    public boolean isSynthetic(int state) {
        return this.synthetic[state];
    }

    public void splitRules() {
        Numberer stateNumberer = Numberer.getGlobalNumberer(this.stateSpace);
        this.synthetic = new boolean[this.numStates];
        for (int s = 0; s < this.numStates; ++s) {
            try {
                if (stateNumberer.object(s) instanceof String) {
                    this.synthetic[s] = ((String)stateNumberer.object(s)).charAt(0) == '@';
                    continue;
                }
                this.synthetic[s] = ((Label)stateNumberer.object(s)).value().charAt(0) == '@';
                continue;
            }
            catch (NullPointerException e) {
                this.synthetic[s] = true;
            }
        }
        this.splitRulesWithLC = new BinaryRule[this.numStates][];
        this.splitRulesWithRC = new BinaryRule[this.numStates][];
        for (int state = 0; state < this.numStates; ++state) {
            if (this.isSynthetic(state)) {
                this.splitRulesWithLC[state] = this.rulesWithLC[state].toArray(new BinaryRule[this.rulesWithLC[state].size()]);
                this.splitRulesWithRC[state] = this.rulesWithRC[state].toArray(new BinaryRule[this.rulesWithRC[state].size()]);
                continue;
            }
            ArrayList<BinaryRule> ruleList = new ArrayList<BinaryRule>();
            for (BinaryRule br : this.rulesWithLC[state]) {
                if (this.isSynthetic(br.rightChild)) continue;
                ruleList.add(br);
            }
            this.splitRulesWithLC[state] = ruleList.toArray(new BinaryRule[ruleList.size()]);
            ruleList.clear();
            for (BinaryRule br : this.rulesWithRC[state]) {
                if (this.isSynthetic(br.leftChild)) continue;
                ruleList.add(br);
            }
            this.splitRulesWithRC[state] = ruleList.toArray(new BinaryRule[ruleList.size()]);
        }
    }

    public BinaryRule[] splitRulesWithLC(int state) {
        if (state >= this.splitRulesWithLC.length) {
            return EMPTY_BINARY_RULE_ARRAY;
        }
        return this.splitRulesWithLC[state];
    }

    public BinaryRule[] splitRulesWithRC(int state) {
        if (state >= this.splitRulesWithRC.length) {
            return EMPTY_BINARY_RULE_ARRAY;
        }
        return this.splitRulesWithRC[state];
    }

    public double scoreRule(BinaryRule br) {
        BinaryRule rule = this.ruleMap.get(br);
        return rule != null ? (double)rule.score : Double.NEGATIVE_INFINITY;
    }

    public void addRule(BinaryRule br) {
        this.rulesWithParent[br.parent].add(br);
        this.rulesWithLC[br.leftChild].add(br);
        this.rulesWithRC[br.rightChild].add(br);
        this.ruleSetWithLC[br.leftChild].add(br);
        this.ruleSetWithRC[br.rightChild].add(br);
        this.allRules.add(br);
        this.ruleMap.put(br, br);
    }

    @Override
    public Iterator<BinaryRule> iterator() {
        return this.allRules.iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            return Collections.emptyList().iterator();
        }
        return this.rulesWithParent[state].iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByRightChild(int state) {
        if (state >= this.rulesWithRC.length) {
            return Collections.emptyList().iterator();
        }
        return this.rulesWithRC[state].iterator();
    }

    public Iterator<BinaryRule> ruleIteratorByLeftChild(int state) {
        if (state >= this.rulesWithLC.length) {
            return Collections.emptyList().iterator();
        }
        return this.rulesWithLC[state].iterator();
    }

    public List<BinaryRule> ruleListByParent(int state) {
        if (state >= this.rulesWithParent.length) {
            return Collections.emptyList();
        }
        return this.rulesWithParent[state];
    }

    public List<BinaryRule> ruleListByRightChild(int state) {
        if (state >= this.rulesWithRC.length) {
            return Collections.emptyList();
        }
        return this.rulesWithRC[state];
    }

    public List<BinaryRule> ruleListByLeftChild(int state) {
        if (state >= this.rulesWithRC.length) {
            return Collections.emptyList();
        }
        return this.rulesWithLC[state];
    }

    public Set<BinaryRule> ruleSetByRightChild(int state) {
        if (state >= this.ruleSetWithRC.length) {
            return Collections.emptySet();
        }
        return this.ruleSetWithRC[state];
    }

    public Set<BinaryRule> ruleSetByLeftChild(int state) {
        if (state >= this.ruleSetWithRC.length) {
            return Collections.emptySet();
        }
        return this.ruleSetWithLC[state];
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
        for (BinaryRule br : this.allRules) {
            this.rulesWithParent[br.parent].add(br);
            this.rulesWithLC[br.leftChild].add(br);
            this.rulesWithRC[br.rightChild].add(br);
            this.ruleMap.put(br, br);
        }
    }

    private void init() {
        this.ruleMap = new HashMap<BinaryRule, BinaryRule>();
        this.rulesWithParent = new List[this.numStates];
        this.rulesWithLC = new List[this.numStates];
        this.rulesWithRC = new List[this.numStates];
        this.ruleSetWithLC = new Set[this.numStates];
        this.ruleSetWithRC = new Set[this.numStates];
        for (int s = 0; s < this.numStates; ++s) {
            this.rulesWithParent[s] = new ArrayList<BinaryRule>();
            this.rulesWithLC[s] = new ArrayList<BinaryRule>();
            this.rulesWithRC[s] = new ArrayList<BinaryRule>();
            this.ruleSetWithLC[s] = new HashSet<BinaryRule>();
            this.ruleSetWithRC[s] = new HashSet<BinaryRule>();
        }
    }

    public BinaryGrammar(int numStates) {
        this(numStates, "states");
    }

    public BinaryGrammar(int numStates, String stateSpace) {
        this.stateSpace = stateSpace;
        this.numStates = numStates;
        this.allRules = new ArrayList<BinaryRule>();
        this.init();
    }

    public void readData(BufferedReader in) throws IOException {
        int lineNum = 1;
        Numberer n = Numberer.getGlobalNumberer("states");
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            try {
                this.addRule(new BinaryRule(line, n));
            }
            catch (Exception e) {
                throw new IOException("Error on line " + lineNum);
            }
            ++lineNum;
            line = in.readLine();
        }
        this.splitRules();
    }

    public void writeData(Writer w) throws IOException {
        PrintWriter out2 = new PrintWriter(w);
        for (BinaryRule br : this) {
            out2.println(br);
        }
        out2.flush();
    }
}

