#include "perly-latest.h"
enum token_type {
    TOKENTYPE_NONE,
    TOKENTYPE_IVAL,
    TOKENTYPE_OPNUM, /* pl_yylval.ival contains an opcode number */
    TOKENTYPE_PVAL,
    TOKENTYPE_OPVAL
};

static struct debug_tokens {
    const int token;
    enum token_type type;
    const char *name;
} const debug_tokens[] =
{
    DEBUG_TOKEN (OPNUM, ADDOP),
    DEBUG_TOKEN (NONE,  ANDAND),
    DEBUG_TOKEN (NONE,  ANDOP),
    DEBUG_TOKEN (NONE,  ARROW),
    DEBUG_TOKEN (OPNUM, ASSIGNOP),
    DEBUG_TOKEN (OPNUM, BITANDOP),
    DEBUG_TOKEN (OPNUM, BITOROP),
    DEBUG_TOKEN (OPNUM, CHEQOP),
    DEBUG_TOKEN (OPNUM, CHRELOP),
    DEBUG_TOKEN (NONE,  COLONATTR),
    DEBUG_TOKEN (NONE,  DOLSHARP),
    DEBUG_TOKEN (NONE,  DORDOR),
    DEBUG_TOKEN (IVAL,  DOTDOT),
    DEBUG_TOKEN (NONE,  FORMLBRACK),
    DEBUG_TOKEN (NONE,  FORMRBRACK),
    DEBUG_TOKEN (OPNUM, FUNC),
    DEBUG_TOKEN (OPNUM, FUNC0),
    DEBUG_TOKEN (OPVAL, FUNC0OP),
    DEBUG_TOKEN (OPVAL, FUNC0SUB),
    DEBUG_TOKEN (OPNUM, FUNC1),
    DEBUG_TOKEN (NONE,  HASHBRACK),
    DEBUG_TOKEN (IVAL,  KW_CATCH),
    DEBUG_TOKEN (IVAL,  KW_CLASS),
    DEBUG_TOKEN (IVAL,  KW_CONTINUE),
    DEBUG_TOKEN (IVAL,  KW_DEFAULT),
    DEBUG_TOKEN (IVAL,  KW_DO),
    DEBUG_TOKEN (IVAL,  KW_ELSE),
    DEBUG_TOKEN (IVAL,  KW_ELSIF),
    DEBUG_TOKEN (IVAL,  KW_FIELD),
    DEBUG_TOKEN (IVAL,  KW_GIVEN),
    DEBUG_TOKEN (IVAL,  KW_FOR),
    DEBUG_TOKEN (IVAL,  KW_FORMAT),
    DEBUG_TOKEN (IVAL,  KW_IF),
    DEBUG_TOKEN (IVAL,  KW_LOCAL),
    DEBUG_TOKEN (IVAL,  KW_METHOD_anon),
    DEBUG_TOKEN (IVAL,  KW_METHOD_named),
    DEBUG_TOKEN (IVAL,  KW_MY),
    DEBUG_TOKEN (IVAL,  KW_PACKAGE),
    DEBUG_TOKEN (IVAL,  KW_REQUIRE),
    DEBUG_TOKEN (IVAL,  KW_SUB_anon),
    DEBUG_TOKEN (IVAL,  KW_SUB_anon_sig),
    DEBUG_TOKEN (IVAL,  KW_SUB_named),
    DEBUG_TOKEN (IVAL,  KW_SUB_named_sig),
    DEBUG_TOKEN (IVAL,  KW_TRY),
    DEBUG_TOKEN (IVAL,  KW_USE_or_NO),
    DEBUG_TOKEN (IVAL,  KW_UNLESS),
    DEBUG_TOKEN (IVAL,  KW_UNTIL),
    DEBUG_TOKEN (IVAL,  KW_WHEN),
    DEBUG_TOKEN (IVAL,  KW_WHILE),
    DEBUG_TOKEN (OPVAL, LABEL),
    DEBUG_TOKEN (OPNUM, LOOPEX),
    DEBUG_TOKEN (OPNUM, LSTOP),
    DEBUG_TOKEN (OPVAL, LSTOPSUB),
    DEBUG_TOKEN (OPNUM, MATCHOP),
    DEBUG_TOKEN (OPVAL, METHCALL),
    DEBUG_TOKEN (OPVAL, METHCALL0),
    DEBUG_TOKEN (OPNUM, MULOP),
    DEBUG_TOKEN (OPNUM, NCEQOP),
    DEBUG_TOKEN (OPNUM, NCRELOP),
    DEBUG_TOKEN (NONE,  NOAMP),
    DEBUG_TOKEN (NONE,  NOTOP),
    DEBUG_TOKEN (IVAL,  OROP),
    DEBUG_TOKEN (NONE,  OROR),
    DEBUG_TOKEN (IVAL,  PERLY_AMPERSAND),
    DEBUG_TOKEN (IVAL,  PERLY_BRACE_CLOSE),
    DEBUG_TOKEN (IVAL,  PERLY_BRACE_OPEN),
    DEBUG_TOKEN (IVAL,  PERLY_BRACKET_CLOSE),
    DEBUG_TOKEN (IVAL,  PERLY_BRACKET_OPEN),
    DEBUG_TOKEN (IVAL,  PERLY_COLON),
    DEBUG_TOKEN (IVAL,  PERLY_COMMA),
    DEBUG_TOKEN (IVAL,  PERLY_DOT),
    DEBUG_TOKEN (IVAL,  PERLY_EQUAL_SIGN),
    DEBUG_TOKEN (IVAL,  PERLY_EXCLAMATION_MARK),
    DEBUG_TOKEN (IVAL,  PERLY_MINUS),
    DEBUG_TOKEN (IVAL,  PERLY_PAREN_OPEN),
    DEBUG_TOKEN (IVAL,  PERLY_PERCENT_SIGN),
    DEBUG_TOKEN (IVAL,  PERLY_PLUS),
    DEBUG_TOKEN (IVAL,  PERLY_QUESTION_MARK),
    DEBUG_TOKEN (IVAL,  PERLY_SEMICOLON),
    DEBUG_TOKEN (IVAL,  PERLY_SLASH),
    DEBUG_TOKEN (IVAL,  PERLY_SNAIL),
    DEBUG_TOKEN (IVAL,  PERLY_STAR),
    DEBUG_TOKEN (IVAL,  PERLY_TILDE),
    DEBUG_TOKEN (OPVAL, PLUGEXPR),
    DEBUG_TOKEN (OPVAL, PLUGSTMT),
    DEBUG_TOKEN (PVAL,  PLUGIN_ADD_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_ASSIGN_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_HIGH_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_LOGICAL_AND_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_LOGICAL_OR_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_LOGICAL_AND_LOW_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_LOGICAL_OR_LOW_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_LOW_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_MUL_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_POW_OP),
    DEBUG_TOKEN (PVAL,  PLUGIN_REL_OP),
    DEBUG_TOKEN (OPVAL, PMFUNC),
    DEBUG_TOKEN (NONE,  POSTJOIN),
    DEBUG_TOKEN (NONE,  POSTDEC),
    DEBUG_TOKEN (NONE,  POSTINC),
    DEBUG_TOKEN (OPNUM, POWOP),
    DEBUG_TOKEN (NONE,  PREDEC),
    DEBUG_TOKEN (NONE,  PREINC),
    DEBUG_TOKEN (OPVAL, PRIVATEREF),
    DEBUG_TOKEN (OPVAL, QWLIST),
    DEBUG_TOKEN (NONE,  REFGEN),
    DEBUG_TOKEN (OPNUM, SHIFTOP),
    DEBUG_TOKEN (NONE,  SUBLEXEND),
    DEBUG_TOKEN (NONE,  SUBLEXSTART),
    DEBUG_TOKEN (OPVAL, THING),
    DEBUG_TOKEN (NONE,  UMINUS),
    DEBUG_TOKEN (OPNUM, UNIOP),
    DEBUG_TOKEN (OPVAL, UNIOPSUB),
    DEBUG_TOKEN (OPVAL, BAREWORD),
    DEBUG_TOKEN (IVAL,  YADAYADA),
    { 0,		TOKENTYPE_NONE,		NULL }
};

