/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;

class StateGrabber {
    StateGrabber() {
    }

    static String getAllPoolsJSON(CouchbaseMock mock) {
        HashMap<String, Object> retObj = new HashMap<String, Object>();
        ArrayList pools = new ArrayList();
        HashMap<String, String> defaultPool = new HashMap<String, String>();
        defaultPool.put("name", mock.getPoolName());
        defaultPool.put("uri", "/pools/" + mock.getPoolName());
        defaultPool.put("streamingUri", "/poolsStreaming/" + mock.getPoolName());
        pools.add(defaultPool);
        retObj.put("pools", pools);
        retObj.put("isAdminCreds", Boolean.TRUE);
        retObj.put("implementationVersion", "CouchbaseMock");
        return JSONObject.fromObject(retObj).toString();
    }

    static String getPoolInfoJSON(CouchbaseMock mock) {
        HashMap poolInfo = new HashMap();
        HashMap<String, String> buckets = new HashMap<String, String>();
        poolInfo.put("buckets", buckets);
        buckets.put("uri", "/pools/" + mock.getPoolName() + "/buckets");
        return JSONObject.fromObject(poolInfo).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getBucketJSON(Bucket bucket) {
        String ret;
        bucket.configReadLock();
        try {
            ret = bucket.getJSON();
        }
        finally {
            bucket.configReadUnlock();
        }
        return ret;
    }

    static String getAllBucketsJSON(List<Bucket> allowedBuckets) {
        JSONArray bucketsJSON = new JSONArray();
        for (Bucket bucket : allowedBuckets) {
            bucketsJSON.add(StateGrabber.getBucketJSON(bucket));
        }
        return bucketsJSON.toString();
    }
}

