/*
 * Decompiled with CFR 0.152.
 */
package gma.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InputFileHandler {
    private BufferedReader reader = null;
    private String nextLine = null;

    public InputFileHandler(String fileName) {
        try {
            this.reader = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.close();
            System.exit(1);
        }
    }

    public boolean hasLine() {
        this.nextLine = null;
        try {
            this.nextLine = this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
            System.exit(1);
        }
        return this.nextLine != null;
    }

    public String nextLine() {
        return this.nextLine;
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List readWordList() {
        ArrayList<String> words = new ArrayList<String>();
        while (this.hasLine()) {
            String word = this.nextLine();
            words.add(word);
        }
        this.close();
        return words;
    }
}

