/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.stack;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.stack.StackAddressFunction;
import org.maltparser.parser.algorithm.stack.StackConfig;

public abstract class StackFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public StackFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Stack\n");
        }
        return new StackConfig(this.manager.getSymbolTables());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new StackAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

