/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature.spec;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationSubModel
implements Iterable<String> {
    private Map<String, Integer> featureSpec2IndexMap;
    private int counter;
    private String name;

    public SpecificationSubModel() {
        this("MAIN");
    }

    public SpecificationSubModel(String name) {
        this.setSubModelName(name);
        this.featureSpec2IndexMap = new LinkedHashMap<String, Integer>();
        this.counter = 0;
    }

    public void add(String featureSpec) {
        if (!this.featureSpec2IndexMap.containsKey(featureSpec)) {
            this.featureSpec2IndexMap.put(featureSpec, this.counter++);
        }
    }

    public int getFeatureIndex(String featureSpec) {
        if (this.featureSpec2IndexMap.containsKey(featureSpec)) {
            return -1;
        }
        return this.featureSpec2IndexMap.get(featureSpec);
    }

    public String getFeatureSpec(int featureId) {
        if (featureId < 0 || featureId >= this.featureSpec2IndexMap.size()) {
            return null;
        }
        return this.featureSpec2IndexMap.keySet().toArray(new String[0])[featureId];
    }

    public String getSubModelName() {
        return this.name;
    }

    public void setSubModelName(String name) {
        this.name = name;
    }

    public int size() {
        return this.featureSpec2IndexMap.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.featureSpec2IndexMap.keySet().iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.featureSpec2IndexMap.size() != ((SpecificationSubModel)obj).size()) {
            return false;
        }
        for (String str : this) {
            if (str.equals(((SpecificationSubModel)obj).getFeatureSpec(this.featureSpec2IndexMap.get(str)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this) {
            sb.append(this.featureSpec2IndexMap.get(str));
            sb.append('\t');
            sb.append(str);
            sb.append('\n');
        }
        return sb.toString();
    }
}

