/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static List<Integer> asList(int[] a) {
        ArrayList<Integer> result = new ArrayList<Integer>(a.length);
        for (int i = 0; i < a.length; ++i) {
            result.add(a[i]);
        }
        return result;
    }

    public static List<Double> asList(double[] a) {
        ArrayList<Double> result = new ArrayList<Double>(a.length);
        for (int i = 0; i < a.length; ++i) {
            result.add(new Double(a[i]));
        }
        return result;
    }

    public static int[] asIntArray(Collection<Integer> coll) {
        int[] result = new int[coll.size()];
        int index = 0;
        for (Integer element : coll) {
            result[index] = element;
            ++index;
        }
        return result;
    }

    public static double[] asDoubleArray(Collection<Double> coll) {
        double[] result = new double[coll.size()];
        int index = 0;
        for (Double element : coll) {
            result[index] = element;
            ++index;
        }
        return result;
    }

    public static <T> List<T> makeList(T ... items) {
        ArrayList<T> s = new ArrayList<T>(items.length);
        for (int i = 0; i < items.length; ++i) {
            s.add(items[i]);
        }
        return s;
    }

    public static <T> Set<T> asSet(T[] o) {
        return new HashSet<T>(Arrays.asList(o));
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> intersect = new HashSet<T>();
        for (T t : set1) {
            if (!set2.contains(t)) continue;
            intersect.add(t);
        }
        return intersect;
    }

    public static <T> Collection<T> union(Collection<T> set1, Collection<T> set2) {
        ArrayList<T> union = new ArrayList<T>();
        for (T t : set1) {
            union.add(t);
        }
        for (T t : set2) {
            union.add(t);
        }
        return union;
    }

    public static <T> Set<T> unionAsSet(Collection<T> set1, Collection<T> set2) {
        HashSet<T> union = new HashSet<T>();
        for (T t : set1) {
            union.add(t);
        }
        for (T t : set2) {
            union.add(t);
        }
        return union;
    }

    public static <T> Collection<T> diff(Collection<T> list1, Collection<T> list2) {
        ArrayList<T> diff = new ArrayList<T>();
        for (T t : list1) {
            if (list2.contains(t)) continue;
            diff.add(t);
        }
        return diff;
    }

    public static <T> Collection<T> loadCollection(String filename, Class<T> c, CollectionFactory<T> cf) throws Exception {
        return CollectionUtils.loadCollection(new File(filename), c, cf);
    }

    public static <T> Collection<T> loadCollection(File file, Class<T> c, CollectionFactory<T> cf) throws Exception {
        Constructor<T> m = c.getConstructor(Class.forName("java.lang.String"));
        Collection<T> result = cf.newCollection();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            try {
                T o = m.newInstance(line);
                result.add(o);
            }
            catch (Exception e) {
                System.err.println("Couldn't build object from line: " + line);
                e.printStackTrace();
            }
            line = in.readLine();
        }
        in.close();
        return result;
    }

    public static <T> void loadCollection(String fileName, Class<T> itemClass, Collection<T> collection) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        CollectionUtils.loadCollection(new File(fileName), itemClass, collection);
    }

    public static <T> void loadCollection(File file, Class<T> itemClass, Collection<T> collection) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        Constructor<T> itemConstructor = itemClass.getConstructor(String.class);
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            T t = itemConstructor.newInstance(line);
            collection.add(t);
            line = in.readLine();
        }
        in.close();
    }

    public static <K, V> Map<K, V> getMapFromString(String s, Class<K> keyClass, Class<V> valueClass, MapFactory<K, V> mapFactory) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<K> keyC = keyClass.getConstructor(Class.forName("java.lang.String"));
        Constructor<V> valueC = valueClass.getConstructor(Class.forName("java.lang.String"));
        if (s.charAt(0) != '{') {
            throw new RuntimeException("");
        }
        s = s.substring(1);
        String[] fields = s.split("\\s+");
        Map<K, V> m = mapFactory.newMap();
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].substring(0, fields[i].length() - 1);
            String[] a = fields[i].split("=");
            K key = keyC.newInstance(a[0]);
            V value = a.length > 1 ? valueC.newInstance(a[1]) : valueC.newInstance("");
            m.put(key, value);
        }
        return m;
    }

    public static <T> boolean containsObject(Collection<T> c, T o) {
        for (T o1 : c) {
            if (o != o1) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean removeObject(List<T> l, T o) {
        int i = 0;
        for (T o1 : l) {
            if (o == o1) {
                l.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> int getIndex(List<T> l, T o) {
        int i = 0;
        for (T o1 : l) {
            if (o == o1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int getIndex(List<T> l, T o, int fromIndex) {
        int i = -1;
        for (T o1 : l) {
            if (++i < fromIndex || !o.equals(o1)) continue;
            return i;
        }
        return -1;
    }

    public static <E> Collection<E> sampleWithoutReplacement(Collection<E> c, int n) {
        return CollectionUtils.sampleWithoutReplacement(c, n, new Random());
    }

    public static <E> Collection<E> sampleWithoutReplacement(Collection<E> c, int n, Random r) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0: " + n);
        }
        if (n > c.size()) {
            throw new IllegalArgumentException("n > size of collection: " + n + ", " + c.size());
        }
        ArrayList<E> copy = new ArrayList<E>(c.size());
        copy.addAll(c);
        ArrayList result = new ArrayList(n);
        for (int k = 0; k < n; ++k) {
            double d = r.nextDouble();
            int x = (int)(d * (double)copy.size());
            result.add(copy.remove(x));
        }
        return result;
    }

    public static <E> E sample(List<E> l, Random r) {
        int i = r.nextInt(l.size());
        return l.get(i);
    }

    public static <E> Collection<E> sampleWithReplacement(Collection<E> c, int n) {
        return CollectionUtils.sampleWithReplacement(c, n, new Random());
    }

    public static <E> Collection<E> sampleWithReplacement(Collection<E> c, int n, Random r) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0: " + n);
        }
        ArrayList<E> copy = new ArrayList<E>(c.size());
        copy.addAll(c);
        ArrayList result = new ArrayList(n);
        for (int k = 0; k < n; ++k) {
            double d = r.nextDouble();
            int x = (int)(d * (double)copy.size());
            result.add(copy.get(x));
        }
        return result;
    }

    public static <T> boolean isSubList(List<T> l1, List<? super T> l) {
        Iterator<T> it = l.iterator();
        for (T o1 : l1) {
            if (!it.hasNext()) {
                return false;
            }
            T o = it.next();
            while (o == null && o1 != null || o != null && !o.equals(o1)) {
                if (!it.hasNext()) {
                    return false;
                }
                o = it.next();
            }
        }
        return true;
    }

    public static <K, V> String toVerticalString(Map<K, V> m) {
        StringBuilder b = new StringBuilder();
        Set<Map.Entry<K, V>> entries = m.entrySet();
        for (Map.Entry<K, V> e : entries) {
            b.append(e.getKey()).append('=').append(e.getValue()).append('\n');
        }
        return b.toString();
    }

    public static <T extends Comparable<T>> int compareLists(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return 0;
        }
        if (list1 == null || list2 == null) {
            throw new IllegalArgumentException();
        }
        int size1 = list1.size();
        int size2 = list2.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            int c = ((Comparable)list1.get(i)).compareTo(list2.get(i));
            if (c == 0) continue;
            return c;
        }
        if (size1 < size2) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        return 0;
    }

    public static <C extends Comparable<C>> Comparator<List<C>> getListComparator() {
        return new Comparator<List<C>>(){

            @Override
            public int compare(List<C> list1, List<C> list2) {
                return CollectionUtils.compareLists(list1, list2);
            }
        };
    }

    public static <T extends Comparable<T>> List<T> sorted(Iterable<T> items) {
        List<T> result = CollectionUtils.toList(items);
        Collections.sort(result);
        return result;
    }

    public static <T> List<T> sorted(Iterable<T> items, Comparator<T> comparator) {
        List<T> result = CollectionUtils.toList(items);
        Collections.sort(result, comparator);
        return result;
    }

    public static <T> List<T> toList(Iterable<T> items) {
        ArrayList list = new ArrayList();
        CollectionUtils.addAll(list, items);
        return list;
    }

    public static <T> Set<T> toSet(Iterable<T> items) {
        HashSet set = new HashSet();
        CollectionUtils.addAll(set, items);
        return set;
    }

    public static <T> void addAll(Collection<T> collection, Iterable<? extends T> items) {
        for (T item : items) {
            collection.add(item);
        }
    }

    public static <T> List<List<T>> getNGrams(List<T> items, int minSize, int maxSize) {
        ArrayList<List<T>> ngrams = new ArrayList<List<T>>();
        int listSize = items.size();
        for (int i = 0; i < listSize; ++i) {
            for (int ngramSize = minSize; ngramSize <= maxSize; ++ngramSize) {
                if (i + ngramSize > listSize) continue;
                ArrayList<T> ngram = new ArrayList<T>();
                for (int j = i; j < i + ngramSize; ++j) {
                    ngram.add(items.get(j));
                }
                ngrams.add(ngram);
            }
        }
        return ngrams;
    }

    public static <T> List<List<T>> getPrefixesAndSuffixes(List<T> items, int minSize, int maxSize, T paddingSymbol, boolean includePrefixes, boolean includeSuffixes) {
        assert (minSize > 0);
        assert (maxSize >= minSize);
        assert (includePrefixes || includeSuffixes);
        ArrayList<List<T>> prefixesAndSuffixes = new ArrayList<List<T>>();
        for (int span = minSize - 1; span < maxSize; ++span) {
            int i;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            ArrayList<T> seq = new ArrayList<T>();
            if (includePrefixes) {
                for (int i2 = 0; i2 <= span; ++i2) {
                    indices.add(i2);
                }
            }
            if (includeSuffixes) {
                int maxIndex = items.size() - 1;
                for (i = span; i >= 0; --i) {
                    indices.add(maxIndex - i);
                }
            }
            Iterator i$ = indices.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                try {
                    seq.add(items.get(i));
                }
                catch (IndexOutOfBoundsException ioobe) {
                    seq.add(paddingSymbol);
                }
            }
            prefixesAndSuffixes.add(seq);
        }
        return prefixesAndSuffixes;
    }

    public static <T, M> List<T> mergeList(List<? extends T> list, Collection<M> matched, Function<M, Interval<Integer>> toIntervalFunc, Function<List<? extends T>, T> aggregator) {
        ArrayList<Interval<Integer>> matchedIntervals = new ArrayList<Interval<Integer>>(matched.size());
        for (M m : matched) {
            matchedIntervals.add(toIntervalFunc.apply(m));
        }
        return CollectionUtils.mergeList(list, matchedIntervals, aggregator);
    }

    public static <T> List<T> mergeList(List<? extends T> list, List<? extends HasInterval<Integer>> matched, Function<List<? extends T>, T> aggregator) {
        Collections.sort(matched, HasInterval.ENDPOINTS_COMPARATOR);
        return CollectionUtils.mergeListWithSortedMatched(list, matched, aggregator);
    }

    public static <T> List<T> mergeListWithSortedMatched(List<? extends T> list, List<? extends HasInterval<Integer>> matched, Function<List<? extends T>, T> aggregator) {
        ArrayList<T> merged = new ArrayList<T>(list.size());
        int last = 0;
        for (HasInterval<Integer> hasInterval : matched) {
            Interval<Integer> interval = hasInterval.getInterval();
            int start = interval.getBegin();
            int end = interval.getEnd();
            if (start < last) continue;
            merged.addAll(list.subList(last, start));
            T t = aggregator.apply(list.subList(start, end));
            merged.add(t);
            last = end;
        }
        if (last < list.size()) {
            merged.addAll(list.subList(last, list.size()));
        }
        return merged;
    }

    public static <T> List<T> mergeListWithSortedMatchedPreAggregated(List<? extends T> list, List<? extends T> matched, Function<T, Interval<Integer>> toIntervalFunc) {
        ArrayList<Object> merged = new ArrayList<Object>(list.size());
        int last = 0;
        for (T m : matched) {
            Interval<Integer> interval = toIntervalFunc.apply(m);
            int start = interval.getBegin();
            int end = interval.getEnd();
            if (start < last) continue;
            merged.addAll(list.subList(last, start));
            merged.add(m);
            last = end;
        }
        if (last < list.size()) {
            merged.addAll(list.subList(last, list.size()));
        }
        return merged;
    }

    public static <T> List<T> flatten(Collection<List<T>> nestedList) {
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> list : nestedList) {
            result.addAll(list);
        }
        return result;
    }

    public static <ObjType, Hashable> Collection<ObjType> uniqueNonhashableObjects(Collection<ObjType> objects, Function<ObjType, Hashable> customHasher) {
        HashMap<Hashable, ObjType> hashesToObjects = new HashMap<Hashable, ObjType>();
        for (ObjType object : objects) {
            hashesToObjects.put(customHasher.apply(object), object);
        }
        return hashesToObjects.values();
    }

    public static <T> boolean containsAny(Collection<T> collection, Collection<T> toCheck) {
        for (T c : toCheck) {
            if (!collection.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<Collection<T>> partitionIntoFolds(List<T> values, int numFolds) {
        ArrayList<Collection<T>> folds = new ArrayList<Collection<T>>();
        int numValues = values.size();
        int foldSize = numValues / numFolds;
        int remainder = numValues % numFolds;
        int start = 0;
        int end = foldSize;
        for (int foldNum = 0; foldNum < numFolds; ++foldNum) {
            if (foldNum < remainder) {
                ++end;
            }
            folds.add(values.subList(start, end));
            start = end;
            end += foldSize;
        }
        return folds;
    }

    public static <T> Collection<Pair<Collection<T>, Collection<T>>> trainTestFoldsForCV(List<T> values, int numFolds) {
        ArrayList<Pair<Collection<T>, Collection<T>>> trainTestPairs = new ArrayList<Pair<Collection<T>, Collection<T>>>();
        List<Collection<T>> folds = CollectionUtils.partitionIntoFolds(values, numFolds);
        for (int splitNum = 0; splitNum < numFolds; ++splitNum) {
            Collection<T> test = folds.get(splitNum);
            ArrayList<T> train = new ArrayList<T>();
            for (int foldNum = 0; foldNum < numFolds; ++foldNum) {
                if (foldNum == splitNum) continue;
                train.addAll(folds.get(foldNum));
            }
            trainTestPairs.add(new Pair(train, test));
        }
        return trainTestPairs;
    }

    public static <T> Set<T> modes(Collection<T> values) {
        ClassicCounter<T> counter = new ClassicCounter<T>(values);
        List<Double> sortedCounts = CollectionUtils.sorted(counter.values());
        Double highestCount = sortedCounts.get(sortedCounts.size() - 1);
        Counters.retainAbove(counter, highestCount);
        return counter.keySet();
    }

    public static <T> T mode(Collection<T> values) {
        Set<T> modes = CollectionUtils.modes(values);
        return modes.iterator().next();
    }

    public static <T1, T2> Set<T2> transformAsSet(Collection<T1> original, Function<T1, T2> f) {
        HashSet<T2> transformed = new HashSet<T2>();
        for (T1 t : original) {
            transformed.add(f.apply(t));
        }
        return transformed;
    }
}

