/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.charniak;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.StringOutputStream;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.IterableIterator;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CharniakScoredParsesReaderWriter {
    private static final Logger logger = Logger.getLogger(CharniakScoredParsesReaderWriter.class.getName());
    private static final Pattern wsDelimiter = Pattern.compile("\\s+");

    public Iterable<List<ScoredObject<Tree>>> readScoredTrees(String filename) {
        try {
            ScoredParsesIterator iter = new ScoredParsesIterator(filename);
            return new IterableIterator<List<ScoredObject<Tree>>>(iter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Iterable<List<ScoredObject<Tree>>> readScoredTrees(String inputDesc, BufferedReader br) {
        ScoredParsesIterator iter = new ScoredParsesIterator(inputDesc, br);
        return new IterableIterator<List<ScoredObject<Tree>>>(iter);
    }

    public List<ScoredObject<Tree>> stringToParses(String parseStr) {
        try {
            Iterator<List<ScoredObject<Tree>>> iter;
            BufferedReader br = new BufferedReader(new StringReader(parseStr));
            Iterable<List<ScoredObject<Tree>>> trees = this.readScoredTrees("", br);
            List<ScoredObject<Tree>> res = null;
            if (trees != null && (iter = trees.iterator()) != null && iter.hasNext()) {
                res = iter.next();
            }
            br.close();
            return res;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String parsesToString(List<ScoredObject<Tree>> parses) {
        if (parses == null) {
            return null;
        }
        StringOutputStream os = new StringOutputStream();
        PrintWriter pw = new PrintWriter(os);
        this.printScoredTrees(pw, 0, parses);
        pw.close();
        return os.toString();
    }

    public void printScoredTrees(Iterable<List<ScoredObject<Tree>>> trees, String filename) {
        try {
            PrintWriter pw = IOUtils.getPrintWriter(filename);
            int i = 0;
            for (List<ScoredObject<Tree>> treeList : trees) {
                this.printScoredTrees(pw, i, treeList);
                ++i;
            }
            pw.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void printScoredTrees(PrintWriter pw, int id, List<ScoredObject<Tree>> trees) {
        pw.println(trees.size() + "\t" + id);
        for (ScoredObject<Tree> scoredTree : trees) {
            pw.println(scoredTree.score());
            pw.println(scoredTree.object());
        }
    }

    private static class ScoredParsesIterator
    extends AbstractIterator<List<ScoredObject<Tree>>> {
        String inputDesc;
        BufferedReader br;
        List<ScoredObject<Tree>> next;
        Timing timing;
        int processed = 0;
        boolean done = false;
        boolean closeBufferNeeded = true;
        boolean expectConsecutiveSentenceIds = true;
        int lastSentenceId = -1;

        private ScoredParsesIterator(String filename) throws IOException {
            this(filename, IOUtils.getBufferedFileReader(filename));
        }

        private ScoredParsesIterator(String inputDesc, BufferedReader br) {
            this.inputDesc = inputDesc;
            this.br = br;
            logger.info("Reading cached parses from " + inputDesc);
            this.timing = new Timing();
            this.timing.start();
            this.next = this.getNext();
            this.done = this.next == null;
        }

        private List<ScoredObject<Tree>> getNext() {
            try {
                String line;
                int parsesExpected = 0;
                int sentenceId = this.lastSentenceId;
                ScoredObject<Object> curParse = null;
                ArrayList<ScoredObject<Object>> curParses = null;
                while ((line = this.br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    if (parsesExpected == 0) {
                        String[] fields = wsDelimiter.split(line, 2);
                        parsesExpected = Integer.parseInt(fields[0]);
                        sentenceId = Integer.parseInt(fields[1]);
                        if (this.expectConsecutiveSentenceIds && sentenceId != this.lastSentenceId + 1) {
                            if (this.lastSentenceId < sentenceId) {
                                StringBuilder sb = new StringBuilder("Missing sentences");
                                for (int i = this.lastSentenceId + 1; i < sentenceId; ++i) {
                                    sb.append(" ").append(i);
                                }
                                logger.warning(sb.toString());
                            } else {
                                logger.warning("sentenceIds are not increasing (last=" + this.lastSentenceId + ", curr=" + sentenceId + ")");
                            }
                        }
                        this.lastSentenceId = sentenceId;
                        curParses = new ArrayList<ScoredObject<Object>>(parsesExpected);
                        continue;
                    }
                    if (curParse == null) {
                        double score = Double.parseDouble(line);
                        curParse = new ScoredObject<Object>(null, score);
                        curParses.add(curParse);
                        continue;
                    }
                    curParse.setObject(Trees.readTree(line));
                    curParse = null;
                    if (--parsesExpected != 0) continue;
                    return curParses;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public List<ScoredObject<Tree>> next() {
            if (!this.done) {
                List<ScoredObject<Tree>> cur = this.next;
                this.next = this.getNext();
                ++this.processed;
                if (this.next == null) {
                    logger.finer("Read " + this.processed + " trees, from " + this.inputDesc + " in " + this.timing.toSecondsString() + " secs");
                    this.done = true;
                    if (this.closeBufferNeeded) {
                        try {
                            this.br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                return cur;
            }
            throw new NoSuchElementException("No more elements from " + this.inputDesc);
        }
    }
}

