# Generated by default/object.tt
package Paws::EMR::ComputeLimits;
  use Moose;
  has MaximumCapacityUnits => (is => 'ro', isa => 'Int', required => 1);
  has MaximumCoreCapacityUnits => (is => 'ro', isa => 'Int');
  has MaximumOnDemandCapacityUnits => (is => 'ro', isa => 'Int');
  has MinimumCapacityUnits => (is => 'ro', isa => 'Int', required => 1);
  has UnitType => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EMR::ComputeLimits

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EMR::ComputeLimits object:

  $service_obj->Method(Att1 => { MaximumCapacityUnits => $value, ..., UnitType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EMR::ComputeLimits object:

  $result = $service_obj->Method(...);
  $result->Att1->MaximumCapacityUnits

=head1 DESCRIPTION

The EC2 unit limits for a managed scaling policy. The managed scaling
activity of a cluster can not be above or below these limits. The limit
only applies to the core and task nodes. The master node cannot be
scaled after initial configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MaximumCapacityUnits => Int

The upper boundary of EC2 units. It is measured through vCPU cores or
instances for instance groups and measured through units for instance
fleets. Managed scaling activities are not allowed beyond this
boundary. The limit only applies to the core and task nodes. The master
node cannot be scaled after initial configuration.


=head2 MaximumCoreCapacityUnits => Int

The upper boundary of EC2 units for core node type in a cluster. It is
measured through vCPU cores or instances for instance groups and
measured through units for instance fleets. The core units are not
allowed to scale beyond this boundary. The parameter is used to split
capacity allocation between core and task nodes.


=head2 MaximumOnDemandCapacityUnits => Int

The upper boundary of On-Demand EC2 units. It is measured through vCPU
cores or instances for instance groups and measured through units for
instance fleets. The On-Demand units are not allowed to scale beyond
this boundary. The parameter is used to split capacity allocation
between On-Demand and Spot Instances.


=head2 B<REQUIRED> MinimumCapacityUnits => Int

The lower boundary of EC2 units. It is measured through vCPU cores or
instances for instance groups and measured through units for instance
fleets. Managed scaling activities are not allowed beyond this
boundary. The limit only applies to the core and task nodes. The master
node cannot be scaled after initial configuration.


=head2 B<REQUIRED> UnitType => Str

The unit type used for specifying a managed scaling policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EMR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

