/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* ptemplat.c
**/

#include <stdlib.h>
#include <string.h>

#include "list.h"
#include "pfile.h"
#include "putil.h"
#include "ptemplat.h"
#include "parameter.h"
#include "tmatch.h"

pmatchlist
pmatchopen (
            ParamFile pfile,
            char *ptemplate
            )
{
  ParamMatchList *mlist;
  ParamList *plist;
  void *list = NULL;
  int leng = 0;
  int i;

  if (pfile == NULL)
    return NULL;
  if (pfile->psets == NULL)
    return NULL;

  if (ptemplate && !strcmp (ptemplate, "*"))
    ptemplate = NULL;
  plist = pfile->psets;

  for (i = plist->nparam; i--;)
    if (plist->param[i]->ptype != CommentType
	&& ((ptemplate == NULL)
	    || cxctmatch (plist->param[i]->pname, ptemplate)))
      {
	ParamMatchEntry *e;

	e = (ParamMatchEntry *) malloc (sizeof (ParamMatchEntry));
	e->next = NULL;
	e->name = CXCNewString (plist->param[i]->pname);
	list = (ParamMatchEntry *) ListPush (list, e);
	leng++;
      }

  mlist = (ParamMatchList *) malloc (sizeof (ParamMatchList));

  mlist->list = list;
  mlist->next = list;
  mlist->leng = leng;

  return mlist;
}


char *
pmatchnext (ParamMatchList *mlist)
{
  char *name;

  if (mlist == NULL)
    return NULL;

  name = mlist->next ? mlist->next->name : NULL;
  mlist->next = mlist->next ? mlist->next->next : NULL;

  return name;
}


void 
pmatchrewind (ParamMatchList *mlist)
{
  mlist->next = mlist->list;
}


int 
pmatchlength (ParamMatchList *mlist)
{
  return mlist->leng;
}


void 
pmatchclose (ParamMatchList *mlist)
{
  ParamMatchEntry *e;
  ParamMatchEntry *next;

  if (mlist == NULL)
    return;

  if (mlist->list == NULL)
    {
      free (mlist);
      mlist = NULL;
      return;
    }
  next = mlist->list;
  free (mlist);
  mlist = NULL;

  while (NULL != (e = next))
    {
      next = (ParamMatchEntry *) ListPop (e);
      free (e->name);
      free (e);
      e = NULL;
    };
}
