######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT -11
package Geo::Location::TimeZone::X;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude -172.5 to -157.5
	"-11" => {
		# Grid -11:-6 ; 3 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"16" => {
				"z" => "Etc/GMT-12",
				"c" => "ESRI",
				"s" => "5,2",
				"p" => [[-172.498655394021,-82.5],[-172.498626708984,-83.3000030517578],[-172.498382568359,-90],[-172.5,-90],[-172.5,-82.5],[-172.498655394021,-82.5],],
			},
			"246" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-157.5,-82.5],[-157.5,-90],[-157.50634765625,-90],[-157.50634765625,-82.5],[-172.5,-82.5],[-157.5,-82.5],],
			},
		},
		# Grid -11:-5 ; 2 records
		"-5" => {
			"def_z" => "Etc/GMT-10",
			"17" => {
				"z" => "Etc/GMT-12",
				"c" => "ESRI",
				"s" => "5,2",
				"p" => [[-172.498382568359,-82.5],[-172.5,-82.5],[-172.5,-67.5],[-172.499193236413,-67.5],[-172.498655394021,-82.5],[-172.498382568359,-82.5],],
			},
		},
		# Grid -11:-4 ; 2 records
		"-4" => {
			"def_z" => "Etc/GMT-10",
			"18" => {
				"z" => "Etc/GMT-12",
				"c" => "ESRI",
				"s" => "5,2",
				"p" => [[-172.498382568359,-67.5],[-172.5,-67.5],[-172.5,-52.5],[-172.499731078804,-52.5],[-172.499193236413,-67.5],[-172.498382568359,-67.5],],
			},
		},
		# Grid -11:-3 ; 2 records
		"-3" => {
			"def_z" => "Etc/GMT-10",
			"19" => {
				"z" => "Etc/GMT-12",
				"c" => "ESRI",
				"s" => "5,2",
				"p" => [[-172.498382568359,-52.5],[-172.5,-52.5],[-172.5,-45],[-172.499731078804,-52.5],[-172.498382568359,-52.5],],
			},
		},
		# Grid -11:-2 ; 1 records
		"-2" => {
			"250" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-157.5,-37.5],[-157.50634765625,-37.5],[-157.50634765625,-22.5178050994873],[-167.540451049805,-22.5178050994873],[-167.540451049805,-22.5],[-157.5,-22.5],[-157.5,-37.5],],
			},
		},
		# Grid -11:-1 ; 2 records
		"-1" => {
			"def_z1" => "-160.0,-21.0,Pacific/Rarotonga",
			"def_z0" => "-171.25,-9.416667,Pacific/Fakaofo",
			"296" => {
				"z1" => "-171.7333333,-13.8333333,Pacific/Apia",
				"z0" => "-172.333333,-13.583333,Pacific/Samoa",
				"z2" => "-170.7025000,-14.2780556,Pacific/Pago_Pago",
				"z3" => "-169.869722,-19.063333,Pacific/Niue",
				"c" => "ESRI",
				"s" => "18,2",
				"p" => [[-172.5,-22.5],[-172.5,-7.5],[-172.5,-10.4988364420371],[-167.540451049805,-10.4612655639648],[-167.540451049805,-22.5],[-157.50634765625,-22.5],[-172.5,-22.5],],
			},
		},
		# Grid -11:0 ; 2 records
		"0" => {
			"def_z" => "Pacific/Kiritimati",
			"297" => {
				"z" => "Pacific/Enderbury",
				"c" => "ESRI",
				"s" => "18,2",
				"p" => [[-172.5,-7.5],[-172.5,7.5],[-167.540451049805,7.5],[-167.540451049805,-7.09237575531006],[-172.5,-7.0735907550118],[-172.5,-7.5],[-157.50634765625,-7.5],[-172.5,-7.5],],
			},
		},
		# Grid -11:1 ; 1 records
		"1" => {
			"253" => {
				"z1" => "-157.8583333,21.3069444,Pacific/Honolulu",
				"z0" => "-169.516667,16.75,Pacific/Johnston",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.5,7.5],[-167.540451049805,7.5],[-167.540451049805,14.4072561264038],[-172.5,14.4327389046082],[-172.5,22.5],[-157.5,22.5],[-157.5,7.5],[-172.5,7.5],],
			},
		},
		# Grid -11:2 ; 1 records
		"2" => {
			"254" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.5,22.5],[-172.5,22.550802230835],[-172.483413696289,22.550802230835],[-172.483413696289,26.5355262756348],[-157.506362915039,26.5355262756348],[-157.506362915039,37.5],[-157.5,37.5],[-157.5,22.5],[-172.5,22.5],],
			},
		},
		# Grid -11:3 ; 3 records
		"3" => {
			"def_z" => "America/Anchorage",
			"240" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,3",
				"p" => [[-169.38975259246,52.5],[-169.38932800293,50.0106353759766],[-172.5,50.0105380809456],[-172.5,52.5],[-169.38975259246,52.5],],
			},
			"255" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.5,37.5],[-157.506362915039,37.5],[-157.506362915039,50.0267791748047],[-157.5,50.0267878209769],[-157.5,37.5],[-172.5,37.5],],
			},
		},
		# Grid -11:4 ; 3 records
		"4" => {
			"def_z" => "America/Anchorage",
			"241" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,3",
				"p" => [[-172.5,55.0266532897949],[-172.5,55.0223144913913],[-169.390182495117,55.0205154418945],[-169.38975259246,52.5],[-172.5,52.5],[-172.5,55.0266532897949],],
			},
			"430" => {
				"z" => "Etc/GMT+12",
				"c" => "ESRI",
				"s" => "28,2",
				"p" => [[-169,67.5],[-169,65.5],[-172.5,63.4166667244651],[-172.5,67.5],[-169,67.5],],
			},
		},
		# Grid -11:5 ; 3 records
		"5" => {
			"def_z" => "America/Anchorage",
			"230" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,1",
				"p" => [[-157.5,70.3247604370117],[-157.5,71.3764756165549],[-157.525619506836,71.3782653808594],[-157.525619506836,82.5],[-157.5,82.5],[-157.5,70.3247604370117],],
			},
			"431" => {
				"z" => "Etc/GMT+12",
				"c" => "ESRI",
				"s" => "28,2",
				"p" => [[-172.5,70.2272685764976],[-169,68],[-169,67.5],[-172.5,67.5],[-172.5,75],[-172.5,70.2272685764976],],
			},
		},
		# Grid -11:6 ; 1 records
		"6" => {
			"231" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,1",
				"p" => [[-157.5,82.5],[-157.525619506836,82.5],[-157.525619506836,90],[-157.5,90],[-157.5,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
